/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.server.ResourceDeployerFactory;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ResourcesLoader {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private ResourceDeployerFactory factory_ = new ResourceDeployerFactory();

    public void load() {
    }

    public void load(ConfigBean[][] configbeanArray) {
        if (configbeanArray == null) {
            return;
        }
        for (int j = 0; j < configbeanArray.length; ++j) {
            if (configbeanArray[j] == null || configbeanArray[j].length == 0) continue;
            ConfigBean[] configBeanSet = configbeanArray[j];
            ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
            String resourceType = resourceUtil.getResourceType(configBeanSet[0]);
            if (resourceType == null) {
                _logger.log(Level.SEVERE, "core.no_resource_type");
                continue;
            }
            ResourceDeployer deployer = null;
            try {
                deployer = this.factory_.getResourceDeployer(resourceType);
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "core.no_resource_deployer", resourceType);
                _logger.log(Level.SEVERE, "", ex);
                continue;
            }
            for (int i = 0; i < configBeanSet.length; ++i) {
                try {
                    if (!resourceUtil.isEnabled(configBeanSet[i])) continue;
                    deployer.deployResource(configBeanSet[i]);
                    continue;
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "core.resource_loading_error");
                    _logger.log(Level.SEVERE, "", ex);
                }
            }
        }
    }
}

