/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ConnectorPublicID
extends ConnectorTest
implements ConnectorCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result check(ConnectorDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        String[] acceptablePubidLiterals = new String[]{"-//Sun Microsystems, Inc.//DTD Connector 1.0//EN"};
        String[] acceptableURLs = new String[]{"http://java.sun.com/dtd/connector_1_0.dtd"};
        if (descriptor.getSpecVersion().compareTo("1.5") < 0) {
            InputStream deploymentEntry = null;
            BufferedReader in = null;
            String uri = null;
            try {
                uri = this.getAbstractArchiveUri(descriptor);
                FileArchive arch = new FileArchive();
                arch.open(uri);
                deploymentEntry = arch.getEntry("META-INF/ra.xml");
                if (deploymentEntry == null) return result;
                in = new BufferedReader(new InputStreamReader(deploymentEntry));
                String s = in.readLine();
                boolean foundDOCTYPE = false;
                boolean foundPubid = false;
                boolean foundURL = false;
                while (s != null) {
                    if (s.indexOf("DOCTYPE") > -1) {
                        foundDOCTYPE = true;
                    }
                    if (foundDOCTYPE) {
                        for (int i = 0; i < acceptablePubidLiterals.length; ++i) {
                            if (s.indexOf(acceptablePubidLiterals[i]) > -1) {
                                foundPubid = true;
                                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The deployment descriptor has the proper PubidLiteral: {0}", new Object[]{acceptablePubidLiterals[i]}));
                            }
                            if (s.indexOf(acceptableURLs[i]) <= -1) continue;
                            foundURL = true;
                            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed1", "The deployment descriptor has the proper URL corresponding to the PubIdLiteral: {0}", new Object[]{acceptableURLs[i]}));
                        }
                    }
                    if (foundPubid && foundURL) {
                        result.setStatus(0);
                        break;
                    }
                    if (foundDOCTYPE && s.endsWith(">")) break;
                    s = in.readLine();
                }
                if (!foundDOCTYPE) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "No document type declaration found in the deployment descriptor for {0}", new Object[]{descriptor.getName()}));
                    return result;
                }
                if (!foundPubid) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "The deployment descriptor for {0} does not have an expected PubidLiteral ", new Object[]{descriptor.getName()}));
                    return result;
                }
                if (foundURL) return result;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The deployment descriptor {0} doesnot have the right URL corresponding to the PubIdLiteral", new Object[]{descriptor.getName()}));
                return result;
            }
            catch (IOException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".IOException", "I/O error trying to open {0}", new Object[]{uri}));
                return result;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (deploymentEntry != null) {
                        deploymentEntry.close();
                    }
                }
                catch (Exception x) {}
            }
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT-APPLICABLE: No DOCTYPE found for [ {0} ]", new Object[]{descriptor.getName()}));
        return result;
    }
}

