/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.Resource;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ResourceCache {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private Hashtable resources = new Hashtable();
    private int count;

    public ResourceCache(int count) {
        this.count = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(Object name) throws Exception {
        Object resource = null;
        Vector<Resource> list = null;
        Resource r = null;
        Hashtable hashtable = this.resources;
        synchronized (hashtable) {
            list = (Vector<Resource>)this.resources.get(name);
            if (list == null) {
                list = new Vector<Resource>(this.count);
                this.resources.put(name, list);
            }
        }
        boolean newR = false;
        Vector<Resource> vector = list;
        synchronized (vector) {
            while (resource == null) {
                for (int i = 0; i < list.size(); ++i) {
                    r = (Resource)list.elementAt(i);
                    if (!r.isAvailable()) continue;
                    r.markInUse();
                    resource = r.getResource();
                    break;
                }
                if (resource != null) continue;
                if (list.size() < this.count) {
                    r = new Resource();
                    list.addElement(r);
                    newR = true;
                    break;
                }
                if (newR) continue;
                list.wait();
            }
        }
        if (newR) {
            try {
                resource = this.createResource(name);
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "enterprise_util.excep_rescache_getres", ex);
            }
            vector = list;
            synchronized (vector) {
                r.setResource(resource);
                r.markInUse();
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnResource(Object name, Object oldResource, Object newResource) {
        Resource r = null;
        Vector list = (Vector)this.resources.get(name);
        if (list != null) {
            Vector vector = list;
            synchronized (vector) {
                for (int i = 0; i < list.size(); ++i) {
                    r = (Resource)list.elementAt(i);
                    if (r.getResource() != oldResource) continue;
                    r.setResource(newResource);
                    r.markAvailable();
                    list.notifyAll();
                    break;
                }
            }
        }
    }

    public abstract Object createResource(Object var1) throws Exception;
}

