/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.collection;

import com.sun.enterprise.util.collection.Bucket;
import com.sun.enterprise.util.collection.IntEntry;
import com.sun.enterprise.util.collection.LongEntry;
import java.util.ArrayList;
import java.util.Iterator;

public class LongSortedArrayListBucket
implements Bucket {
    protected ArrayList entries = new ArrayList();

    LongSortedArrayListBucket() {
    }

    public Object put(int searchKey, Object object) {
        return this.put((long)searchKey, object);
    }

    public Object put(long searchKey, Object object) {
        int low = 0;
        int high = this.entries.size() - 1;
        int entryKey = 0;
        IntEntry entry = null;
        while (low <= high) {
            int mid = (low + high) / 2;
            entry = (IntEntry)this.entries.get(mid);
            entryKey = entry.key;
            if ((long)entryKey == searchKey) {
                Object oldObject = entry.object;
                entry.object = object;
                return oldObject;
            }
            if (searchKey < (long)entryKey) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        this.entries.add(low, new LongEntry(searchKey, object));
        return null;
    }

    public Object get(int searchKey) {
        return this.get((long)searchKey);
    }

    public Object get(long searchKey) {
        int low = 0;
        int high = this.entries.size() - 1;
        long entryKey = 0L;
        LongEntry entry = null;
        while (low <= high) {
            int mid = (low + high) / 2;
            entry = (LongEntry)this.entries.get(mid);
            entryKey = entry.key;
            if (entryKey == searchKey) {
                return entry.object;
            }
            if (searchKey < entryKey) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return null;
    }

    public Object remove(int searchKey) {
        return this.remove((long)searchKey);
    }

    public Object remove(long searchKey) {
        int low = 0;
        int high = this.entries.size() - 1;
        int entryKey = 0;
        IntEntry entry = null;
        while (low <= high) {
            int mid = (low + high) / 2;
            entry = (IntEntry)this.entries.get(mid);
            entryKey = entry.key;
            if ((long)entryKey == searchKey) {
                this.entries.remove(mid);
                return entry.object;
            }
            if (searchKey < (long)entryKey) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return null;
    }

    public boolean containsKey(int searchKey) {
        return this.get((long)searchKey) != null;
    }

    public boolean containsKey(long searchKey) {
        return this.get(searchKey) != null;
    }

    public int size() {
        return this.entries.size();
    }

    public Iterator iterator() {
        return new BucketIterator(this.entries, false);
    }

    public Iterator entryIterator() {
        return new BucketIterator(this.entries, true);
    }

    private class BucketIterator
    implements Iterator {
        ArrayList entries;
        int index = 0;
        boolean iterateEntry;

        BucketIterator(ArrayList entries, boolean iterateEntry) {
            this.entries = entries;
            this.index = 0;
            this.iterateEntry = iterateEntry;
        }

        public boolean hasNext() {
            return this.index < this.entries.size();
        }

        public Object next() {
            return this.iterateEntry ? this.entries.get(this.index++) : ((IntEntry)this.entries.get((int)this.index++)).object;
        }

        public void remove() {
        }
    }
}

