/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.web.LifecycleStarter;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleContextConfig;
import com.sun.enterprise.web.WebModuleListener;
import com.sun.enterprise.web.connector.coyote.PECoyoteConnector;
import com.sun.web.server.WebContainerListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.logger.FileLogger;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Embedded;

public final class EmbeddedWebContainer
extends Embedded {
    private Logger _logger = null;
    private WebContainerFeatureFactory webContainerFeatureFactory;
    private WebContainer webContainer;
    private String logServiceFile;

    public EmbeddedWebContainer(Logger webLogger, ServerContext serverContext, WebContainer webContainer, String logServiceFile) {
        this._logger = webLogger;
        this.webContainer = webContainer;
        this.logServiceFile = logServiceFile;
        this.webContainerFeatureFactory = serverContext.getPluggableFeatureFactory().getWebContainerFeatureFactory();
    }

    public Host createHost(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String vsDocroot, String vsLogFile, MimeMap vsMimeMap) {
        ContainerListener listener;
        VirtualServer vs = this.webContainerFeatureFactory.getVirtualServer();
        vs.setDebug(this.debug);
        vs.setAppBase(vsDocroot);
        vs.setName(vsID);
        vs.setID(vsID);
        vs.setBean(vsBean);
        vs.setMimeMap(vsMimeMap);
        String defaultContextXmlLocation = "config/context.xml";
        String defaultWebXmlLocation = "config/default-web.xml";
        boolean allowLinking = false;
        String state = null;
        if (vsBean != null) {
            state = vsBean.getState();
            ElementProperty prop = null;
            prop = vsBean.getElementPropertyByName("default-web-xml");
            if (prop != null) {
                defaultWebXmlLocation = prop.getValue();
            }
            if ((prop = vsBean.getElementPropertyByName("allowLinking")) != null) {
                allowLinking = ConfigBean.toBoolean(prop.getValue());
            }
            if ((prop = vsBean.getElementPropertyByName("contextXmlDefault")) != null) {
                defaultContextXmlLocation = prop.getValue();
            }
        }
        vs.setDefaultWebXmlLocation(defaultWebXmlLocation);
        vs.setDefaultContextXmlLocation(defaultContextXmlLocation);
        if (state == null) {
            state = "on";
        }
        if ("disabled".equalsIgnoreCase(state)) {
            vs.setIsActive(false);
        } else {
            vs.setIsActive(ConfigBean.toBoolean(state));
        }
        vs.setAllowLinking(allowLinking);
        if (vsLogFile != null && !vsLogFile.equals(this.logServiceFile)) {
            this.setLogFile(vs, vsLogFile);
        }
        if ((listener = this.loadListener("com.sun.enterprise.web.connector.extension.CatalinaListener")) != null) {
            vs.addContainerListener(listener);
        }
        return vs;
    }

    public Context createContext(String ctxPath, String location, String defaultContextXmlLocation, String defaultWebXmlLocation, boolean useDOLforDeployment, WebBundleDescriptor wbd) {
        ContextConfig config;
        File configFile = new File(location, "META-INF/context.xml");
        WebModule context = new WebModule(this.webContainer);
        context.setDebug(this.debug);
        context.setPath(ctxPath);
        context.setDocBase(location);
        context.setCrossContext(true);
        context.setUseNaming(this.isUseNaming());
        context.setHasWebXml(wbd != null);
        context.setWebBundleDescriptor(wbd);
        context.setManagerChecksFrequency(1);
        if (configFile.exists()) {
            context.setConfigFile(configFile.getAbsolutePath());
        }
        if (useDOLforDeployment) {
            config = new WebModuleContextConfig();
            ((WebModuleContextConfig)config).setDescriptor(wbd);
        } else {
            config = new ContextConfig();
        }
        config.setDefaultContextXml(defaultContextXmlLocation);
        config.setDefaultWebXml(defaultWebXmlLocation);
        context.addLifecycleListener(config);
        context.addLifecycleListener(new WebModuleListener(this.webContainer.getInstanceClassPath(), location, wbd));
        context.addInstanceListener("com.sun.web.server.J2EEInstanceListener");
        context.addContainerListener(new WebContainerListener());
        context.addInstanceListener("com.sun.enterprise.admin.monitor.callflow.WebContainerListener");
        return context;
    }

    private ContainerListener loadListener(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (ContainerListener)clazz.newInstance();
        }
        catch (Throwable ex) {
            this._logger.log(Level.SEVERE, ex.getMessage() + ":" + className, ex);
            return null;
        }
    }

    public Engine[] getEngines() {
        return this.engines;
    }

    public Connector[] getConnectors() {
        return this.connectors;
    }

    protected void setLogFile(Host vs, String logFile) {
        String logPrefix = logFile;
        String logDir = null;
        String logSuffix = null;
        if (logPrefix == null || logPrefix.equals("")) {
            return;
        }
        int index = logPrefix.lastIndexOf(File.separatorChar);
        if (index != -1) {
            logDir = logPrefix.substring(0, index);
            logPrefix = logPrefix.substring(index + 1);
        }
        if ((index = logPrefix.indexOf(46)) != -1) {
            logSuffix = logPrefix.substring(index);
            logPrefix = logPrefix.substring(0, index);
        }
        logPrefix = logPrefix + "_";
        FileLogger contextLogger = new FileLogger();
        if (logDir != null) {
            contextLogger.setDirectory(logDir);
        }
        contextLogger.setPrefix(logPrefix);
        if (logSuffix != null) {
            contextLogger.setSuffix(logSuffix);
        }
        contextLogger.setTimestamp(true);
        vs.setLogger(contextLogger);
    }

    public Connector createConnector(String address, int port, String protocol) {
        int index;
        if (address != null && (index = address.indexOf(47)) != -1) {
            address = address.substring(index + 1);
        }
        this._logger.log(Level.FINE, "Creating connector for address='" + (address == null ? "ALL" : address) + "' port='" + port + "' protocol='" + protocol + "'");
        PECoyoteConnector connector = new PECoyoteConnector();
        if (address != null) {
            connector.setAddress(address);
        }
        connector.setPort(port);
        if (protocol.equals("ajp")) {
            connector.setProtocolHandlerClassName("org.apache.jk.server.JkCoyoteHandler");
        } else if (protocol.equals("memory")) {
            connector.setProtocolHandlerClassName("org.apache.coyote.memory.MemoryProtocolHandler");
        } else if (protocol.equals("https")) {
            connector.setScheme("https");
            connector.setSecure(true);
        }
        return connector;
    }

    public Engine createEngine() {
        WebEngine engine = new WebEngine(this.webContainer, this._logger);
        engine.setDebug(this.debug);
        engine.setLogger(this.logger);
        engine.setRealm(null);
        ContainerListener listener = this.loadListener("com.sun.enterprise.admin.monitor.callflow.WebContainerListener");
        if (listener != null) {
            engine.addContainerListener(listener);
        }
        return engine;
    }

    static class WebEngine
    extends StandardEngine {
        private WebContainer webContainer;
        private Logger _logger;
        private ResourceBundle _rb;

        public WebEngine(WebContainer webContainer, Logger _logger) {
            this.webContainer = webContainer;
            this._logger = _logger;
            this._rb = _logger.getResourceBundle();
        }

        public Realm getRealm() {
            return null;
        }

        protected void startChildren() {
            new File(this.webContainer.getAppsWorkRoot()).mkdirs();
            new File(this.webContainer.getModulesWorkRoot()).mkdirs();
            ArrayList<LifecycleStarter> starters = new ArrayList<LifecycleStarter>();
            Container[] children = this.findChildren();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof Lifecycle)) continue;
                LifecycleStarter starter = new LifecycleStarter((Lifecycle)((Object)children[i]));
                starters.add(starter);
                starter.submit();
            }
            for (LifecycleStarter starter : starters) {
                Throwable t = starter.waitDone();
                if (t == null) continue;
                Lifecycle container = starter.getContainer();
                String msg = this._rb.getString("embedded.startVirtualServerError");
                msg = MessageFormat.format(msg, container);
                this._logger.log(Level.SEVERE, msg, t);
            }
        }
    }
}

