/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.ssl;

import com.sun.enterprise.web.connector.grizzly.DefaultProcessorTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLOutputBuffer;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLReadTask;
import java.util.logging.Level;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.filters.BufferedInputFilter;

public class SSLProcessorTask
extends DefaultProcessorTask {
    private SSLReadTask sslReadTask;

    public SSLProcessorTask() {
        this(true, true);
    }

    public SSLProcessorTask(boolean init, boolean bufferResponse) {
        super(init, bufferResponse);
    }

    public void initialize() {
        this.started = true;
        this.request = new Request();
        this.response = new Response();
        this.response.setHook(this);
        this.inputBuffer = new InternalInputBuffer(this.request, this.requestBufferSize);
        this.outputBuffer = new SSLOutputBuffer(this.response, this.maxHttpHeaderSize, this.bufferResponse);
        this.request.setInputBuffer(this.inputBuffer);
        this.response.setOutputBuffer(this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters();
    }

    public void action(ActionCode actionCode, Object param) {
        block14: {
            if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
                try {
                    if (this.sslSupport == null) break block14;
                    Object sslO = this.sslSupport.getCipherSuite();
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = this.sslReadTask.doPeerCertificateChain(false)) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                    }
                }
                catch (Exception e) {
                    SelectorThread.logger().log(Level.WARNING, "processorTask.errorSSL", e);
                }
            } else if (actionCode == ActionCode.ACTION_REQ_SSL_CERTIFICATE) {
                if (this.sslSupport != null) {
                    InputFilter[] inputFilters = this.inputBuffer.getFilters();
                    ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxPostSize);
                    this.inputBuffer.addActiveFilter(inputFilters[3]);
                    try {
                        Object[] sslO = this.sslReadTask.doPeerCertificateChain(true);
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                    }
                    catch (Exception e) {
                        SelectorThread.logger().log(Level.WARNING, "processorTask.exceptionSSLcert", e);
                    }
                }
            } else {
                super.action(actionCode, param);
            }
        }
    }

    public void setSslReadTask(SSLReadTask sslReadTask) {
        this.sslReadTask = sslReadTask;
    }
}

