/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.jdbc40;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.spi.ManagedConnection;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ConnectionRequestInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHolder40
extends ConnectionHolder {
    protected Properties defaultClientInfo;
    protected static final StringManager localStrings = StringManager.getManager(ManagedConnectionFactory.class);
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    protected boolean jdbc30Connection;

    public ConnectionHolder40(Connection con, ManagedConnection mc, ConnectionRequestInfo cxRequestInfo, boolean jdbc30Connection) {
        super(con, mc, cxRequestInfo);
        this.jdbc30Connection = jdbc30Connection;
        if (!jdbc30Connection) {
            this.init();
        }
    }

    protected void init() {
        try {
            this.defaultClientInfo = this.getClientInfo();
        }
        catch (SQLException e) {
            _logger.log(Level.WARNING, "jdbc.unable_to_get_client_info", e);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkValidity();
        return this.con.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkValidity();
        }
        catch (SQLException sqe) {
            SQLClientInfoException sce = new SQLClientInfoException();
            sce.setStackTrace(sqe.getStackTrace());
            throw sce;
        }
        this.con.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkValidity();
        }
        catch (SQLException sqe) {
            SQLClientInfoException sce = new SQLClientInfoException();
            sce.setStackTrace(sqe.getStackTrace());
            throw sce;
        }
        this.con.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkValidity();
        return this.con.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkValidity();
        return this.con.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createStruct(typeName, attributes);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkValidity();
        T result = null;
        if (iface.isInstance(this)) {
            result = iface.cast(this);
        } else if (iface.isInstance(this.con)) {
            Class[] listIntf = new Class[]{iface};
            result = this.getProxyObject(this.con, listIntf);
        } else {
            result = this.con.unwrap(iface);
            if (Connection.class.isInstance(result)) {
                Class[] listIntf = new Class[]{iface, Connection.class};
                result = this.getProxyObject(result, listIntf);
            }
        }
        return result;
    }

    private <T> T getProxyObject(final Object actualObject, Class<T>[] ifaces) throws SQLException {
        InvocationHandler ih;
        try {
            ih = new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws SQLException, IllegalAccessException, InvocationTargetException {
                    if (method.getName().equals("close") && method.getParameterTypes().length == 0) {
                        String msg = localStrings.getString("jdbc.close_called_on_proxy_object", actualObject);
                        _logger.log(Level.FINE, msg);
                        ConnectionHolder40.this.close();
                        return null;
                    }
                    return method.invoke(actualObject, args);
                }
            };
        }
        catch (Exception e) {
            throw new SQLException(e.fillInStackTrace());
        }
        Object result = Proxy.newProxyInstance(actualObject.getClass().getClassLoader(), ifaces, ih);
        return (T)result;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkValidity();
        boolean result = iface.isInstance(this) ? true : this.con.isWrapperFor(iface);
        return result;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "jdbc.duplicate_close_connection", this);
            }
            return;
        }
        if (!this.jdbc30Connection) {
            try {
                this.checkValidity();
                if (this.defaultClientInfo == null) {
                    this.setClientInfo(new Properties());
                } else {
                    this.setClientInfo(this.defaultClientInfo);
                }
            }
            catch (SQLClientInfoException e) {
                _logger.log(Level.WARNING, "jdbc.unable_to_set_client_info", e);
            }
        }
        super.close();
    }
}

