/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.access;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessList {
    private static final transient Logger LOG = Logger.getLogger(AccessList.class.getName());
    private static final String PEER_TAG = "peer";
    private static final String NAME_TAG = "name";
    private static final String DESCRIPTION_TAG = "description";
    private static final String GRANTALL_TAG = "grantAll";
    private static final String ACCESS_TAG = "access";
    private static final String ACCESS_TAG_DENY_VALUE = "deny";
    private static final String ACCESS_TAG_GRANT_VALUE = "grant";
    protected final Map<ID, Entry> accessMap = new HashMap<ID, Entry>();
    String description = null;
    boolean grantAll = false;

    public AccessList() {
    }

    public AccessList(InputStream stream) throws IOException {
        this.init(stream);
    }

    public AccessList(URI uri) throws IOException {
        this.init(uri);
    }

    public void init(URI uri) throws IOException {
        InputStream input = this.getInputStream(uri);
        this.init(input);
        input.close();
    }

    public void init(File fromFile) throws IOException {
        FileInputStream is = new FileInputStream(fromFile);
        this.init(is);
        ((InputStream)is).close();
    }

    @Deprecated
    public void refresh(File file) {
        if (file.exists()) {
            try {
                FileInputStream is = new FileInputStream(file);
                this.refresh(is);
                ((InputStream)is).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void refresh(InputStream stream) throws IOException {
        AccessList tmp = new AccessList(stream);
        this.refresh(tmp);
    }

    public void refresh(URI uri) throws IOException {
        InputStream input = this.getInputStream(uri);
        AccessList tmp = new AccessList(input);
        this.refresh(tmp);
        input.close();
    }

    private InputStream getInputStream(URI uri) throws IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Loading ACL : " + uri.toString());
        }
        URL url = uri.toURL();
        URLConnection connection = url.openConnection();
        connection.setDoInput(true);
        return connection.getInputStream();
    }

    private void init(InputStream stream) throws IOException {
        XMLDocument doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, stream);
        this.initialize(doc);
    }

    public AccessList(Map<ID, Entry> map) {
        this.accessMap.clear();
        this.accessMap.putAll(map);
    }

    public AccessList(Element root) {
        if (!(root instanceof XMLElement)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        if (!AccessList.getAdvertisementType().equals(doc.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.initialize(doc);
    }

    public String getDescrption() {
        return this.description;
    }

    public boolean getGrantAll() {
        return this.grantAll;
    }

    public void setGrantAll(boolean grantAll) {
        this.grantAll = grantAll;
    }

    public void setDescrption(String description) {
        this.description = description;
    }

    protected void setEntries(Map<ID, Entry> map) {
        this.accessMap.clear();
        this.accessMap.putAll(map);
    }

    private void refresh(AccessList acl) {
        this.grantAll = acl.grantAll;
        this.description = acl.description;
        this.accessMap.clear();
        this.accessMap.putAll(acl.accessMap);
    }

    public void add(Entry entry) {
        if (!this.accessMap.containsKey(entry.id)) {
            this.accessMap.put(entry.id, entry);
        }
    }

    public void remove(Entry entry) {
        if (this.accessMap.containsKey(entry.id)) {
            this.accessMap.remove(entry.id);
        }
    }

    public boolean isAllowed(ID id) {
        if (this.grantAll) {
            return true;
        }
        if (this.accessMap.containsKey(id)) {
            Entry entry = this.accessMap.get(id);
            return entry.access;
        }
        return false;
    }

    public Map<ID, Entry> getAccessMap() {
        return this.accessMap;
    }

    public Document getDocument(MimeMediaType asMimeType) {
        Object e;
        StructuredDocument adv = StructuredDocumentFactory.newStructuredDocument(asMimeType, AccessList.getAdvertisementType());
        if (adv instanceof XMLDocument) {
            ((XMLDocument)adv).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        if (this.grantAll) {
            e = adv.createElement(GRANTALL_TAG, Boolean.valueOf(this.grantAll).toString());
            adv.appendChild(e);
        }
        if (this.description != null) {
            e = adv.createElement(DESCRIPTION_TAG, this.description);
            adv.appendChild(e);
        }
        Iterator<Entry> i$ = this.accessMap.values().iterator();
        while (i$.hasNext()) {
            Entry o;
            Entry entry = o = i$.next();
            if (entry.id == null && entry.name == null) continue;
            e = adv.createElement(PEER_TAG, entry.id.toString());
            adv.appendChild(e);
            ((Attributable)e).addAttribute(NAME_TAG, entry.name);
            if (entry.access) {
                ((Attributable)e).addAttribute(ACCESS_TAG, ACCESS_TAG_GRANT_VALUE);
                continue;
            }
            ((Attributable)e).addAttribute(ACCESS_TAG, ACCESS_TAG_DENY_VALUE);
        }
        return adv;
    }

    protected void initialize(XMLElement doc) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (GRANTALL_TAG.equals(elem.getName())) {
                this.grantAll = Boolean.getBoolean(elem.getTextValue());
                if (!Logging.SHOW_CONFIG || !LOG.isLoggable(Level.CONFIG)) continue;
                LOG.config("Grant all access = [ " + this.grantAll + " ]");
                continue;
            }
            if (DESCRIPTION_TAG.equals(elem.getName())) {
                this.description = elem.getTextValue();
                if (!Logging.SHOW_CONFIG || !LOG.isLoggable(Level.CONFIG)) continue;
                LOG.config("Loading [ " + this.description + " ] access list :");
                continue;
            }
            if (PEER_TAG.equals(elem.getName())) {
                ID pid;
                String name = "NA";
                Attribute nameAttr = elem.getAttribute(NAME_TAG);
                if (nameAttr != null) {
                    name = nameAttr.getValue();
                }
                String access = ACCESS_TAG_GRANT_VALUE;
                Attribute accessAttr = elem.getAttribute(ACCESS_TAG);
                if (accessAttr != null) {
                    access = accessAttr.getValue();
                }
                boolean acl = ACCESS_TAG_GRANT_VALUE.equalsIgnoreCase(access);
                try {
                    URI id = new URI(elem.getTextValue().trim());
                    pid = IDFactory.fromURI(id);
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("unknown ID format in advertisement: " + elem.getTextValue());
                }
                Entry entry = new Entry(pid, name, acl);
                if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                    LOG.config("Adding entry to access list :" + entry);
                }
                this.accessMap.put(entry.id, entry);
                continue;
            }
            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unrecognized tag : " + elem.getName());
        }
    }

    public String toString() {
        try {
            XMLDocument doc = (XMLDocument)this.getDocument(MimeMediaType.XMLUTF8);
            return doc.toString();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    public static String getAdvertisementType() {
        return "jxta:XACL";
    }

    public static final class Entry {
        public final ID id;
        public final String name;
        public final boolean access;

        public Entry(ID id, String name, boolean access) {
            this.id = id;
            this.name = name;
            this.access = access;
        }

        public String toString() {
            return "[" + this.name + "  access = " + this.access + " : " + this.id.toString() + "]";
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && this.id.equals(((Entry)obj).id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

