/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.discovery;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.credential.Credential;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryListener;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.cm.Srdi;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.discovery.DiscoveryServiceInterface;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.protocol.DiscoveryConfigAdv;
import net.jxta.impl.protocol.DiscoveryQuery;
import net.jxta.impl.protocol.DiscoveryResponse;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.protocol.SrdiMessageImpl;
import net.jxta.impl.resolver.InternalQueryHandler;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.ResolverSrdiMsg;
import net.jxta.protocol.SrdiMessage;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import net.jxta.resolver.ResolverService;
import net.jxta.resolver.SrdiHandler;
import net.jxta.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryServiceImpl
implements DiscoveryService,
InternalQueryHandler,
RendezvousListener,
SrdiHandler,
Srdi.SrdiInterface {
    private static final Logger LOG = Logger.getLogger(DiscoveryServiceImpl.class.getName());
    static final String[] dirname = new String[]{"Peers", "Groups", "Adv"};
    private static final int REMOTE_PUBLISH_QUERYID = 0;
    private static final String srdiIndexerFileName = "discoverySrdi";
    private static final AtomicInteger qid = new AtomicInteger(0);
    private static final int MAX_RESPONSES = 50;
    protected Cm cm;
    private PeerGroup group = null;
    private String handlerName = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private ResolverService resolver = null;
    private RendezVousService rendezvous = null;
    private MembershipService membership = null;
    private PeerID localPeerId = null;
    private boolean localonly = false;
    private boolean alwaysUseReplicaPeer = false;
    private boolean stopped = true;
    private Set<DiscoveryListener> listeners = new HashSet<DiscoveryListener>();
    private Hashtable<Integer, DiscoveryListener> listenerTable = new Hashtable();
    private final String checkPeerAdvLock = new String("Check/Update PeerAdvertisement Lock");
    private PeerAdvertisement lastPeerAdv = null;
    private int lastModCount = -1;
    private boolean isRdv = false;
    private SrdiIndex srdiIndex = null;
    private Srdi srdi = null;
    private Thread srdiThread = null;
    private CredentialListener membershipCredListener = null;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private long initialDelay = 60000L;
    private long runInterval = 30000L;
    private DiscoveryService discoveryInterface = null;

    @Override
    public synchronized Service getInterface() {
        if (this.discoveryInterface == null) {
            this.discoveryInterface = new DiscoveryServiceInterface(this);
        }
        return this.discoveryInterface;
    }

    @Override
    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    @Override
    public int getRemoteAdvertisements(String peer, int type, String attribute, String value, int threshold) {
        return this.getRemoteAdvertisements(peer, type, attribute, value, threshold, null);
    }

    @Override
    public int getRemoteAdvertisements(String peer, int type, String attribute, String value, int threshold, DiscoveryListener listener) {
        int myQueryID = qid.incrementAndGet();
        if (this.localonly || this.stopped) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("localonly, no network operations performed");
            }
            return myQueryID;
        }
        if (this.resolver == null) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("resolver has not started yet, query discarded.");
            }
            return myQueryID;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            StringBuilder query = new StringBuilder("Sending query#" + myQueryID + " for " + threshold + " " + dirname[type] + " advs");
            if (attribute != null) {
                query.append("\n\tattr = ").append(attribute);
                if (value != null) {
                    query.append("\tvalue = ").append(value);
                }
            }
            LOG.fine(query.toString());
        }
        long t0 = System.currentTimeMillis();
        DiscoveryQuery dquery = new DiscoveryQuery();
        dquery.setDiscoveryType(type);
        dquery.setAttr(attribute);
        dquery.setValue(value);
        dquery.setThreshold(threshold);
        if (listener != null) {
            this.listenerTable.put(myQueryID, listener);
        }
        ResolverQuery query = new ResolverQuery();
        query.setHandlerName(this.handlerName);
        query.setCredential(this.credentialDoc);
        query.setSrcPeer(this.localPeerId);
        query.setQuery(((Object)dquery).toString());
        query.setQueryId(myQueryID);
        if (peer == null && this.srdiIndex != null) {
            PeerID destPeer;
            List<PeerID> res = this.srdiIndex.query(dirname[type], attribute, value, threshold);
            if (!res.isEmpty()) {
                this.srdi.forwardQuery(res, query, threshold);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Srdi forward a query #" + myQueryID + " in " + (System.currentTimeMillis() - t0) + "ms.");
                }
                return myQueryID;
            }
            if (this.group.isRendezvous() && attribute != null && value != null && (destPeer = this.srdi.getReplicaPeer(dirname[type] + attribute + value)) != null && !destPeer.equals(this.group.getPeerID())) {
                this.srdi.forwardQuery(destPeer, (ResolverQueryMsg)query);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Srdi forward query #" + myQueryID + " to " + destPeer + " in " + (System.currentTimeMillis() - t0) + "ms.");
                }
                return myQueryID;
            }
        }
        this.resolver.sendQuery(peer, query);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            if (peer == null) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Sent a query #" + myQueryID + " in " + (System.currentTimeMillis() - t0) + "ms.");
                }
            } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Sent a query #" + myQueryID + " to " + peer + " in " + (System.currentTimeMillis() - t0) + "ms.");
            }
        }
        return myQueryID;
    }

    @Override
    public Enumeration<Advertisement> getLocalAdvertisements(int type, String attribute, String value) throws IOException {
        if (type > 2 || type < 0) {
            throw new IllegalArgumentException("Unknown Advertisement type");
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            StringBuilder query = new StringBuilder("Searching for " + dirname[type] + " advs");
            if (attribute != null) {
                query.append("\n\tattr = ").append(attribute);
            }
            if (value != null) {
                query.append("\tvalue = ").append(value);
            }
            LOG.fine(query.toString());
        }
        return Collections.enumeration(this.search(type, attribute, value, Integer.MAX_VALUE, false, null));
    }

    @Override
    public void init(PeerGroup pg, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.group = pg;
        this.handlerName = assignedID.toString();
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.localPeerId = this.group.getPeerID();
        ConfigParams confAdv = pg.getConfigAdvertisement();
        if (confAdv != null) {
            Advertisement adv = null;
            try {
                XMLDocument configDoc = (XMLDocument)confAdv.getServiceParam(assignedID);
                if (null != configDoc) {
                    adv = AdvertisementFactory.newAdvertisement(configDoc);
                }
            }
            catch (NoSuchElementException failed) {
                // empty catch block
            }
            if (adv instanceof DiscoveryConfigAdv) {
                DiscoveryConfigAdv discoConfigAdv = (DiscoveryConfigAdv)adv;
                this.alwaysUseReplicaPeer = discoConfigAdv.getForwardAlwaysReplica();
                this.localonly |= discoConfigAdv.getLocalOnly();
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    if (this.localonly) {
                        LOG.fine("localonly set to true via service parameters");
                    }
                    if (this.alwaysUseReplicaPeer) {
                        LOG.fine("alwaysUseReplicaPeer set to true via service parameters");
                    }
                }
            }
        }
        this.cm = ((StdPeerGroup)this.group).getCacheManager();
        this.cm.setTrackDeltas(!this.localonly);
        this.checkUpdatePeerAdv();
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Discovery Service : " + assignedID);
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ").append(this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : ").append(this.group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : ").append(this.group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : ").append(this.group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tLocal Only : ").append(this.localonly);
            configInfo.append("\n\t\tAlways Use ReplicaPeer : ").append(this.alwaysUseReplicaPeer);
            LOG.config(configInfo.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startApp(String[] arg) {
        this.resolver = this.group.getResolverService();
        if (null == this.resolver) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a resolver service");
            }
            return 2;
        }
        this.membership = this.group.getMembershipService();
        if (null == this.membership) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a membership service");
            }
            return 2;
        }
        this.rendezvous = this.group.getRendezVousService();
        if (null == this.rendezvous) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a rendezvous service");
            }
            return 2;
        }
        if (!this.localonly) {
            this.resolver.registerHandler(this.handlerName, this);
        }
        DiscoveryServiceImpl discoveryServiceImpl = this;
        synchronized (discoveryServiceImpl) {
            block15: {
                this.membershipCredListener = new CredentialListener();
                this.membership.addPropertyChangeListener("defaultCredential", this.membershipCredListener);
                try {
                    this.membershipCredListener.propertyChange(new PropertyChangeEvent(this.membership, "defaultCredential", null, this.membership.getDefaultCredential()));
                }
                catch (Exception all) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block15;
                    LOG.log(Level.WARNING, "Could not get credential", all);
                }
            }
        }
        if (this.rendezvous.isRendezVous()) {
            this.beRendezvous();
        } else {
            this.beEdge();
        }
        this.rendezvous.addListener(this);
        this.stopped = false;
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Discovery service started");
        }
        return 0;
    }

    @Override
    public void stopApp() {
        this.stopped = true;
        boolean failed = false;
        this.membership.removePropertyChangeListener("defaultCredential", this.membershipCredListener);
        this.membershipCredListener = null;
        this.credential = null;
        this.credentialDoc = null;
        this.rendezvous.removeListener(this);
        if (this.resolver.unregisterHandler(this.handlerName) == null) {
            failed = true;
        }
        if (this.rendezvous.isRendezVous() && this.resolver.unregisterSrdiHandler(this.handlerName) == null) {
            failed = true;
        }
        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING) && failed) {
            LOG.warning("failed to unregister discovery from resolver.");
        }
        if (this.srdiThread != null) {
            this.srdi.stop();
            this.srdi = null;
        }
        this.resolver = null;
        this.group = null;
        this.membership = null;
        this.srdiIndex = null;
        this.srdiThread = null;
        this.rendezvous = null;
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Discovery service stopped.");
        }
    }

    @Override
    public void flushAdvertisements(String id, int type) throws IOException {
        if (this.stopped) {
            return;
        }
        if (type >= 0 && type <= 2) {
            if (null != id) {
                ID advID = ID.create(URI.create(id));
                String advName = advID.getUniqueValue().toString();
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("flushing adv " + advName + " of type " + dirname[type]);
                }
                this.cm.remove(dirname[type], advName);
            } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Flush request by type IGNORED. You must delete advertisements individually.");
            }
        } else {
            throw new IllegalArgumentException("Invalid Advertisement type.");
        }
    }

    @Override
    public void flushAdvertisement(Advertisement adv) throws IOException {
        String advName;
        if (this.stopped) {
            return;
        }
        int type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        ID id = adv.getID();
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Flushing adv " + advName + " of type " + dirname[type]);
            }
        } else {
            XMLDocument doc;
            try {
                doc = (XMLDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception everything) {
                IOException failure = new IOException("Failure removing Advertisement");
                failure.initCause(everything);
                throw failure;
            }
            advName = Cm.createTmpName(doc);
        }
        if (advName != null) {
            this.cm.remove(dirname[type], advName);
        }
    }

    @Override
    public void publish(Advertisement adv) throws IOException {
        this.publish(adv, 31536000000L, 0x6DDD00L);
    }

    @Override
    public void publish(Advertisement adv, long lifetime, long expiration) throws IOException {
        String advName;
        if (this.stopped) {
            return;
        }
        int type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        ID advID = adv.getID();
        if (null == advID || advID.equals(ID.nullID)) {
            XMLDocument doc;
            try {
                doc = (XMLDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception everything) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed to generated document from advertisement", everything);
                }
                IOException failure = new IOException("Failed to generate document from advertisement");
                failure.initCause(everything);
                throw failure;
            }
            try {
                advName = Cm.createTmpName(doc);
            }
            catch (IllegalStateException ise) {
                IOException failure = new IOException("Failed to generate tempname from advertisement");
                failure.initCause(ise);
                throw failure;
            }
        }
        advName = advID.getUniqueValue().toString();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Publishing a " + adv.getAdvType() + " as " + dirname[type] + " / " + advName + "\n\texpiration : " + expiration + "\tlifetime :" + lifetime);
        }
        this.cm.save(dirname[type], advName, adv, lifetime, expiration);
    }

    @Override
    public void remotePublish(Advertisement adv) {
        this.remotePublish(null, adv, 0x6DDD00L);
    }

    @Override
    public void remotePublish(Advertisement adv, long expiration) {
        this.remotePublish(null, adv, expiration);
    }

    @Override
    public void remotePublish(String peerid, Advertisement adv) {
        this.remotePublish(peerid, adv, 0x6DDD00L);
    }

    @Override
    public void processResponse(ResolverResponseMsg response) {
        this.processResponse(response, null);
    }

    @Override
    public void processResponse(ResolverResponseMsg response, EndpointAddress srcAddress) {
        DiscoveryListener[] allListeners;
        DiscoveryResponse res;
        if (this.stopped) {
            return;
        }
        long t0 = System.currentTimeMillis();
        try {
            XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(response.getResponse()));
            res = new DiscoveryResponse(asDoc);
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failed to Read Discovery Response", e);
            }
            return;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Processing responses for query #" + response.getQueryId());
        }
        Enumeration<Advertisement> en = res.getAdvertisements();
        Enumeration<Long> exps = res.getExpirations();
        while (en.hasMoreElements()) {
            Advertisement adv = en.nextElement();
            long exp = exps.nextElement();
            if (exp <= 0L || adv == null) continue;
            try {
                this.publish(adv, exp, exp);
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Error publishing Advertisement", e);
            }
        }
        DiscoveryEvent newevent = new DiscoveryEvent(srcAddress, res, response.getQueryId());
        DiscoveryListener dl = this.listenerTable.get(new Integer(response.getQueryId()));
        if (dl != null) {
            try {
                dl.discoveryEvent(new DiscoveryEvent(srcAddress, res, response.getQueryId()));
            }
            catch (Throwable all) {
                LOG.log(Level.SEVERE, "Uncaught Throwable in listener :" + Thread.currentThread().getName(), all);
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("processed a response for query #" + response.getQueryId() + " in :" + (System.currentTimeMillis() - t0));
        }
        t0 = System.currentTimeMillis();
        for (DiscoveryListener allListener : allListeners = this.listeners.toArray(new DiscoveryListener[0])) {
            try {
                allListener.discoveryEvent(newevent);
            }
            catch (Throwable all) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Uncaught Throwable in listener (" + allListener.getClass().getName() + ") :" + Thread.currentThread().getName(), all);
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Called all listenters to query #" + response.getQueryId() + " in :" + (System.currentTimeMillis() - t0));
        }
    }

    @Override
    public int processQuery(ResolverQueryMsg query) {
        return this.processQuery(query, null);
    }

    @Override
    public int processQuery(ResolverQueryMsg query, EndpointAddress srcAddress) {
        PeerID destPeer;
        List<PeerID> res;
        DiscoveryQuery dq;
        if (this.stopped) {
            return 0;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            if (srcAddress != null) {
                LOG.fine("Processing query #" + query.getQueryId() + " from:" + srcAddress);
            } else {
                LOG.fine("Processing query #" + query.getQueryId() + " from: unknown");
            }
        }
        ArrayList<Long> expirations = new ArrayList<Long>();
        long t0 = System.currentTimeMillis();
        try {
            XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(query.getQuery()));
            dq = new DiscoveryQuery(asDoc);
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Malformed query : ", e);
            }
            return 0;
        }
        if (dq.getThreshold() < 0 || dq.getDiscoveryType() < 0 || dq.getDiscoveryType() > 2) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Malformed query");
            }
            return 0;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Got a " + dirname[dq.getDiscoveryType()] + " query #" + query.getQueryId() + " query :" + dq.getAttr() + " = " + dq.getValue());
        }
        int thresh = Math.min(dq.getThreshold(), 50);
        if (dq.getDiscoveryType() == 0 && 0 == dq.getThreshold()) {
            this.respond(query, dq, Collections.singletonList(this.group.getPeerAdvertisement().toString()), Collections.singletonList(0x6DDD00L));
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Responding to query #" + query.getQueryId() + " in :" + (System.currentTimeMillis() - t0));
            }
            return 0;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("start local search query" + dq.getAttr() + " " + dq.getValue());
        }
        List results = this.search(dq.getDiscoveryType(), dq.getAttr(), dq.getValue(), thresh, true, expirations);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("start local search pruned " + results.size());
        }
        Iterator eachExpiration = expirations.iterator();
        Iterator eachAdv = results.iterator();
        while (eachExpiration.hasNext()) {
            eachAdv.next();
            if ((Long)eachExpiration.next() > 0L) continue;
            eachAdv.remove();
            eachExpiration.remove();
        }
        if (!results.isEmpty()) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Responding to " + dirname[dq.getDiscoveryType()] + " Query : " + dq.getAttr() + " = " + dq.getValue());
            }
            this.respond(query, dq, results, expirations);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Responded to query #" + query.getQueryId() + " in :" + (System.currentTimeMillis() - t0));
            }
            return 0;
        }
        if (!this.group.isRendezvous()) {
            return 0;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Querying SrdiIndex query #" + query.getQueryId());
        }
        if (!(res = this.srdiIndex.query(dirname[dq.getDiscoveryType()], dq.getAttr(), dq.getValue(), thresh)).isEmpty()) {
            this.srdi.forwardQuery(res, query, thresh);
            return 0;
        }
        if (query.getHopCount() == 0 && (destPeer = this.srdi.getReplicaPeer(dirname[dq.getDiscoveryType()] + dq.getAttr() + dq.getValue())) != null) {
            if (!destPeer.equals(this.group.getPeerID())) {
                this.srdi.forwardQuery(destPeer, query);
                return 0;
            }
            query.incrementHopCount();
        }
        return -1;
    }

    private void respond(ResolverQueryMsg query, DiscoveryQuery dq, List results, List<Long> expirations) {
        if (this.localonly || this.stopped) {
            return;
        }
        DiscoveryResponse dresponse = new DiscoveryResponse();
        dresponse.setDiscoveryType(dq.getDiscoveryType());
        dresponse.setQueryAttr(dq.getAttr());
        dresponse.setQueryValue(dq.getValue());
        dresponse.setResponses(results);
        dresponse.setExpirations(expirations);
        ResolverResponseMsg response = query.makeResponse();
        response.setCredential(this.credentialDoc);
        response.setResponse(dresponse.toString());
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Responding to " + query.getSrcPeer());
        }
        this.resolver.sendResponse(query.getSrcPeer().toString(), response);
    }

    @Override
    public synchronized void addDiscoveryListener(DiscoveryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized boolean removeDiscoveryListener(DiscoveryListener listener) {
        Iterator<Map.Entry<Integer, DiscoveryListener>> e = this.listenerTable.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry<Integer, DiscoveryListener> anEntry = e.next();
            if (listener != anEntry.getValue()) continue;
            e.remove();
        }
        return this.listeners.remove(listener);
    }

    @Override
    public void remotePublish(String peerid, Advertisement adv, long timeout) {
        if (this.localonly || this.stopped) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("localonly, no network operations performed");
            }
            return;
        }
        int type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        this.remotePublish(peerid, adv, type, timeout);
    }

    private void remotePublish(String peerid, Advertisement adv, int type, long expiration) {
        if (this.localonly || this.stopped) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("localonly, no network operations performed");
            }
            return;
        }
        if (this.resolver == null) {
            return;
        }
        switch (type) {
            case 0: {
                if (adv instanceof PeerAdvertisement) break;
                throw new IllegalArgumentException("Not a peer advertisement");
            }
            case 1: {
                if (adv instanceof PeerGroupAdvertisement) break;
                throw new IllegalArgumentException("Not a peergroup advertisement");
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown advertisement type");
            }
        }
        ArrayList<String> advert = new ArrayList<String>(1);
        ArrayList<Long> expirations = new ArrayList<Long>(1);
        advert.add(adv.toString());
        expirations.add(expiration);
        DiscoveryResponse dresponse = new DiscoveryResponse();
        dresponse.setDiscoveryType(type);
        dresponse.setResponses(advert);
        dresponse.setExpirations(expirations);
        ResolverResponse pushRes = new ResolverResponse();
        pushRes.setHandlerName(this.handlerName);
        pushRes.setCredential(this.credentialDoc);
        pushRes.setQueryId(0);
        pushRes.setResponse(((Object)dresponse).toString());
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Remote publishing ");
        }
        this.resolver.sendResponse(peerid, pushRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List search(int type, String attr, String value, int threshold, boolean bytes, List<Long> expirations) {
        List<InputStream> results;
        if (this.stopped) {
            return new ArrayList();
        }
        if (type == 0) {
            this.checkUpdatePeerAdv();
        }
        if (threshold <= 0) {
            throw new IllegalArgumentException("threshold must be greater than zero");
        }
        if (expirations != null) {
            expirations.clear();
        }
        if (attr != null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Searching for " + threshold + " entries of type : " + dirname[type]);
            }
            results = this.cm.search(dirname[type], attr, value, threshold, expirations);
        } else {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Getting " + threshold + " entries of type : " + dirname[type]);
            }
            results = this.cm.getRecords(dirname[type], threshold, expirations);
        }
        if (results.isEmpty() || bytes) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Returning " + results.size() + " results");
            }
            return results;
        }
        ArrayList<Advertisement> advertisements = new ArrayList<Advertisement>();
        for (int i = 0; i < results.size(); ++i) {
            InputStream bis = null;
            try {
                bis = results.get(i);
                XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, bis);
                Advertisement adv = AdvertisementFactory.newAdvertisement(asDoc);
                advertisements.add(adv);
                continue;
            }
            catch (Exception e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed building advertisment", e);
                }
                if (null == expirations) continue;
                expirations.remove(i);
                continue;
            }
            finally {
                if (null != bis) {
                    try {
                        bis.close();
                    }
                    catch (IOException ignored) {}
                }
                bis = null;
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Returning " + advertisements.size() + " advertisements");
        }
        return advertisements;
    }

    @Override
    public long getAdvExpirationTime(ID id, int type) {
        String advName;
        if (this.stopped) {
            return -1L;
        }
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Getting expiration time of " + advName + " of type " + dirname[type]);
            }
        } else {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("invalid attempt to get advertisement expiration time of NullID");
            }
            return -1L;
        }
        return this.cm.getExpirationtime(dirname[type], advName);
    }

    @Override
    public long getAdvLifeTime(ID id, int type) {
        if (id == null || id.equals(ID.nullID) || this.stopped) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("invalid attempt to get advertisement lifetime of a NullID");
            }
            return -1L;
        }
        String advName = id.getUniqueValue().toString();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Getting lifetime of " + advName + " of type " + dirname[type]);
        }
        return this.cm.getLifetime(dirname[type], advName);
    }

    @Override
    public long getAdvExpirationTime(Advertisement adv) {
        String advName;
        if (this.stopped) {
            return -1L;
        }
        int type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        ID id = adv.getID();
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("attempting to getAdvExpirationTime on " + advName + " of type " + dirname[type]);
            }
        } else {
            XMLDocument doc;
            try {
                doc = (XMLDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception everything) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed to get document", everything);
                }
                return -1L;
            }
            advName = Cm.createTmpName(doc);
        }
        return this.cm.getExpirationtime(dirname[type], advName);
    }

    @Override
    public long getAdvLifeTime(Advertisement adv) {
        String advName;
        if (this.stopped) {
            return -1L;
        }
        int type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        ID id = adv.getID();
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("attempting to getAdvLifeTime " + advName + " of type " + dirname[type]);
            }
        } else {
            XMLDocument doc;
            try {
                doc = (XMLDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception everything) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed to get document", everything);
                }
                return -1L;
            }
            advName = Cm.createTmpName(doc);
        }
        return this.cm.getLifetime(dirname[type], advName);
    }

    @Override
    public boolean processSrdi(ResolverSrdiMsg message) {
        SrdiMessageImpl srdiMsg;
        if (this.stopped) {
            return true;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.group.getPeerGroupID() + "] Received an SRDI messsage");
        }
        try {
            XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(message.getPayload()));
            srdiMsg = new SrdiMessageImpl(asDoc);
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Failed parsing srdi message", e);
            }
            return false;
        }
        PeerID pid = srdiMsg.getPeerID();
        Iterator<SrdiMessage.Entry> i$ = srdiMsg.getEntries().iterator();
        while (i$.hasNext()) {
            SrdiMessage.Entry o;
            SrdiMessage.Entry entry = o = i$.next();
            this.srdiIndex.add(srdiMsg.getPrimaryKey(), entry.key, entry.value, pid, entry.expiration);
            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Primary Key [" + srdiMsg.getPrimaryKey() + "] key [" + entry.key + "] value [" + entry.value + "] exp [" + entry.expiration + "]");
        }
        this.srdi.replicateEntries(srdiMsg);
        return true;
    }

    @Override
    public void messageSendFailed(PeerID peerid, OutgoingMessageEvent e) {
        if (this.srdiIndex != null) {
            this.srdiIndex.remove(peerid);
        }
    }

    @Override
    public void pushEntries(boolean all) {
        this.pushSrdi(null, 0, all);
        this.pushSrdi(null, 1, all);
        this.pushSrdi(null, 2, all);
    }

    protected void pushSrdi(ID peer, int type, boolean all) {
        if (this.stopped) {
            return;
        }
        List<SrdiMessage.Entry> entries = all ? this.cm.getEntries(dirname[type], true) : this.cm.getDeltas(dirname[type]);
        if (!entries.isEmpty()) {
            try {
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.group.getPeerID(), 1, dirname[type], entries);
                if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Pushing " + entries.size() + (all ? " entries" : " deltas") + " of type " + dirname[type]);
                }
                this.srdi.pushSrdi(peer, srdiMsg);
            }
            catch (Exception e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Exception pushing SRDI Entries", e);
                }
            }
        } else if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("No" + (all ? " entries" : " deltas") + " of type " + dirname[type] + " to push");
        }
    }

    @Override
    public synchronized void rendezvousEvent(RendezvousEvent event) {
        int theEventType = event.getType();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.group.getPeerGroupName() + "] Processing " + event);
        }
        switch (theEventType) {
            case 0: 
            case 1: {
                this.cm.setTrackDeltas(true);
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                this.cm.setTrackDeltas(false);
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                this.beRendezvous();
                break;
            }
            case 9: {
                this.beEdge();
                break;
            }
            default: {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break;
                LOG.warning(MessageFormat.format("[{0}] Unexpected RDV event : {1}", this.group.getPeerGroupName(), event));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpdatePeerAdv() {
        PeerAdvertisement newPadv = this.group.getPeerAdvertisement();
        int newModCount = newPadv.getModCount();
        boolean updated = false;
        String string = this.checkPeerAdvLock;
        synchronized (string) {
            block8: {
                if (this.lastPeerAdv != newPadv || this.lastModCount < newModCount) {
                    this.lastPeerAdv = newPadv;
                    this.lastModCount = newModCount;
                    updated = true;
                }
                if (updated) {
                    try {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("publishing local advertisement");
                        }
                        this.publish(newPadv, Long.MAX_VALUE, 0x6DDD00L);
                    }
                    catch (Exception ignoring) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block8;
                        LOG.log(Level.WARNING, "Could not publish local peer advertisement: ", ignoring);
                    }
                }
            }
        }
    }

    private synchronized void beRendezvous() {
        if (this.isRdv && (this.srdi != null || this.srdiIndex != null)) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Already a rendezvous -- No Switch is needed");
            }
            return;
        }
        this.isRdv = true;
        this.cm.setTrackDeltas(false);
        if (this.srdiIndex == null) {
            this.srdiIndex = new SrdiIndex(this.group, srdiIndexerFileName);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("srdiIndex created");
            }
        }
        if (this.srdi != null) {
            this.srdi.stop();
            if (this.srdiThread != null) {
                this.srdiThread = null;
            }
            this.srdi = null;
        }
        if (!this.localonly) {
            this.srdi = new Srdi(this.group, this.handlerName, this, this.srdiIndex, this.initialDelay, this.runInterval);
            this.resolver.registerSrdiHandler(this.handlerName, this);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("srdi created, and registered as an srdi handler ");
            }
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Switched to Rendezvous peer role.");
        }
    }

    private synchronized void beEdge() {
        if (!this.isRdv && this.srdiThread != null) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Already an Edge peer -- No Switch is needed.");
            }
            return;
        }
        this.isRdv = false;
        if (!this.rendezvous.getConnectedPeerIDs().isEmpty()) {
            this.cm.setTrackDeltas(true);
        }
        if (this.srdiIndex != null) {
            this.srdiIndex.stop();
            this.srdiIndex = null;
            this.resolver.unregisterSrdiHandler(this.handlerName);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("stopped cache and unregistered from resolver");
            }
        }
        if (this.srdi != null) {
            this.srdi.stop();
            if (this.srdiThread != null) {
                this.srdiThread = null;
            }
            this.srdi = null;
        }
        if (!this.localonly) {
            this.srdi = new Srdi(this.group, this.handlerName, this, null, this.initialDelay, this.runInterval);
            this.srdiThread = new Thread(this.group.getHomeThreadGroup(), this.srdi, "Discovery Srdi Thread");
            this.srdiThread.setDaemon(true);
            this.srdiThread.start();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Started SRDIThread");
            }
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Switched to a Edge peer role.");
        }
    }

    private class CredentialListener
    implements PropertyChangeListener {
        private CredentialListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if ("defaultCredential".equals(evt.getPropertyName())) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("New default credential event");
                }
                DiscoveryServiceImpl discoveryServiceImpl = DiscoveryServiceImpl.this;
                synchronized (discoveryServiceImpl) {
                    block8: {
                        DiscoveryServiceImpl.this.credential = (Credential)evt.getNewValue();
                        DiscoveryServiceImpl.this.credentialDoc = null;
                        if (null != DiscoveryServiceImpl.this.credential) {
                            try {
                                DiscoveryServiceImpl.this.credentialDoc = DiscoveryServiceImpl.this.credential.getDocument(MimeMediaType.XMLUTF8);
                            }
                            catch (Exception all) {
                                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block8;
                                LOG.log(Level.WARNING, "Could not generate credential document", all);
                            }
                        }
                    }
                }
            }
        }
    }
}

