/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.jxta.document.Attribute;
import net.jxta.document.XMLElement;
import net.jxta.impl.document.DOMXMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMXMLElement
implements XMLElement<DOMXMLElement> {
    protected DOMXMLDocument root;
    protected Node domNode;

    protected DOMXMLElement(DOMXMLDocument root, Node node) {
        this.root = root;
        this.domNode = node;
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    public String getValue() {
        return this.getTextValue();
    }

    @Override
    public String getName() {
        return this.getAssocNode().getNodeName();
    }

    @Override
    public String getTextValue() {
        StringBuilder itsValue = new StringBuilder();
        for (Node eachChild = this.getAssocNode().getFirstChild(); eachChild != null; eachChild = eachChild.getNextSibling()) {
            if (3 != eachChild.getNodeType()) continue;
            itsValue.append(eachChild.getNodeValue());
        }
        if (0 == itsValue.length()) {
            return null;
        }
        return itsValue.toString();
    }

    @Override
    public DOMXMLDocument getRoot() {
        return this.root;
    }

    @Override
    public DOMXMLElement getParent() {
        Node node = this.getAssocNode();
        if (node.getOwnerDocument().equals(node)) {
            return new DOMXMLElement(this.root, node);
        }
        return new DOMXMLElement(this.root, node.getParentNode());
    }

    @Override
    public void appendChild(DOMXMLElement element2) {
        this.getAssocNode().appendChild(element2.getAssocNode());
    }

    @Override
    public Enumeration<DOMXMLElement> getChildren() {
        ArrayList<DOMXMLElement> children = new ArrayList<DOMXMLElement>();
        for (Node eachChild = this.getAssocNode().getFirstChild(); eachChild != null; eachChild = eachChild.getNextSibling()) {
            if (1 != eachChild.getNodeType()) continue;
            children.add(new DOMXMLElement(this.root, eachChild));
        }
        return Collections.enumeration(children);
    }

    @Override
    public Enumeration<DOMXMLElement> getChildren(Object key) {
        if (key instanceof String) {
            return this.getChildren((String)key);
        }
        throw new ClassCastException(key.getClass().getName() + " not supported by getChildren.");
    }

    @Override
    public Enumeration<DOMXMLElement> getChildren(String name) {
        ArrayList<DOMXMLElement> children = new ArrayList<DOMXMLElement>();
        for (Node eachChild = this.getAssocNode().getFirstChild(); eachChild != null; eachChild = eachChild.getNextSibling()) {
            if (1 != eachChild.getNodeType() || !name.equals(eachChild.getNodeName())) continue;
            children.add(new DOMXMLElement(this.root, eachChild));
        }
        return Collections.enumeration(children);
    }

    public boolean equals(Object element2) {
        Node it;
        if (this == element2) {
            return true;
        }
        if (!(element2 instanceof DOMXMLElement)) {
            return false;
        }
        DOMXMLElement xmlElement = (DOMXMLElement)element2;
        Node me = this.getAssocNode();
        if (me == (it = xmlElement.getAssocNode())) {
            return true;
        }
        if (me.getOwnerDocument() != it.getOwnerDocument()) {
            return false;
        }
        if (!this.getName().equals(xmlElement.getName())) {
            return false;
        }
        String val1 = this.getTextValue();
        String val2 = xmlElement.getTextValue();
        return null == val1 && null == val2 || null != val1 && null != val2 && val1.equals(val2);
    }

    protected Node getAssocNode() {
        return this.domNode;
    }

    @Override
    public String addAttribute(String name, String value) {
        String oldAttrValue = ((Element)this.getAssocNode()).getAttribute(name);
        ((Element)this.getAssocNode()).setAttribute(name, value);
        return 0 == oldAttrValue.length() ? null : oldAttrValue;
    }

    @Override
    public String addAttribute(Attribute newAttrib) {
        String oldAttrValue = ((Element)this.getAssocNode()).getAttribute(newAttrib.getName());
        ((Element)this.getAssocNode()).setAttribute(newAttrib.getName(), newAttrib.getValue());
        return 0 == oldAttrValue.length() ? null : oldAttrValue;
    }

    @Override
    public Enumeration<Attribute> getAttributes() {
        NamedNodeMap nmap = this.getAssocNode().getAttributes();
        if (nmap == null) {
            List noAttrs = Collections.emptyList();
            return Collections.enumeration(noAttrs);
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        for (int i = 0; i < nmap.getLength(); ++i) {
            Node domAttr = nmap.item(i);
            Attribute attr = new Attribute(this, domAttr.getNodeName(), domAttr.getNodeValue());
            attrs.add(attr);
        }
        return Collections.enumeration(attrs);
    }

    @Override
    public Attribute getAttribute(String name) {
        NamedNodeMap nmap = this.getAssocNode().getAttributes();
        if (nmap == null) {
            return null;
        }
        for (int i = 0; i < nmap.getLength(); ++i) {
            Node domAttr = nmap.item(i);
            if (!name.equals(domAttr.getNodeName())) continue;
            Attribute attr = new Attribute(this, domAttr.getNodeName(), domAttr.getNodeValue());
            return attr;
        }
        return null;
    }
}

