/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.ChannelMessenger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.ListenerAdaptor;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageFilterListener;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.EndpointServiceImpl;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EndpointServiceInterface
implements EndpointService {
    private final EndpointServiceImpl theRealThing;
    private static int activeInstanceCount = 0;
    private static ListenerAdaptor listenerAdaptor;
    private final Map<EndpointAddress, Reference<Messenger>> channelCache = new WeakHashMap<EndpointAddress, Reference<Messenger>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointServiceInterface(EndpointServiceImpl endpointService) {
        this.theRealThing = endpointService;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (1 == ++activeInstanceCount) {
                listenerAdaptor = new ListenerAdaptor(Thread.currentThread().getThreadGroup(), ((StdPeerGroup)endpointService.getGroup()).getExecutor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (0 == --activeInstanceCount) {
                listenerAdaptor.shutdown();
                listenerAdaptor = null;
            }
        }
        super.finalize();
    }

    @Override
    public void init(PeerGroup peerGroup, ID id, Advertisement implAdv) {
    }

    @Override
    public int startApp(String[] arg) {
        return 0;
    }

    @Override
    public void stopApp() {
    }

    @Override
    public ModuleImplAdvertisement getImplAdvertisement() {
        return this.theRealThing.getImplAdvertisement();
    }

    @Override
    public EndpointService getInterface() {
        return this;
    }

    @Override
    public PeerGroup getGroup() {
        return this.theRealThing.getGroup();
    }

    @Override
    public Messenger getCanonicalMessenger(EndpointAddress addr, Object hint) {
        return this.theRealThing.getCanonicalMessenger(addr, hint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Messenger getMessengerImmediate(EndpointAddress addr, Object hint) {
        Map<EndpointAddress, Reference<Messenger>> map = this.channelCache;
        synchronized (map) {
            Messenger messenger;
            Reference<Messenger> existing = this.channelCache.get(addr);
            if (existing != null && (messenger = existing.get()) != null && (messenger.getState() & 0x3FF) != 0) {
                return messenger;
            }
        }
        EndpointAddress plainAddr = new EndpointAddress(addr, null, null);
        Messenger found = this.theRealThing.getCanonicalMessenger(plainAddr, hint);
        if (found == null) {
            return null;
        }
        ChannelMessenger res = (ChannelMessenger)found.getChannelMessenger(this.theRealThing.getGroup().getPeerGroupID(), addr.getServiceName(), addr.getServiceParameter());
        Map<EndpointAddress, Reference<Messenger>> map2 = this.channelCache;
        synchronized (map2) {
            Messenger messenger;
            Reference<Messenger> existing = this.channelCache.get(addr);
            if (existing != null && (messenger = existing.get()) != null && (messenger.getState() & 0x3FF) != 0) {
                return messenger;
            }
            res.setMessageWatcher(listenerAdaptor);
            this.channelCache.put(res.getDestinationAddress(), new WeakReference<ChannelMessenger>(res));
        }
        return res;
    }

    @Override
    public Messenger getMessenger(EndpointAddress addr) {
        return this.getMessenger(addr, null);
    }

    @Override
    public Messenger getMessenger(EndpointAddress addr, Object hint) {
        Messenger messenger = this.getMessengerImmediate(addr, hint);
        if (messenger == null) {
            return null;
        }
        messenger.resolve();
        try {
            messenger.waitState(515020, 60000L);
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        int state = messenger.getState();
        if ((state & 0x70000) != 0) {
            return null;
        }
        if ((state & 0x6DBCC) == 0) {
            return null;
        }
        return messenger;
    }

    @Override
    public void propagate(Message msg, String serviceName, String serviceParam) {
        this.theRealThing.propagate(msg, serviceName, serviceParam, Integer.MAX_VALUE);
    }

    @Override
    public void propagate(Message msg, String serviceName, String serviceParam, int initialTTL) {
        this.theRealThing.propagate(msg, serviceName, serviceParam, initialTTL);
    }

    @Override
    public void demux(Message msg) {
        this.theRealThing.demux(msg);
    }

    @Override
    public void processIncomingMessage(Message message, EndpointAddress source, EndpointAddress destination) {
        this.theRealThing.processIncomingMessage(message, source, destination);
    }

    @Override
    @Deprecated
    public boolean ping(EndpointAddress addr) {
        return null != this.getMessengerImmediate(addr, null);
    }

    @Override
    public MessengerEventListener addMessageTransport(MessageTransport transpt) {
        return this.theRealThing.addMessageTransport(transpt);
    }

    @Override
    public boolean removeMessageTransport(MessageTransport transpt) {
        return this.theRealThing.removeMessageTransport(transpt);
    }

    @Override
    public Iterator<MessageTransport> getAllMessageTransports() {
        return this.theRealThing.getAllMessageTransports();
    }

    @Override
    public MessageTransport getMessageTransport(String name) {
        return this.theRealThing.getMessageTransport(name);
    }

    @Override
    public boolean addIncomingMessageListener(EndpointListener listener, String serviceName, String serviceParam) {
        return this.theRealThing.addIncomingMessageListener(listener, serviceName, serviceParam);
    }

    @Override
    public EndpointListener getIncomingMessageListener(String serviceName, String serviceParam) {
        return this.theRealThing.getIncomingMessageListener(serviceName, serviceParam);
    }

    @Override
    public void addIncomingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        this.theRealThing.addIncomingMessageFilterListener(listener, namespace, name);
    }

    @Override
    public void addOutgoingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        this.theRealThing.addOutgoingMessageFilterListener(listener, namespace, name);
    }

    @Override
    public MessageFilterListener removeIncomingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        return this.theRealThing.removeIncomingMessageFilterListener(listener, namespace, name);
    }

    @Override
    public MessageFilterListener removeOutgoingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        return this.theRealThing.removeOutgoingMessageFilterListener(listener, namespace, name);
    }

    @Override
    public EndpointListener removeIncomingMessageListener(String serviceName, String serviceParam) {
        return this.theRealThing.removeIncomingMessageListener(serviceName, serviceParam);
    }

    @Override
    public boolean addMessengerEventListener(MessengerEventListener listener, int prio) {
        return this.theRealThing.addMessengerEventListener(listener, prio);
    }

    @Override
    public boolean removeMessengerEventListener(MessengerEventListener listener, int prio) {
        return this.theRealThing.removeMessengerEventListener(listener, prio);
    }

    @Override
    @Deprecated
    public boolean getMessenger(MessengerEventListener listener, EndpointAddress addr, Object hint) {
        Messenger messenger = this.getMessengerImmediate(addr, hint);
        if (messenger == null) {
            return false;
        }
        if (!listenerAdaptor.watchMessenger(listener, messenger)) {
            return false;
        }
        messenger.resolve();
        return true;
    }

    @Override
    public Messenger getDirectMessenger(EndpointAddress addr, Object hint, boolean exclusive) {
        return this.theRealThing.getDirectMessenger(addr, hint, exclusive);
    }
}

