/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.endpointMeter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.meter.MonitorResources;
import net.jxta.meter.ServiceMonitorFilter;
import net.jxta.platform.ModuleClassID;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class EndpointServiceMonitorFilter
implements ServiceMonitorFilter {
    private ModuleClassID moduleClassID = MonitorResources.endpointServiceMonitorClassID;
    private boolean includeOutboundMetrics = true;
    private boolean includeInboundMetrics = true;
    private boolean includePropagateMetrics = true;

    public EndpointServiceMonitorFilter() {
    }

    public EndpointServiceMonitorFilter(boolean includeInboundMetrics, boolean includeOutboundMetrics, boolean includePropagateMetrics) {
        this.includeInboundMetrics = includeInboundMetrics;
        this.includeOutboundMetrics = includeOutboundMetrics;
        this.includePropagateMetrics = includePropagateMetrics;
    }

    public void init(ModuleClassID moduleClassID) {
        this.moduleClassID = moduleClassID;
    }

    public void setIncludeInboundMetrics(boolean metrics) {
        this.includeInboundMetrics = metrics;
    }

    public void setIncludeOutboundMetrics(boolean metrics) {
        this.includeOutboundMetrics = metrics;
    }

    public void setIncludePropagateMetrics(boolean metrics) {
        this.includePropagateMetrics = metrics;
    }

    public boolean isIncludeOutboundMetrics() {
        return this.includeOutboundMetrics;
    }

    public boolean isIncludeInboundMetrics() {
        return this.includeInboundMetrics;
    }

    public boolean isIncludePropagateMetrics() {
        return this.includePropagateMetrics;
    }

    public ModuleClassID getModuleClassID() {
        return this.moduleClassID;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addBoolean(element2, "includeOutboundMetrics", this.includeOutboundMetrics);
        DocumentSerializableUtilities.addBoolean(element2, "includeInboundMetrics", this.includeInboundMetrics);
        DocumentSerializableUtilities.addBoolean(element2, "includePropagateMetrics", this.includePropagateMetrics);
        if (this.moduleClassID != null) {
            DocumentSerializableUtilities.addString(element2, "moduleClassID", this.moduleClassID.toString());
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("includeOutboundMetrics")) {
                this.includeOutboundMetrics = DocumentSerializableUtilities.getBoolean(childElement);
            }
            if (tagName.equals("includeInboundMetrics")) {
                this.includeInboundMetrics = DocumentSerializableUtilities.getBoolean(childElement);
            }
            if (tagName.equals("includePropagateMetrics")) {
                this.includePropagateMetrics = DocumentSerializableUtilities.getBoolean(childElement);
            }
            if (!tagName.equals("moduleClassID")) continue;
            try {
                this.moduleClassID = (ModuleClassID)IDFactory.fromURI(new URI(DocumentSerializableUtilities.getString(childElement)));
            }
            catch (URISyntaxException jex) {
                throw new DocumentSerializationException("Couldn't uderstand ModuleClassID", jex);
            }
        }
    }
}

