/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.relay;

import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.relay.RelayClient;
import net.jxta.impl.endpoint.relay.RelayServer;
import net.jxta.impl.protocol.RelayConfigAdv;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.PipeService;
import net.jxta.platform.Module;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;

public final class RelayTransport
implements EndpointListener,
Module {
    private static final Logger LOG = Logger.getLogger(RelayTransport.class.getName());
    static final String protocolName = "relay";
    static final String RELAY_NS = "relay";
    static final String REQUEST_ELEMENT = "request";
    static final String RESPONSE_ELEMENT = "response";
    static final String PEERID_ELEMENT = "peerid";
    static final String LEASE_ELEMENT = "lease";
    static final String RELAY_ADV_ELEMENT = "relayAdv";
    static final String CONNECT_REQUEST = "connect";
    static final MessageElement CONNECT_REQUEST_ELEMENT = new StringMessageElement("request", "connect", null);
    static final String DISCONNECT_REQUEST = "disconnect";
    static final MessageElement DISCONNECT_REQUEST_ELEMENT = new StringMessageElement("request", "disconnect", null);
    static final String PID_REQUEST = "pid";
    static final MessageElement PID_REQUEST_ELEMENT = new StringMessageElement("request", "pid", null);
    static final String CONNECTED_RESPONSE = "connected";
    static final MessageElement CONNECTED_RESPONSE_ELEMENT = new StringMessageElement("response", "connected", null);
    static final String DISCONNECTED_RESPONSE = "disconnected";
    static final MessageElement DISCONNECTED_RESPONSE_ELEMENT = new StringMessageElement("response", "disconnected", null);
    static final String PID_RESPONSE = "pid";
    static final MessageElement PID_RESPONSE_ELEMENT = new StringMessageElement("response", "pid", null);
    static final int DEFAULT_MAX_CLIENTS = 150;
    static final int DEFAULT_MAX_SERVERS = 1;
    static final long DEFAULT_LEASE = 3600000L;
    static final long DEFAULT_STALL_TIMEOUT = 15000L;
    static final long DEFAULT_POLL_INTERVAL = 15000L;
    static final long DEFAULT_BROADCAST_INTERVAL = 600000L;
    static final int DEFAULT_CLIENT_QUEUE_SIZE = 20;
    private PeerGroup group = null;
    private String serviceName = null;
    private RelayClient relayClient = null;
    private RelayServer relayServer = null;

    public void init(PeerGroup group, ID assignedID, Advertisement implAdv) throws PeerGroupException {
        this.group = group;
        ModuleImplAdvertisement implAdvertisement = (ModuleImplAdvertisement)implAdv;
        this.serviceName = assignedID.getUniqueValue().toString();
        ConfigParams confAdv = group.getConfigAdvertisement();
        RelayConfigAdv relayConfigAdv = null;
        if (confAdv != null) {
            Advertisement adv = null;
            try {
                XMLDocument configDoc = (XMLDocument)confAdv.getServiceParam(assignedID);
                if (null != configDoc) {
                    adv = AdvertisementFactory.newAdvertisement(configDoc);
                }
            }
            catch (NoSuchElementException failed) {
            }
            catch (IllegalArgumentException failed) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Error in relay advertisement", failed);
                }
                throw failed;
            }
            relayConfigAdv = adv instanceof RelayConfigAdv ? (RelayConfigAdv)adv : (RelayConfigAdv)AdvertisementFactory.newAdvertisement(RelayConfigAdv.getAdvertisementType());
        }
        if (relayConfigAdv.isServerEnabled()) {
            this.relayServer = new RelayServer(group, this.serviceName, relayConfigAdv);
        }
        if (relayConfigAdv.isClientEnabled()) {
            this.relayClient = new RelayClient(group, this.serviceName, relayConfigAdv);
        }
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Relay Message Transport : " + assignedID);
            if (implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ").append(implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : ").append(group);
            configInfo.append("\n\t\tPeer ID : ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tService Name : ").append(this.serviceName);
            configInfo.append("\n\t\tisServer : ").append(relayConfigAdv.isServerEnabled());
            configInfo.append("\n\t\tisClient : ").append(relayConfigAdv.isClientEnabled());
            LOG.config(configInfo.toString());
        }
    }

    public int startApp(String[] args) {
        EndpointService endpoint = this.group.getEndpointService();
        if (null == endpoint) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is an endpoint service");
            }
            return 2;
        }
        DiscoveryService discovery = this.group.getDiscoveryService();
        if (null == discovery) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a discovery service");
            }
            return 2;
        }
        PipeService pipeService = this.group.getPipeService();
        if (null == pipeService) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a pipe service");
            }
            return 2;
        }
        endpoint.addIncomingMessageListener(this, this.serviceName, null);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Message Listener added " + this.serviceName);
        }
        if (this.relayServer != null && !this.relayServer.startServer()) {
            return -1;
        }
        if (this.relayClient != null && !this.relayClient.startClient()) {
            return -1;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Relay Message Transport started");
        }
        return 0;
    }

    public void stopApp() {
        EndpointService endpoint = this.group.getEndpointService();
        if (endpoint == null) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("could not get EndpointService");
            }
        } else {
            endpoint.removeIncomingMessageListener(this.serviceName, null);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Message Listener removed " + this.serviceName);
            }
        }
        if (this.relayServer != null) {
            this.relayServer.stopServer();
        }
        if (this.relayClient != null) {
            this.relayClient.stopClient();
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Relay Message Transport stopped");
        }
    }

    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        MessageElement element2;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Started for " + message + "\tsrc=" + srcAddr);
        }
        if ((element2 = message.getMessageElement("relay", REQUEST_ELEMENT)) != null) {
            if (this.relayServer != null) {
                this.relayServer.handleRequest(message, dstAddr);
            }
        } else {
            element2 = message.getMessageElement("relay", RESPONSE_ELEMENT);
            if (element2 != null && this.relayClient != null) {
                this.relayClient.handleResponse(message, dstAddr);
            }
        }
    }

    protected PeerGroup getGroup() {
        return this.group;
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    static Message createPIDRequestMessage() {
        Message message = new Message();
        message.addMessageElement("relay", PID_REQUEST_ELEMENT);
        return message;
    }

    static Message createPIDResponseMessage(String pidStr) {
        Message message = new Message();
        message.addMessageElement("relay", PID_RESPONSE_ELEMENT);
        RelayTransport.setString(message, PEERID_ELEMENT, pidStr);
        return message;
    }

    static Message createConnectMessage(long lease, boolean doReturnAdv, boolean doFlushQueue) {
        Message message = new Message();
        String request = RelayTransport.createConnectString(lease, doReturnAdv, doFlushQueue);
        RelayTransport.setString(message, REQUEST_ELEMENT, request);
        return message;
    }

    static String createConnectString(long lease, boolean doReturnAdv, boolean doFlushQueue) {
        String request = CONNECT_REQUEST;
        request = lease > 0L ? request + "," + Long.toString(lease) : request + ",";
        request = doFlushQueue ? request + ",flush" : request + ",keep";
        request = doReturnAdv ? request + ",true" : request + ",other";
        return request;
    }

    static Message createConnectedMessage(long lease) {
        Message message = new Message();
        message.addMessageElement("relay", CONNECTED_RESPONSE_ELEMENT);
        if (lease > 0L) {
            RelayTransport.setString(message, LEASE_ELEMENT, Long.toString(lease));
        }
        return message;
    }

    static Message createDisconnectMessage() {
        Message message = new Message();
        message.addMessageElement("relay", DISCONNECT_REQUEST_ELEMENT);
        return message;
    }

    static Message createDisconnectedMessage() {
        Message message = new Message();
        message.addMessageElement("relay", DISCONNECTED_RESPONSE_ELEMENT);
        return message;
    }

    static void setString(Message message, String elementName, String value) {
        StringMessageElement sme = new StringMessageElement(elementName, value, null);
        message.addMessageElement("relay", sme);
    }

    static String getString(Message message, String elementName) {
        MessageElement element2 = message.getMessageElement("relay", elementName);
        if (element2 == null) {
            return null;
        }
        return element2.toString();
    }
}

