/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.binaryID;

import java.util.logging.Logger;
import net.jxta.impl.id.binaryID.BinaryID;
import net.jxta.impl.id.binaryID.IDFormat;
import net.jxta.impl.id.binaryID.ModuleClassBinaryID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;

public final class ModuleSpecBinaryID
extends ModuleSpecID {
    private static final transient Logger LOG = Logger.getLogger(ModuleSpecBinaryID.class.getName());
    protected BinaryID classID;
    protected BinaryID baseClassID;
    protected BinaryID specID;

    protected ModuleSpecBinaryID() {
        this.specID = new BinaryID(102);
        this.classID = new BinaryID(100);
        this.baseClassID = new BinaryID(100);
    }

    protected ModuleSpecBinaryID(String id) {
        int start = id.indexOf(45);
        int parent = id.indexOf(start + 1, 45);
        int spec = id.indexOf(id.indexOf(parent + 1, 45) + 1, 45);
        this.classID = new BinaryID(id.substring(start + 1, parent));
        this.baseClassID = new BinaryID(id.substring(parent + 1, spec));
        this.specID = new BinaryID(id.substring(parent + 1));
    }

    protected ModuleSpecBinaryID(BinaryID classID, BinaryID baseClassID, BinaryID specID) {
        this.classID = classID;
        this.baseClassID = baseClassID;
        this.specID = specID;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof ModuleSpecBinaryID)) {
            return false;
        }
        ModuleSpecBinaryID targetObj = (ModuleSpecBinaryID)target;
        return this.classID.equals(targetObj.getClassID()) && this.baseClassID.equals(targetObj.getBaseClassID()) && this.specID.equals(targetObj.getSpecID());
    }

    public int hashCode() {
        return this.getUniqueValue().hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + this.classID + "-" + this.baseClassID + "_" + this.specID;
    }

    public ModuleClassID getBaseClass() {
        return new ModuleClassBinaryID(this.baseClassID, new BinaryID(100), new BinaryID(102), new BinaryID(102));
    }

    public boolean isOfSameBaseClass(ModuleClassID classId) {
        return this.baseClassID.equals(classId.getBaseClass());
    }

    public boolean isOfSameBaseClass(ModuleSpecID specId) {
        return this.getClassID().equals(((ModuleSpecBinaryID)specId).getClassID());
    }

    public BinaryID getClassID() {
        return this.classID;
    }

    public BinaryID getBaseClassID() {
        return this.baseClassID;
    }

    public BinaryID getSpecID() {
        return this.specID;
    }
}

