/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.impl.pipe.PipeRegistrar;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.logging.Logging;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.protocol.PipeAdvertisement;

class InputPipeImpl
implements EndpointListener,
InputPipe {
    private static final Logger LOG = Logger.getLogger(InputPipeImpl.class.getName());
    protected static final int QUEUESIZE = 100;
    protected PipeRegistrar registrar;
    protected final PipeAdvertisement pipeAdv;
    protected final ID pipeID;
    protected volatile boolean closed = false;
    protected PipeMsgListener listener;
    protected final UnbiasedQueue queue;

    InputPipeImpl(PipeRegistrar r, PipeAdvertisement adv, PipeMsgListener listener) throws IOException {
        this.registrar = r;
        this.pipeAdv = adv;
        this.listener = listener;
        this.pipeID = adv.getPipeID();
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Creating InputPipe for " + this.pipeID + " of type " + adv.getType() + " with " + (null != listener ? "listener" : "queue"));
        }
        this.queue = listener == null ? UnbiasedQueue.synchronizedQueue(new UnbiasedQueue(100, true)) : null;
        if (!this.registrar.register(this)) {
            throw new IOException("Could not register input pipe (already registered) for " + this.pipeID);
        }
    }

    protected synchronized void finalize() throws Throwable {
        if (!this.closed && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Pipe is being finalized without being previously closed. This is likely a bug.");
        }
        this.close();
        super.finalize();
    }

    public Message waitForMessage() throws InterruptedException {
        return this.poll(0);
    }

    public Message poll(int timeout) throws InterruptedException {
        if (this.listener == null) {
            return (Message)this.queue.pop(timeout);
        }
        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("poll() has no effect in listener mode.");
        }
        return null;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (null == this.listener) {
            this.queue.close();
        }
        this.listener = null;
        if (!this.registrar.forget(this) && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("close() : pipe was not registered with registrar.");
        }
        this.registrar = null;
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Closed " + this.pipeID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        block14: {
            if (this.closed) {
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Received " + msg + " from " + srcAddr + " for " + this.pipeID);
            }
            if (null == this.queue) {
                PipeMsgListener temp = this.listener;
                if (null == temp) {
                    return;
                }
                PipeMsgEvent event = new PipeMsgEvent(this, msg, (PipeID)this.pipeID);
                try {
                    temp.pipeMsgEvent(event);
                }
                catch (Throwable ignored) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Uncaught Throwable in listener for : " + this.pipeID + "(" + temp.getClass().getName() + ")", ignored);
                    }
                    break block14;
                }
            }
            boolean pushed = false;
            while (!pushed && !this.queue.isClosed()) {
                try {
                    pushed = this.queue.push(msg, 1000L);
                }
                catch (InterruptedException woken) {
                    Thread.interrupted();
                }
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                InputPipeImpl inputPipeImpl = this;
                synchronized (inputPipeImpl) {
                    LOG.fine("Queued " + msg + " for " + this.pipeID + "\n\tqueue closed : " + this.queue.isClosed() + "\tnumber in queue : " + this.queue.getCurrentInQueue() + "\tnumber queued : " + this.queue.getNumEnqueued() + "\tnumber dequeued : " + this.queue.getNumDequeued());
                }
            }
        }
    }

    public String getType() {
        return this.pipeAdv.getType();
    }

    public ID getPipeID() {
        return this.pipeID;
    }

    public String getName() {
        return this.pipeAdv.getName();
    }

    public PipeAdvertisement getAdvertisement() {
        return this.pipeAdv;
    }
}

