/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Logger;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.impl.membership.pse.PSEUtils;
import org.bouncycastle.jce.PKCS10CertificationRequest;

@Deprecated
public class CertificateSigningRequest {
    private static final transient Logger LOG = Logger.getLogger(CertificateSigningRequest.class.getName());
    private PKCS10CertificationRequest csr = null;

    public CertificateSigningRequest() {
    }

    public CertificateSigningRequest(Element root) {
        this();
        this.initialize(root);
    }

    public static String getMessageType() {
        return "jxta:CertificateSigningRequest";
    }

    public PKCS10CertificationRequest getCSR() {
        return this.csr;
    }

    public void setCSR(PKCS10CertificationRequest csr) {
        this.csr = csr;
    }

    protected void initialize(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XMLElement");
        }
        XMLElement doc = (XMLElement)root;
        String docName = doc.getName();
        if (!docName.equals(CertificateSigningRequest.getMessageType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + docName);
        }
        String value = doc.getTextValue();
        value = value.trim();
        try {
            byte[] csr_der = PSEUtils.base64Decode(new StringReader(value));
            this.csr = new PKCS10CertificationRequest(csr_der);
        }
        catch (IOException error) {
            throw new IllegalArgumentException("bad certificate signing request.");
        }
        if (null == this.csr) {
            throw new IllegalArgumentException("certificate signing request not initialized.");
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        String encodedCSR;
        try {
            encodedCSR = PSEUtils.base64Encode(this.csr.getEncoded());
        }
        catch (IOException failed) {
            IllegalStateException failure = new IllegalStateException("Could not encode certificate signing request.");
            failure.initCause(failed);
            throw failure;
        }
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, CertificateSigningRequest.getMessageType(), encodedCSR);
        if (doc instanceof XMLDocument) {
            ((XMLDocument)doc).addAttribute("xmlns:jxta", "http://jxta.org");
            ((XMLDocument)doc).addAttribute("xml:space", "preserve");
        }
        return doc;
    }
}

