/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.EncryptedPrivateKeyInfo;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.protocol.Certificate;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroupID;

public final class PSEConfigAdv
extends ExtendableAdvertisement
implements Cloneable {
    private static final transient Logger LOG = Logger.getLogger(PSEConfigAdv.class.getName());
    private static final String advType = "jxta:PSEConfig";
    private static final String ROOT_CERT_TAG = "RootCert";
    private static final String CERT_TAG = "Certificate";
    private static final String ENCRYPTED_PRIVATE_KEY_TAG = "EncryptedPrivateKey";
    private static final String KEY_STORE_TYPE_ATTR = "KeyStoreType";
    private static final String KEY_STORE_PROVIDER_ATTR = "KeyStoreProvider";
    private static final String KEY_STORE_LOCATION_TAG = "KeyStoreLocation";
    private static final String[] INDEX_FIELDS = new String[0];
    private final List<X509Certificate> certs = new ArrayList<X509Certificate>();
    private EncryptedPrivateKeyInfo encryptedPrivateKey = null;
    private String privAlgorithm = null;
    private String keyStoreType = null;
    private String keyStoreProvider = null;
    private URI keyStoreLocation = null;

    public static String getAdvertisementType() {
        return advType;
    }

    private PSEConfigAdv() {
    }

    private PSEConfigAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(PSEConfigAdv.getAdvertisementType()) && !PSEConfigAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration<Attribute> eachAttr = doc.getAttributes();
        while (eachAttr.hasMoreElements()) {
            Attribute anAttr = eachAttr.nextElement();
            if (super.handleAttribute(anAttr)) continue;
            if (KEY_STORE_TYPE_ATTR.equals(anAttr.getName())) {
                this.keyStoreType = anAttr.getValue().trim();
                continue;
            }
            if (KEY_STORE_PROVIDER_ATTR.equals(anAttr.getName())) {
                this.keyStoreProvider = anAttr.getValue().trim();
                continue;
            }
            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unhandled Attribute: " + anAttr.getName());
        }
        this.certs.clear();
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.toString());
        }
    }

    public PSEConfigAdv clone() {
        PSEConfigAdv result;
        try {
            result = (PSEConfigAdv)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Object.clone() threw CloneNotSupportedException", e);
        }
        result.setKeyStoreLocation(this.getKeyStoreLocation());
        result.setKeyStoreType(this.getKeyStoreType());
        result.setKeyStoreProvider(this.getKeyStoreProvider());
        result.setEncryptedPrivateKey(this.getEncryptedPrivateKey(), this.getEncryptedPrivateKeyAlgo());
        result.setCertificateChain(this.getCertificateChain());
        return result;
    }

    public String getAdvType() {
        return PSEConfigAdv.getAdvertisementType();
    }

    public final String getBaseAdvType() {
        return PSEConfigAdv.getAdvertisementType();
    }

    public ID getID() {
        ByteArrayInputStream data = new ByteArrayInputStream(this.getCert().getBytes());
        try {
            return IDFactory.newCodatID(PeerGroupID.worldPeerGroupID, new byte[16], data);
        }
        catch (IOException failed) {
            throw new UndeclaredThrowableException(failed, "Could not generate id");
        }
    }

    public X509Certificate getCertificate() {
        if (this.certs.isEmpty()) {
            return null;
        }
        return this.certs.get(0);
    }

    public X509Certificate[] getCertificateChain() {
        return this.certs.toArray(new X509Certificate[this.certs.size()]);
    }

    public String getCert() {
        X509Certificate rootCert = this.getCertificate();
        if (null != rootCert) {
            try {
                return PSEUtils.base64Encode(this.getCertificate().getEncoded());
            }
            catch (Throwable failed) {
                throw new IllegalStateException("Failed to process seed cert");
            }
        }
        return null;
    }

    public void setCert(String newCert) {
        try {
            byte[] cert_der = PSEUtils.base64Decode(new StringReader(newCert));
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            this.setCertificate((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert_der)));
        }
        catch (Exception failed) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to process seed cert", failed);
            }
            IllegalArgumentException failure = new IllegalArgumentException("Failed to process seed cert");
            failure.initCause(failed);
            throw failure;
        }
    }

    public void setCertificate(X509Certificate newCert) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("setCert : " + newCert);
        }
        this.certs.clear();
        if (null == newCert) {
            this.encryptedPrivateKey = null;
        } else {
            this.certs.add(newCert);
        }
    }

    public void setCertificateChain(X509Certificate[] newCerts) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("setCert : " + newCerts);
        }
        this.certs.clear();
        if (null == newCerts) {
            this.encryptedPrivateKey = null;
        } else {
            this.certs.addAll(Arrays.asList(newCerts));
        }
    }

    public PrivateKey getPrivateKey(char[] password) {
        return PSEUtils.pkcs5_Decrypt_pbePrivateKey(password, this.privAlgorithm, this.encryptedPrivateKey);
    }

    public EncryptedPrivateKeyInfo getEncryptedPrivateKey() {
        return this.encryptedPrivateKey;
    }

    public String getEncryptedPrivateKeyAlgo() {
        return this.privAlgorithm;
    }

    public String getEncryptedPrivKey() {
        try {
            if (null == this.encryptedPrivateKey) {
                return null;
            }
            return PSEUtils.base64Encode(this.encryptedPrivateKey.getEncoded());
        }
        catch (Exception failed) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to process private key", failed);
            }
            IllegalStateException failure = new IllegalStateException("Failed to process private key");
            failure.initCause(failed);
            throw failure;
        }
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String type) {
        this.keyStoreType = type;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(String provider) {
        this.keyStoreProvider = provider;
    }

    public URI getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public void setKeyStoreLocation(URI location) {
        this.keyStoreLocation = location;
    }

    public void setEncryptedPrivateKey(String newPriv, String algorithm) {
        try {
            byte[] key_der = PSEUtils.base64Decode(new StringReader(newPriv));
            EncryptedPrivateKeyInfo newEncryptedPriv = new EncryptedPrivateKeyInfo(key_der);
            this.setEncryptedPrivateKey(newEncryptedPriv, algorithm);
        }
        catch (Exception failed) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to process private key", failed);
            }
            IllegalArgumentException failure = new IllegalArgumentException("Failed to process private key");
            failure.initCause(failed);
            throw failure;
        }
    }

    public void setEncryptedPrivateKey(EncryptedPrivateKeyInfo newPriv, String algorithm) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("setPrivateKey : " + newPriv);
        }
        this.encryptedPrivateKey = newPriv;
        this.privAlgorithm = algorithm;
    }

    public void setPrivateKey(PrivateKey newPriv, char[] password) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("setPrivateKey : " + newPriv);
        }
        EncryptedPrivateKeyInfo encypted = PSEUtils.pkcs5_Encrypt_pbePrivateKey(password, newPriv, 500);
        this.setEncryptedPrivateKey(encypted, newPriv.getAlgorithm());
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (ROOT_CERT_TAG.equals(elem.getName())) {
            Enumeration elements = elem.getChildren();
            while (elements.hasMoreElements()) {
                XMLElement eachcertelem = (XMLElement)elements.nextElement();
                if (CERT_TAG.equals(eachcertelem.getName())) {
                    eachcertelem.addAttribute("type", Certificate.getMessageType());
                    Certificate certChain = new Certificate(eachcertelem);
                    this.setCertificateChain(certChain.getCertificates());
                    continue;
                }
                if (ENCRYPTED_PRIVATE_KEY_TAG.equals(eachcertelem.getName())) {
                    String value = eachcertelem.getTextValue();
                    if (null == value) {
                        throw new IllegalArgumentException("Empty Private Key element");
                    }
                    value = value.trim();
                    Attribute algo = eachcertelem.getAttribute("algorithm");
                    if (null == algo) {
                        throw new IllegalArgumentException("Private Key element must include algorithm attribute");
                    }
                    this.setEncryptedPrivateKey(value, algo.getValue());
                    continue;
                }
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Unhandled Element: " + eachcertelem.getName());
            }
            return true;
        }
        if (KEY_STORE_LOCATION_TAG.equals(elem.getName())) {
            try {
                this.keyStoreLocation = new URI(elem.getTextValue());
            }
            catch (URISyntaxException badURI) {
                IllegalArgumentException iae = new IllegalArgumentException("Bad key store location URI");
                iae.initCause(badURI);
                throw iae;
            }
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (adv instanceof Attributable) {
            Attributable attrDoc = (Attributable)((Object)adv);
            if (null != this.keyStoreType) {
                attrDoc.addAttribute(KEY_STORE_TYPE_ATTR, this.keyStoreType);
                if (null != this.keyStoreProvider) {
                    attrDoc.addAttribute(KEY_STORE_PROVIDER_ATTR, this.keyStoreProvider);
                }
            }
        }
        if (null != this.keyStoreLocation) {
            Object keyStoreLocationURI = adv.createElement(KEY_STORE_LOCATION_TAG, this.keyStoreLocation.toString());
            adv.appendChild(keyStoreLocationURI);
        }
        String encodedRoot = this.getCert();
        String encodedPrivateKey = this.getEncryptedPrivKey();
        if (null != encodedRoot && null != encodedPrivateKey) {
            Object rootcert = adv.createElement(ROOT_CERT_TAG, null);
            adv.appendChild(rootcert);
            Object cert = adv.createElement(CERT_TAG, encodedRoot);
            rootcert.appendChild(cert);
            Object privatekey = adv.createElement(ENCRYPTED_PRIVATE_KEY_TAG, encodedPrivateKey);
            rootcert.appendChild(privatekey);
            if (privatekey instanceof Attributable) {
                ((Attributable)privatekey).addAttribute("algorithm", this.privAlgorithm);
            }
        }
        return adv;
    }

    public String[] getIndexFields() {
        return INDEX_FIELDS;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PSEConfigAdv.advType;
        }

        public Advertisement newInstance() {
            return new PSEConfigAdv();
        }

        public Advertisement newInstance(Element root) {
            return new PSEConfigAdv(root);
        }
    }
}

