/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Enumeration;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.protocol.RouteQueryMsg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteQuery
extends RouteQueryMsg {
    private static final String destPIDTag = "Dst";
    private static final String srcRouteTag = "Src";
    private static final String badHopTag = "Bad";

    public RouteQuery() {
    }

    @Deprecated
    public RouteQuery(PeerID dest, RouteAdvertisement srcRoute, Collection<PeerID> badhops) {
        this.setDestPeerID(dest);
        this.setSrcRoute(srcRoute);
        this.setBadHops(badhops);
    }

    public RouteQuery(XMLElement doc) {
        String doctype = doc.getName();
        if (!doctype.equals(RouteQuery.getAdvertisementType())) {
            throw new IllegalArgumentException("Can not construct : " + this.getClass().getName() + " from doc containing a " + doctype);
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            PeerID pid;
            URI pID;
            XMLElement elem = (XMLElement)elements.nextElement();
            if (elem.getName().equals(destPIDTag)) {
                try {
                    pID = new URI(elem.getTextValue());
                    pid = (PeerID)IDFactory.fromURI(pID);
                    this.setDestPeerID(pid);
                    continue;
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad PeerID ID in advertisement");
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Not a peer id");
                }
            }
            if (elem.getName().equals(srcRouteTag)) {
                Enumeration eachXpt = elem.getChildren();
                while (eachXpt.hasMoreElements()) {
                    XMLElement aXpt = (XMLElement)eachXpt.nextElement();
                    RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                    this.setSrcRoute(route);
                }
                continue;
            }
            if (!elem.getName().equals(badHopTag)) continue;
            try {
                pID = new URI(elem.getTextValue());
                pid = (PeerID)IDFactory.fromURI(pID);
                this.addBadHop(pid);
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad PeerID ID in advertisement");
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Not a peer id");
            }
        }
        if (null == this.getDestPeerID()) {
            throw new IllegalArgumentException("Destination peer not initialized");
        }
    }

    @Override
    public StructuredDocument getDocument(MimeMediaType asMimeType) {
        if (null == this.getDestPeerID()) {
            throw new IllegalStateException("Destination peer not initialized");
        }
        StructuredDocument adv = StructuredDocumentFactory.newStructuredDocument(asMimeType, RouteQuery.getAdvertisementType());
        if (adv instanceof XMLElement) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
            ((Attributable)((Object)adv)).addAttribute("xml:space", "preserve");
        }
        PeerID dest = this.getDestPeerID();
        Object e = adv.createElement(destPIDTag, dest.toString());
        adv.appendChild(e);
        RouteAdvertisement route = this.getSrcRoute();
        if (route != null) {
            e = adv.createElement(srcRouteTag);
            adv.appendChild(e);
            StructuredDocument xptDoc = (StructuredDocument)route.getDocument(asMimeType);
            StructuredDocumentUtils.copyElements(adv, e, xptDoc);
        }
        for (PeerID eachPeer : this.getBadHops()) {
            e = adv.createElement(badHopTag, eachPeer.toString());
            adv.appendChild(e);
        }
        return adv;
    }

    public String toString() {
        XMLDocument doc = (XMLDocument)this.getDocument(MimeMediaType.XMLUTF8);
        doc.addAttribute("xml:space", "default");
        return doc.toString();
    }
}

