/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.EndpointUtils;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;
import net.jxta.impl.meter.MonitorManager;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.rendezvous.RendezVousServiceInterface;
import net.jxta.impl.rendezvous.RendezVousServiceProvider;
import net.jxta.impl.rendezvous.adhoc.AdhocPeerRdvService;
import net.jxta.impl.rendezvous.edge.EdgePeerRdvService;
import net.jxta.impl.rendezvous.rdv.RdvPeerRdvService;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMeterBuildSettings;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousServiceMonitor;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.meter.MonitorResources;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezVousStatus;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RendezVousServiceImpl
implements RendezVousService {
    private static final transient Logger LOG = Logger.getLogger(RendezVousServiceImpl.class.getName());
    private static final long rdv_watchdog_interval_default = 300000L;
    private static final double DEMOTION_FACTOR = 0.05;
    private static final long DEMOTION_MIN_PEERVIEW_COUNT = 5L;
    private static final long DEMOTION_MIN_CLIENT_COUNT = 3L;
    protected static final int MAX_MSGIDS = 1000;
    private static final Random random = new Random();
    private PeerGroup group = null;
    private ID assignedID = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    public EndpointService endpoint = null;
    private RendezvousServiceMonitor rendezvousServiceMonitor;
    private Timer timer;
    private RdvWatchdogTask autoRdvTask = null;
    private long rdv_watchdog_interval = 300000L;
    private final Set<RendezvousListener> eventListeners = Collections.synchronizedSet(new HashSet());
    private final List<UUID> msgIds = new ArrayList<UUID>(1000);
    private int messagesReceived;
    private RdvConfigAdv.RendezVousConfiguration config = RdvConfigAdv.RendezVousConfiguration.EDGE;
    private boolean autoRendezvous = false;
    private String[] savedArgs = null;
    private AtomicBoolean rdvProviderSwitchStatus = new AtomicBoolean(false);
    private RendezVousServiceProvider provider = null;
    private final RendezVousServiceInterface rendezvousInterface = new RendezVousServiceInterface(this);

    @Override
    public RendezVousService getInterface() {
        return this.rendezvousInterface;
    }

    @Override
    public ModuleImplAdvertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public ID getAssignedID() {
        return this.assignedID;
    }

    @Override
    public synchronized void init(PeerGroup g, ID assignedID, Advertisement impl) {
        this.group = g;
        this.assignedID = assignedID;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        RdvConfigAdv rdvConfigAdv = null;
        ConfigParams confAdv = this.group.getConfigAdvertisement();
        if (confAdv != null) {
            Advertisement adv = null;
            try {
                XMLDocument configDoc = (XMLDocument)confAdv.getServiceParam(this.getAssignedID());
                if (null != configDoc) {
                    adv = AdvertisementFactory.newAdvertisement(configDoc);
                }
            }
            catch (NoSuchElementException failed) {
                // empty catch block
            }
            if (adv instanceof RdvConfigAdv) {
                rdvConfigAdv = (RdvConfigAdv)adv;
            }
        }
        if (null == rdvConfigAdv) {
            rdvConfigAdv = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(RdvConfigAdv.getAdvertisementType());
        }
        this.config = rdvConfigAdv.getConfiguration();
        this.autoRendezvous = rdvConfigAdv.getAutoRendezvousCheckInterval() > 0L;
        this.rdv_watchdog_interval = rdvConfigAdv.getAutoRendezvousCheckInterval();
        if (PeerGroupID.worldPeerGroupID.equals(this.group.getPeerGroupID())) {
            this.config = RdvConfigAdv.RendezVousConfiguration.AD_HOC;
        }
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring RendezVous Service : " + assignedID);
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ").append(this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : ").append(this.group);
            configInfo.append("\n\t\tPeer ID : ").append(this.group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tRendezVous : ").append((Object)this.config);
            configInfo.append("\n\t\tAuto RendezVous : ").append(this.autoRendezvous);
            configInfo.append("\n\t\tAuto-RendezVous Reconfig Interval : ").append(this.rdv_watchdog_interval);
            LOG.config(configInfo.toString());
        }
        this.rdvProviderSwitchStatus.set(true);
    }

    @Override
    public int startApp(String[] arg) {
        this.endpoint = this.group.getEndpointService();
        if (null == this.endpoint) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is an endpoint service");
            }
            return 2;
        }
        MembershipService needed = this.group.getMembershipService();
        if (null == needed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a membership service");
            }
            return 2;
        }
        this.timer = new Timer("RendezVousServiceImpl Timer for " + this.group.getPeerGroupID(), true);
        if (!this.rdvProviderSwitchStatus.compareAndSet(true, true)) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Unable to start rendezvous provider.");
            }
            return -1;
        }
        if (RdvConfigAdv.RendezVousConfiguration.AD_HOC == this.config) {
            this.provider = new AdhocPeerRdvService(this.group, this);
        } else if (RdvConfigAdv.RendezVousConfiguration.EDGE == this.config) {
            this.provider = new EdgePeerRdvService(this.group, this);
        } else if (RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS == this.config) {
            this.provider = new RdvPeerRdvService(this.group, this);
        } else {
            throw new IllegalStateException("Unrecognized rendezvous configuration");
        }
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING) {
            this.rendezvousServiceMonitor = (RendezvousServiceMonitor)MonitorManager.getServiceMonitor(this.group, MonitorResources.rendezvousServiceMonitorClassID);
            this.provider.setRendezvousServiceMonitor(this.rendezvousServiceMonitor);
        }
        this.provider.startApp(null);
        this.rdvProviderSwitchStatus.set(false);
        if (this.autoRendezvous && !PeerGroupID.worldPeerGroupID.equals(this.group.getPeerGroupID())) {
            this.startWatchDogTimer();
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Rendezvous Serivce started");
        }
        return 0;
    }

    @Override
    public synchronized void stopApp() {
        this.rdvProviderSwitchStatus.set(true);
        if (this.provider != null) {
            this.provider.stopApp();
            this.provider = null;
        }
        this.timer.cancel();
        this.timer = null;
        this.msgIds.clear();
        this.eventListeners.clear();
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Rendezvous Serivce stopped");
        }
    }

    @Override
    public boolean isRendezVous() {
        RendezVousStatus currentStatus = this.getRendezVousStatus();
        return RendezVousStatus.AUTO_RENDEZVOUS == currentStatus || RendezVousStatus.RENDEZVOUS == currentStatus;
    }

    @Override
    public RendezVousStatus getRendezVousStatus() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (null == currentProvider) {
            return RendezVousStatus.NONE;
        }
        if (currentProvider instanceof AdhocPeerRdvService) {
            return RendezVousStatus.ADHOC;
        }
        if (currentProvider instanceof EdgePeerRdvService) {
            return this.autoRendezvous ? RendezVousStatus.AUTO_EDGE : RendezVousStatus.EDGE;
        }
        if (currentProvider instanceof RdvPeerRdvService) {
            return this.autoRendezvous ? RendezVousStatus.AUTO_RENDEZVOUS : RendezVousStatus.RENDEZVOUS;
        }
        return RendezVousStatus.UNKNOWN;
    }

    @Override
    public boolean setAutoStart(boolean auto) {
        return this.setAutoStart(auto, 300000L);
    }

    @Override
    public synchronized boolean setAutoStart(boolean auto, long period) {
        this.rdv_watchdog_interval = period;
        boolean old = this.autoRendezvous;
        this.autoRendezvous = auto;
        if (auto && !old) {
            this.startWatchDogTimer();
        } else if (old && !auto) {
            this.stopWatchDogTimer();
        }
        return old;
    }

    private void connectToRendezVous(EndpointAddress addr, RouteAdvertisement hint) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider == null) {
            throw new IOException("Currently switching rendezvous roles.");
        }
        currentProvider.connectToRendezVous(addr, hint);
    }

    @Override
    public void connectToRendezVous(PeerAdvertisement adv) throws IOException {
        EndpointAddress addr = new EndpointAddress("jxta", adv.getPeerID().getUniqueValue().toString(), null, null);
        this.connectToRendezVous(addr, EndpointUtils.extractRouteAdv(adv));
    }

    @Override
    public void connectToRendezVous(EndpointAddress addr) throws IOException {
        this.connectToRendezVous(addr, null);
    }

    @Override
    public void challengeRendezVous(ID peer, long delay) {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            currentProvider.challengeRendezVous(peer, delay);
        }
    }

    @Override
    public void disconnectFromRendezVous(ID peerId) {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            currentProvider.disconnectFromRendezVous(peerId);
        }
    }

    @Override
    public Enumeration<ID> getConnectedRendezVous() {
        throw new UnsupportedOperationException("Deprecated opertaion. Use interface if you want to use this operation.");
    }

    @Override
    public Enumeration<ID> getDisconnectedRendezVous() {
        throw new UnsupportedOperationException("Deprecated opertaion. Use interface if you want to use this operation.");
    }

    @Override
    public Enumeration<ID> getConnectedPeers() {
        throw new UnsupportedOperationException("Deprecated opertaion. Use interface if you want to use this operation.");
    }

    @Override
    public Vector<ID> getConnectedPeerIDs() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider != null) {
            return currentProvider.getConnectedPeerIDs();
        }
        return new Vector<ID>();
    }

    @Override
    public boolean isConnectedToRendezVous() {
        RendezVousServiceProvider currentProvider = this.provider;
        return currentProvider != null && currentProvider.isConnectedToRendezVous();
    }

    @Override
    public void startRendezVous() {
        block7: {
            try {
                if (this.isRendezVous() || PeerGroupID.worldPeerGroupID.equals(this.group.getPeerGroupID())) {
                    return;
                }
                if (!this.rdvProviderSwitchStatus.compareAndSet(false, true)) {
                    IOException failed = new IOException("Currently switching rendezvous configuration. try again later.");
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Failed to start rendezvous", failed);
                    }
                    throw failed;
                }
                if (this.provider != null) {
                    this.provider.stopApp();
                    this.provider = null;
                }
                this.config = RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS;
                this.provider = new RdvPeerRdvService(this.group, this);
                if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING) {
                    this.provider.setRendezvousServiceMonitor(this.rendezvousServiceMonitor);
                }
                this.provider.startApp(this.savedArgs);
                this.rdvProviderSwitchStatus.set(false);
            }
            catch (IOException failure) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block7;
                LOG.log(Level.WARNING, "Failed to start rendezvous", failure);
            }
        }
    }

    @Override
    public void stopRendezVous() {
        if (!this.isRendezVous()) {
            return;
        }
        if (!this.rdvProviderSwitchStatus.compareAndSet(false, true)) {
            IOException failed = new IOException("Currently switching rendezvous configuration. try again later.");
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to stop rendezvous", failed);
            }
        }
        if (this.provider != null) {
            this.provider.stopApp();
            this.provider = null;
        }
        this.config = RdvConfigAdv.RendezVousConfiguration.EDGE;
        this.provider = new EdgePeerRdvService(this.group, this);
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING) {
            this.provider.setRendezvousServiceMonitor(this.rendezvousServiceMonitor);
        }
        this.provider.startApp(this.savedArgs);
        this.rdvProviderSwitchStatus.set(false);
    }

    @Override
    public boolean addPropagateListener(String serviceName, String serviceParam, EndpointListener listener) {
        if (null == this.endpoint) {
            throw new IllegalStateException("Unable to register propagate listener. (not started)");
        }
        return this.endpoint.addIncomingMessageListener(listener, serviceName, serviceParam);
    }

    @Override
    public EndpointListener removePropagateListener(String serviceName, String serviceParam, EndpointListener listener) {
        if (null == this.endpoint) {
            throw new IllegalStateException("Unable to remove propagate listener. (not started)");
        }
        EndpointListener removed = this.endpoint.removeIncomingMessageListener(serviceName, serviceParam);
        if (removed != listener && null != removed) {
            this.endpoint.addIncomingMessageListener(removed, serviceName, serviceParam);
            return null;
        }
        return listener;
    }

    @Override
    public void propagate(Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (null == currentProvider) {
            throw new IOException("No RDV provider");
        }
        currentProvider.propagate(msg, serviceName, serviceParam, defaultTTL);
    }

    @Override
    public void propagate(Enumeration<? extends ID> destPeerIDs, Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (null == currentProvider) {
            throw new IOException("No RDV provider");
        }
        currentProvider.propagate(destPeerIDs, msg, serviceName, serviceParam, defaultTTL);
    }

    @Override
    public void walk(Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (null == currentProvider) {
            throw new IOException("No RDV provider");
        }
        currentProvider.walk(msg, serviceName, serviceParam, defaultTTL);
    }

    @Override
    public void walk(Vector<? extends ID> destPeerIDs, Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (null == currentProvider) {
            throw new IOException("No RDV provider");
        }
        currentProvider.walk(destPeerIDs, msg, serviceName, serviceParam, defaultTTL);
    }

    @Override
    public Vector<RdvAdvertisement> getLocalWalkView() {
        Vector<RdvAdvertisement> result = new Vector<RdvAdvertisement>();
        PeerView currView = this.getPeerView();
        if (null == currView) {
            return result;
        }
        ArrayList<PeerViewElement> allPVE = new ArrayList<PeerViewElement>(currView.getView());
        for (PeerViewElement pve : allPVE) {
            RdvAdvertisement adv = pve.getRdvAdvertisement();
            result.add(adv);
        }
        return result;
    }

    public PeerView getPeerView() {
        RendezVousServiceProvider currentProvider = this.provider;
        if (currentProvider instanceof RdvPeerRdvService) {
            return ((RdvPeerRdvService)currentProvider).rpv;
        }
        return null;
    }

    @Override
    public void propagateToNeighbors(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (null == currentProvider) {
            throw new IOException("No RDV provider");
        }
        currentProvider.propagateToNeighbors(msg, serviceName, serviceParam, ttl);
    }

    @Override
    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        RendezVousServiceProvider currentProvider = this.provider;
        if (null == currentProvider) {
            throw new IOException("No RDV provider");
        }
        currentProvider.propagateInGroup(msg, serviceName, serviceParam, ttl);
    }

    @Override
    public final void addListener(RendezvousListener listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public final boolean removeListener(RendezvousListener listener) {
        return this.eventListeners.remove(listener);
    }

    public final void generateEvent(int type, ID regarding) {
        Iterator<Object> eachListener = Arrays.asList(this.eventListeners.toArray()).iterator();
        RendezvousEvent event = new RendezvousEvent(this.getInterface(), type, regarding);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Calling listeners for " + event);
        }
        while (eachListener.hasNext()) {
            RendezvousListener aListener = (RendezvousListener)eachListener.next();
            try {
                aListener.rendezvousEvent(event);
            }
            catch (Throwable ignored) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Uncaught Throwable in listener (" + aListener + ")", ignored);
            }
        }
    }

    private synchronized void startWatchDogTimer() {
        this.stopWatchDogTimer();
        this.autoRdvTask = new RdvWatchdogTask();
        this.timer.schedule((TimerTask)this.autoRdvTask, this.rdv_watchdog_interval, this.rdv_watchdog_interval);
    }

    private synchronized void stopWatchDogTimer() {
        RdvWatchdogTask tw = this.autoRdvTask;
        if (tw != null) {
            this.autoRdvTask.cancel();
            this.autoRdvTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMsgIdRecorded(UUID id) {
        boolean found;
        List<UUID> list = this.msgIds;
        synchronized (list) {
            found = this.msgIds.contains(id);
        }
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer(id + " = " + found);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMsgId(UUID id) {
        List<UUID> list = this.msgIds;
        synchronized (list) {
            if (this.isMsgIdRecorded(id)) {
                return false;
            }
            if (this.msgIds.size() < 1000) {
                this.msgIds.add(id);
            } else {
                this.msgIds.set(this.messagesReceived % 1000, id);
            }
            ++this.messagesReceived;
        }
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            LOG.finer("Added Message ID : " + id);
        }
        return true;
    }

    public UUID createMsgId() {
        return UUIDFactory.newSeqUUID();
    }

    @Deprecated
    RendezVousServiceProvider getRendezvousProvider() {
        return this.provider;
    }

    private class RdvWatchdogTask
    extends TimerTask {
        private RdvWatchdogTask() {
        }

        public synchronized void run() {
            block9: {
                try {
                    int connectedPeers = RendezVousServiceImpl.this.getConnectedPeerIDs().size();
                    if (!RendezVousServiceImpl.this.isRendezVous()) {
                        if (0 == connectedPeers) {
                            RendezVousServiceImpl.this.startRendezVous();
                        }
                    } else {
                        boolean isFewClients;
                        int peerViewSize = RendezVousServiceImpl.this.getLocalWalkView().size();
                        boolean isManyElementsInPeerView = (long)peerViewSize > 5L;
                        boolean bl = isFewClients = (long)connectedPeers < 3L;
                        if (isManyElementsInPeerView) {
                            if (connectedPeers == 0) {
                                RendezVousServiceImpl.this.stopRendezVous();
                            } else if (isFewClients && random.nextDouble() < 0.05) {
                                RendezVousServiceImpl.this.stopRendezVous();
                            }
                        }
                    }
                }
                catch (Throwable all) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block9;
                    LOG.log(Level.SEVERE, "Uncaught Throwable in Timer : " + Thread.currentThread().getName(), all);
                }
            }
        }
    }
}

