/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.edge;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.relay.RelayReferralSeedingManager;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.rendezvous.PeerConnection;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.StdRendezVousService;
import net.jxta.impl.rendezvous.edge.RdvConnection;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousConnectionMeter;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMeterBuildSettings;
import net.jxta.impl.rendezvous.rpv.PeerviewSeedingManager;
import net.jxta.impl.util.SeedingManager;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.URISeedingManager;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgePeerRdvService
extends StdRendezVousService {
    private static final transient Logger LOG = Logger.getLogger(EdgePeerRdvService.class.getName());
    private static final long MONITOR_INTERVAL = 15000L;
    private final int MAX_RDV_CONNECTIONS = 1;
    private long LEASE_MARGIN = 300000L;
    private final SeedingManager seedingManager;
    private final List<RouteAdvertisement> seeds = new ArrayList<RouteAdvertisement>();
    private final Map<ID, RdvConnection> rendezVous = Collections.synchronizedMap(new HashMap());

    public EdgePeerRdvService(PeerGroup group, RendezVousServiceImpl rdvService) {
        super(group, rdvService);
        RdvConfigAdv rdvConfigAdv;
        Advertisement adv = null;
        ConfigParams confAdv = group.getConfigAdvertisement();
        if (confAdv != null) {
            adv = confAdv.getSvcConfigAdvertisement(rdvService.getAssignedID());
        }
        if (!(adv instanceof RdvConfigAdv)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Creating new RdvConfigAdv for defaults.");
            }
            rdvConfigAdv = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(RdvConfigAdv.getAdvertisementType());
        } else {
            rdvConfigAdv = (RdvConfigAdv)adv;
        }
        if (-1 != rdvConfigAdv.getMaxTTL()) {
            this.MAX_TTL = rdvConfigAdv.getMaxTTL();
        }
        if (0L != rdvConfigAdv.getLeaseMargin()) {
            this.LEASE_MARGIN = rdvConfigAdv.getLeaseMargin();
        }
        String serviceName = rdvService.getAssignedID().toString() + group.getPeerGroupID().getUniqueValue().toString();
        if (PeerGroupID.worldPeerGroupID.equals(group.getParentGroup().getPeerGroupID())) {
            URISeedingManager uriSeedingManager = rdvConfigAdv.getProbeRelays() ? new RelayReferralSeedingManager(rdvConfigAdv.getAclUri(), rdvConfigAdv.getUseOnlySeeds(), group, serviceName) : new URISeedingManager(rdvConfigAdv.getAclUri(), rdvConfigAdv.getUseOnlySeeds(), group, serviceName);
            for (URI aSeeder : Arrays.asList(rdvConfigAdv.getSeedingURIs())) {
                uriSeedingManager.addSeedingURI(aSeeder);
            }
            for (URI aSeed : Arrays.asList(rdvConfigAdv.getSeedRendezvous())) {
                uriSeedingManager.addSeed(aSeed);
            }
            this.seedingManager = uriSeedingManager;
        } else {
            this.seedingManager = new PeerviewSeedingManager(rdvConfigAdv.getAclUri(), group, group.getParentGroup(), serviceName);
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("RendezVous Service is initialized for " + group.getPeerGroupID() + " as an Edge peer.");
        }
    }

    @Override
    protected int startApp(String[] arg) {
        super.startApp(arg, new StdRdvEdgeProtocolListener());
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
            this.rendezvousMeter.startEdge();
        }
        this.rdvService.generateEvent(9, this.group.getPeerID());
        this.timer.schedule((TimerTask)new MonitorTask(), 0L, 15000L);
        return 0;
    }

    @Override
    public synchronized void stopApp() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.seedingManager.stop();
        this.disconnectFromAllRendezVous();
        super.stopApp();
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
            this.rendezvousMeter.stopEdge();
        }
    }

    @Override
    public Vector<ID> getConnectedPeerIDs() {
        return new Vector<ID>(this.rendezVous.keySet());
    }

    @Override
    public boolean isConnectedToRendezVous() {
        return !this.rendezVous.isEmpty();
    }

    @Override
    public void connectToRendezVous(EndpointAddress addr, Object hint) {
        if (this.seedingManager instanceof URISeedingManager) {
            URISeedingManager uriseed = (URISeedingManager)this.seedingManager;
            if (hint instanceof RouteAdvertisement) {
                uriseed.addSeed((RouteAdvertisement)hint);
            } else {
                uriseed.addSeed(addr.toURI());
            }
        } else if (this.seedingManager instanceof PeerviewSeedingManager) {
            PeerviewSeedingManager pvseed = (PeerviewSeedingManager)this.seedingManager;
            if (hint instanceof RouteAdvertisement) {
                pvseed.addSeed((RouteAdvertisement)hint);
            }
        }
    }

    @Override
    public void challengeRendezVous(ID peerid, long delay) {
        if (delay <= 0L) {
            this.removeRdv(peerid, false);
            return;
        }
        RdvConnection pConn = this.rendezVous.get(peerid);
        if (null != pConn) {
            long adjusted_delay = Math.max(0L, Math.min(TimeUtils.toRelativeTimeMillis(pConn.getLeaseEnd()), delay));
            pConn.setLease(adjusted_delay, adjusted_delay);
        }
    }

    @Override
    public void disconnectFromRendezVous(ID peerId) {
        this.removeRdv(peerId, false);
    }

    @Override
    public void propagate(Message msg, String serviceName, String serviceParam, int initialTTL) throws IOException {
        RendezVousPropagateMessage propHdr;
        msg = msg.clone();
        int useTTL = Math.min(initialTTL, this.MAX_TTL);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Propagating " + msg + "(TTL=" + useTTL + ") to :" + "\n\tsvc name:" + serviceName + "\tsvc params:" + serviceParam);
        }
        if (null != (propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, useTTL))) {
            this.sendToEachConnection(msg, propHdr);
            this.sendToNetwork(msg, propHdr);
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.propagateToGroup();
            }
        } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Declining to propagate " + msg + " (No prop header)");
        }
    }

    @Override
    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int initialTTL) throws IOException {
        RendezVousPropagateMessage propHdr;
        msg = msg.clone();
        int useTTL = Math.min(initialTTL, this.MAX_TTL);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Propagating " + msg + "(TTL=" + useTTL + ") in group to :" + "\n\tsvc name:" + serviceName + "\tsvc params:" + serviceParam);
        }
        if (null != (propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, useTTL))) {
            this.sendToEachConnection(msg, propHdr);
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousMeter != null) {
                this.rendezvousMeter.propagateToGroup();
            }
        } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Declining to propagate " + msg + " (No prop header)");
        }
    }

    @Override
    public void walk(Message msg, String serviceName, String serviceParam, int initialTTL) throws IOException {
        this.propagateInGroup(msg, serviceName, serviceParam, initialTTL);
    }

    @Override
    public void walk(Vector<? extends ID> destPeerIDs, Message msg, String serviceName, String serviceParam, int initialTTL) throws IOException {
        this.propagate(destPeerIDs.elements(), msg, serviceName, serviceParam, initialTTL);
    }

    @Override
    public PeerConnection getPeerConnection(ID peer) {
        return this.rendezVous.get(peer);
    }

    @Override
    protected PeerConnection[] getPeerConnections() {
        return this.rendezVous.values().toArray(new PeerConnection[0]);
    }

    private void disconnectFromAllRendezVous() {
        for (RdvConnection pConn : new ArrayList<RdvConnection>(this.rendezVous.values())) {
            try {
                this.disconnectFromRendezVous(pConn.getPeerID());
            }
            catch (Exception failed) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "disconnectFromRendezVous failed for " + pConn, failed);
            }
        }
    }

    private void processDisconnectRequest(Message msg) {
        block6: {
            try {
                MessageElement elem = msg.getMessageElement("jxta", "Disconnect");
                if (null != elem) {
                    XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(elem);
                    PeerAdvertisement adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(asDoc);
                    RdvConnection rdvConnection = this.rendezVous.get(adv.getPeerID());
                    if (null != rdvConnection) {
                        rdvConnection.setConnected(false);
                        this.removeRdv(adv.getPeerID(), true);
                    } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Ignoring disconnect request from " + adv.getPeerID());
                    }
                }
            }
            catch (Exception failure) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block6;
                LOG.log(Level.WARNING, "Failure processing disconnect request", failure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRdv(PeerAdvertisement padv, long lease) {
        RendezvousConnectionMeter rendezvousConnectionMeter;
        int eventType;
        RdvConnection rdvConnection;
        Map<ID, RdvConnection> map = this.rendezVous;
        synchronized (map) {
            rdvConnection = this.rendezVous.get(padv.getPeerID());
            if (null == rdvConnection) {
                rdvConnection = new RdvConnection(this.group, this.rdvService, (ID)padv.getPeerID());
                this.rendezVous.put(padv.getPeerID(), rdvConnection);
                eventType = 0;
            } else {
                eventType = 1;
            }
        }
        if (1 == eventType) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Renewed RDV lease from " + rdvConnection);
            }
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousServiceMonitor != null) {
                rendezvousConnectionMeter = this.rendezvousServiceMonitor.getRendezvousConnectionMeter(padv.getPeerID());
                rendezvousConnectionMeter.leaseRenewed(lease);
            }
        } else {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("New RDV lease from " + rdvConnection);
            }
            if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousServiceMonitor != null) {
                rendezvousConnectionMeter = this.rendezvousServiceMonitor.getRendezvousConnectionMeter(padv.getPeerID());
                rendezvousConnectionMeter.connectionEstablished(lease);
            }
        }
        rdvConnection.connect(padv, lease, Math.min(this.LEASE_MARGIN, lease / 2L));
        this.rdvService.generateEvent(eventType, padv.getPeerID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRdv(ID rdvid, boolean requested) {
        PeerConnection rdvConnection;
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Disconnect from RDV " + rdvid);
        }
        EdgePeerRdvService edgePeerRdvService = this;
        synchronized (edgePeerRdvService) {
            rdvConnection = this.rendezVous.remove(rdvid);
        }
        if (null != rdvConnection && rdvConnection.isConnected()) {
            rdvConnection.setConnected(false);
            this.sendDisconnect(rdvConnection);
        }
        this.rdvService.generateEvent(requested ? 4 : 5, rdvid);
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousServiceMonitor != null) {
            RendezvousConnectionMeter rendezvousConnectionMeter = this.rendezvousServiceMonitor.getRendezvousConnectionMeter((PeerID)rdvid);
            rendezvousConnectionMeter.connectionDisconnected();
        }
    }

    private void sendLeaseRequest(RdvConnection pConn) throws IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending Lease request to " + pConn);
        }
        RendezvousConnectionMeter rendezvousConnectionMeter = null;
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && this.rendezvousServiceMonitor != null) {
            rendezvousConnectionMeter = this.rendezvousServiceMonitor.getRendezvousConnectionMeter(pConn.getPeerID().toString());
        }
        Message msg = new Message();
        msg.replaceMessageElement("jxta", new TextDocumentMessageElement("Connect", this.getPeerAdvertisementDoc(), null));
        pConn.sendMessage(msg, this.pName, this.pParam);
        if (RendezvousMeterBuildSettings.RENDEZVOUS_METERING && rendezvousConnectionMeter != null) {
            rendezvousConnectionMeter.beginConnection();
        }
    }

    private void processConnectedReply(Message msg) {
        ID pId;
        long lease;
        MessageElement peerElem = msg.getMessageElement("jxta", "RdvAdvReply");
        if (null == peerElem) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Missing rendezvous peer advertisement");
            }
            return;
        }
        try {
            MessageElement el = msg.getMessageElement("jxta", "ConnectedLease");
            if (el == null) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("missing lease");
                }
                return;
            }
            lease = Long.parseLong(el.toString());
        }
        catch (Exception e) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Parse lease failed with ", e);
            }
            return;
        }
        MessageElement el = msg.getMessageElement("jxta", "ConnectedPeer");
        if (el == null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("missing rdv peer");
            }
            return;
        }
        try {
            pId = IDFactory.fromURI(new URI(el.toString()));
        }
        catch (URISyntaxException badID) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Bad RDV peer ID");
            }
            return;
        }
        if (lease <= 0L) {
            this.removeRdv(pId, false);
        } else if (this.rendezVous.containsKey(pId) || this.rendezVous.size() < 1) {
            PeerAdvertisement padv;
            block29: {
                block28: {
                    padv = null;
                    try {
                        XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(peerElem);
                        padv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(asDoc);
                    }
                    catch (Exception failed) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block28;
                        LOG.warning("Failed processing peer advertisement");
                    }
                }
                if (null == padv) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Missing rendezvous peer advertisement");
                    }
                    return;
                }
                if (!this.seedingManager.isAcceptablePeer(padv)) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Rejecting lease offer from unacceptable peer : " + padv.getPeerID());
                    }
                    return;
                }
                this.addRdv(padv, lease);
                try {
                    DiscoveryService discovery = this.group.getDiscoveryService();
                    if (null != discovery) {
                        discovery.publish(padv, lease * 2L, 0L);
                    }
                }
                catch (IOException e) {
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block29;
                    LOG.log(Level.FINE, "failed to publish Rendezvous Advertisement", e);
                }
            }
            String rdvName = padv.getName();
            if (null == padv.getName()) {
                rdvName = pId.toString();
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("RDV Connect Response : peer=" + rdvName + " lease=" + lease + "ms");
            }
        } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Ignoring lease offer from " + pId);
        }
    }

    private class MonitorTask
    extends TimerTask {
        private MonitorTask() {
        }

        public void run() {
            block21: {
                try {
                    MessageTransport router;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + EdgePeerRdvService.this.group + "] Periodic rendezvous check");
                    }
                    if (EdgePeerRdvService.this.closed) {
                        return;
                    }
                    if (!PeerGroupID.worldPeerGroupID.equals(EdgePeerRdvService.this.group.getPeerGroupID()) && null == (router = ((EdgePeerRdvService)EdgePeerRdvService.this).rdvService.endpoint.getMessageTransport("jxta"))) {
                        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                            LOG.warning("Rendezvous connection stalled until router is started!");
                        }
                        EdgePeerRdvService.this.timer.schedule((TimerTask)new MonitorTask(), 2000L);
                        return;
                    }
                    ArrayList currentRdvs = new ArrayList(EdgePeerRdvService.this.rendezVous.values());
                    for (RdvConnection pConn : currentRdvs) {
                        try {
                            if (!pConn.isConnected()) {
                                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                                    LOG.fine("[" + EdgePeerRdvService.this.group.getPeerGroupID() + "] Lease expired. Disconnected from " + pConn);
                                }
                                EdgePeerRdvService.this.removeRdv(pConn.getPeerID(), false);
                                continue;
                            }
                            if (TimeUtils.toRelativeTimeMillis(pConn.getRenewal()) > 0L) continue;
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("[" + EdgePeerRdvService.this.group.getPeerGroupID() + "] Attempting lease renewal for " + pConn);
                            }
                            EdgePeerRdvService.this.sendLeaseRequest(pConn);
                        }
                        catch (Exception e) {
                            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                            LOG.log(Level.WARNING, "[" + EdgePeerRdvService.this.group.getPeerGroupID() + "] Failure while checking " + pConn, e);
                        }
                    }
                    if (EdgePeerRdvService.this.rendezVous.size() < 1) {
                        if (EdgePeerRdvService.this.seeds.isEmpty()) {
                            EdgePeerRdvService.this.seeds.addAll(Arrays.asList(EdgePeerRdvService.this.seedingManager.getActiveSeedRoutes()));
                        }
                        int sentLeaseRequests = 0;
                        while (!EdgePeerRdvService.this.seeds.isEmpty() && sentLeaseRequests < 3) {
                            RouteAdvertisement aSeed = (RouteAdvertisement)EdgePeerRdvService.this.seeds.remove(0);
                            Message msg = new Message();
                            msg.addMessageElement("jxta", new TextDocumentMessageElement("Connect", EdgePeerRdvService.this.getPeerAdvertisementDoc(), null));
                            Messenger msgr = null;
                            if (null == aSeed.getDestPeerID()) {
                                Vector<String> seed_eas = aSeed.getDest().getVectorEndpointAddresses();
                                if (!seed_eas.isEmpty()) {
                                    EndpointAddress aSeedHost = new EndpointAddress((String)seed_eas.get(0));
                                    msgr = ((EdgePeerRdvService)EdgePeerRdvService.this).rdvService.endpoint.getMessengerImmediate(aSeedHost, null);
                                }
                            } else {
                                EndpointAddress aSeedHost = new EndpointAddress(aSeed.getDestPeerID(), null, null);
                                msgr = ((EdgePeerRdvService)EdgePeerRdvService.this).rdvService.endpoint.getMessengerImmediate(aSeedHost, aSeed);
                            }
                            if (null == msgr) continue;
                            try {
                                msgr.sendMessageN(msg, EdgePeerRdvService.this.pName, EdgePeerRdvService.this.pParam);
                                ++sentLeaseRequests;
                            }
                            catch (Exception failed) {}
                        }
                    } else {
                        EdgePeerRdvService.this.seeds.clear();
                    }
                }
                catch (Throwable t) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block21;
                    LOG.log(Level.WARNING, "Uncaught throwable in thread :" + Thread.currentThread().getName(), t);
                }
            }
        }
    }

    private class StdRdvEdgeProtocolListener
    implements StdRendezVousService.StdRdvProtocolListener {
        private StdRdvEdgeProtocolListener() {
        }

        public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + EdgePeerRdvService.this.group.getPeerGroupID() + "] processing " + msg);
            }
            if (msg.getMessageElement("jxta", "ConnectedPeer") != null || msg.getMessageElement("jxta", "RdvAdvReply") != null) {
                EdgePeerRdvService.this.processConnectedReply(msg);
            }
            if (msg.getMessageElement("jxta", "Disconnect") != null) {
                EdgePeerRdvService.this.processDisconnectRequest(msg);
            }
        }
    }
}

