/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rpv;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.impl.rendezvous.rpv.PeerViewDestination;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;
import net.jxta.protocol.RdvAdvertisement;

public final class PeerViewElement
extends PeerViewDestination
implements OutgoingMessageEventListener {
    private static final transient Logger LOG = Logger.getLogger(PeerViewElement.class.getName());
    private final EndpointService endpoint;
    private final long created;
    private long lastUpdate = 0L;
    private RdvAdvertisement radv = null;
    private boolean alive = true;
    private volatile boolean throttling = false;
    private PeerView peerview = null;
    private Messenger cachedMessenger = null;

    PeerViewElement(EndpointService endpoint, RdvAdvertisement radv) {
        super(radv.getPeerID());
        this.endpoint = endpoint;
        this.radv = radv;
        this.lastUpdate = this.created = TimeUtils.timeNow();
    }

    public String toString() {
        StringBuilder asString = new StringBuilder();
        asString.append('\"');
        asString.append(this.radv.getName());
        asString.append('\"');
        asString.append(this.alive ? " A " : " a ");
        asString.append(this.isInPeerView() ? " P " : " p ");
        asString.append(this.throttling ? " T " : " t ");
        asString.append(" [");
        asString.append(TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), this.created) / 1000L);
        asString.append("/");
        asString.append(TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), this.lastUpdate) / 1000L);
        asString.append("]");
        return asString.toString();
    }

    public void messageSendSucceeded(OutgoingMessageEvent e) {
        this.setAlive(true, true);
        this.throttling = false;
    }

    public void messageSendFailed(OutgoingMessageEvent e) {
        if (null != e.getFailure()) {
            this.setAlive(false, true);
        }
        this.throttling = e.getFailure() == null;
    }

    public boolean isAlive() {
        return this.alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setAlive(boolean live, boolean doNotify) {
        PeerView temp;
        boolean mustNotify;
        PeerViewElement peerViewElement = this;
        synchronized (peerViewElement) {
            mustNotify = this.alive && !live;
            this.alive = live;
        }
        if (mustNotify && doNotify && null != (temp = this.peerview)) {
            temp.notifyFailure(this, true);
        }
        return mustNotify;
    }

    boolean isInPeerView() {
        return null != this.peerview;
    }

    synchronized void setPeerView(PeerView pv) {
        if (null != this.peerview && null != pv) {
            throw new IllegalStateException("Element already in " + this.peerview);
        }
        this.peerview = pv;
    }

    long getLastUpdateTime() {
        return this.lastUpdate;
    }

    void setLastUpdateTime(long last) {
        this.lastUpdate = last;
    }

    public boolean sendMessage(Message msg, String serviceName, String serviceParam) {
        if (this.throttling) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Declining to send -- throttling on " + this);
            }
            return false;
        }
        Messenger sendVia = this.getCachedMessenger();
        if (null == sendVia) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Could not get messenger for " + this.getPeerID());
            }
            OutgoingMessageEvent event = new OutgoingMessageEvent(msg, new IOException("Couldn't get messenger for " + this.getPeerID()));
            this.messageSendFailed(event);
            return false;
        }
        sendVia.sendMessage(msg, serviceName, serviceParam, this);
        return true;
    }

    public RdvAdvertisement getRdvAdvertisement() {
        return this.radv;
    }

    RdvAdvertisement setRdvAdvertisement(RdvAdvertisement adv) {
        if (!this.radv.getPeerID().equals(adv.getPeerID())) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("adv refers to a different peer");
            }
            throw new IllegalArgumentException("adv refers to a different peer");
        }
        RdvAdvertisement old = this.radv;
        this.radv = adv;
        this.setLastUpdateTime(TimeUtils.timeNow());
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Messenger getCachedMessenger() {
        PeerView temp;
        boolean mustNotify = false;
        PeerViewElement peerViewElement = this;
        synchronized (peerViewElement) {
            if (null == this.cachedMessenger || (this.cachedMessenger.getState() & 0x3FF) == 0) {
                this.cachedMessenger = null;
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Getting cached Messenger for " + this.radv.getName());
                }
                this.cachedMessenger = this.endpoint.getMessengerImmediate(this.getDestAddress(), this.radv.getRouteAdv());
                if (null == this.cachedMessenger) {
                    mustNotify = this.setAlive(false, false);
                } else if ((this.cachedMessenger.getState() & 0x6DBCC) != 0) {
                    mustNotify = this.setAlive(true, false);
                }
            }
        }
        if (mustNotify && null != (temp = this.peerview)) {
            temp.notifyFailure(this, true);
        }
        return this.cachedMessenger;
    }
}

