/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver.resolverMeter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.impl.resolver.resolverMeter.QueryDestinationMetric;
import net.jxta.peer.PeerID;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class QueryHandlerMetric
implements DocumentSerializable {
    public static final String REGISTERED = "registered";
    public static final String UNREGISTERED = "unregistered";
    private String handlerName;
    private String registered;
    private int numResponses = 0;
    private long responseProcessingTime = 0L;
    private long responseTime = 0L;
    private int numResponseErrors = 0;
    private int numQueries = 0;
    private int numQueriesRepropagated = 0;
    private long queryProcessingTime = 0L;
    private int numQueryErrors = 0;
    private int numQueriesSentInGroup = 0;
    private int numQueriesSentViaWalker = 0;
    private int numQueriesSentViaUnicast = 0;
    private int numErrorsSendingQueries = 0;
    private int numErrorsPropagatingQueries = 0;
    private int numQueriesHopCountDropped = 0;
    private int numPropagationQueriesDropped = 0;
    private int numPropagatedInGroup = 0;
    private int numPropagatedViaWalker = 0;
    private int numUnableToPropagate = 0;
    private int numResponsesToUnregisteredHandler = 0;
    private int numQueriesToUnregisteredHandler = 0;
    private int numResponsesSentInGroup = 0;
    private int numResponsesSentViaWalker = 0;
    private int numResponsesSentViaUnicast = 0;
    private int numErrorsSendingResponses = 0;
    private int numErrorsPropagatingResponses = 0;
    private HashMap destinationMetrics = new HashMap();

    public QueryHandlerMetric(String handlerName) {
        this.handlerName = handlerName;
    }

    public QueryHandlerMetric() {
    }

    public QueryHandlerMetric(QueryHandlerMetric prototype) {
        this.handlerName = prototype.handlerName;
    }

    void responseProcessed(long responseTime, long processingTime) {
        ++this.numResponses;
        responseTime += responseTime;
        this.responseProcessingTime += processingTime;
    }

    void responseToUnregisteredHandler() {
        ++this.numResponsesToUnregisteredHandler;
    }

    void errorWhileProcessingResponse() {
        ++this.numResponseErrors;
    }

    void queryProcessed(int result, long processingTime) {
        ++this.numQueries;
        if (result == -1) {
            ++this.numQueriesRepropagated;
        }
        this.queryProcessingTime += processingTime;
    }

    void queryToUnregisteredHandler() {
        ++this.numQueriesToUnregisteredHandler;
    }

    void errorWhileProcessingQuery() {
        ++this.numQueryErrors;
    }

    void querySentInGroup() {
        ++this.numQueriesSentInGroup;
    }

    void querySentViaWalker() {
        ++this.numQueriesSentViaWalker;
    }

    void querySentViaUnicast(String peer) {
        ++this.numQueriesSentViaUnicast;
    }

    void querySendError() {
        ++this.numErrorsSendingQueries;
    }

    void queryPropagateError() {
        ++this.numErrorsPropagatingQueries;
    }

    void queryHopCountDropped() {
        ++this.numQueriesHopCountDropped;
    }

    void responseSentInGroup() {
        ++this.numResponsesSentInGroup;
    }

    void responseSentViaWalker() {
        ++this.numResponsesSentViaWalker;
    }

    void responseSentViaUnicast() {
        ++this.numResponsesSentViaUnicast;
    }

    void responseSendError() {
        ++this.numErrorsSendingResponses;
    }

    void responsePropagateError() {
        ++this.numErrorsPropagatingResponses;
    }

    void propagationQueryDropped() {
        ++this.numPropagationQueriesDropped;
    }

    void queryPropagatedInGroup() {
        ++this.numPropagatedInGroup;
    }

    void queryPropagatedViaWalker() {
        ++this.numPropagatedViaWalker;
    }

    void unableToPropagate() {
        ++this.numUnableToPropagate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryHandlerMetric) {
            QueryHandlerMetric otherQueryHandlerMetric = (QueryHandlerMetric)obj;
            return this.handlerName.equals(otherQueryHandlerMetric.handlerName);
        }
        return false;
    }

    public int hashCode() {
        return this.handlerName.hashCode();
    }

    void setRegistered(boolean isRegistered) {
        this.registered = isRegistered ? REGISTERED : UNREGISTERED;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public String getRegistered() {
        return this.registered != null ? this.registered : UNREGISTERED;
    }

    public int getNumResponses() {
        return this.numResponses;
    }

    public long getResponseProcessingTime() {
        return this.responseProcessingTime;
    }

    public long getAverageResponseProcessingTime() {
        return this.numResponses == 0 ? 0L : this.responseProcessingTime / (long)this.numResponses;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public long getAverageResponseTime() {
        return this.numResponses == 0 ? 0L : this.responseTime / (long)this.numResponses;
    }

    public int getNumResponseErrors() {
        return this.numResponseErrors;
    }

    public int getNumQueries() {
        return this.numQueries;
    }

    public int getNumQueriesRepropagated() {
        return this.numQueriesRepropagated;
    }

    public long getQueryProcessingTime() {
        return this.queryProcessingTime;
    }

    public long getAverageQueryProcessingTime() {
        return this.numQueries == 0 ? 0L : this.queryProcessingTime / (long)this.numQueries;
    }

    public int getNumQueryErrors() {
        return this.numQueryErrors;
    }

    public int getNumQueriesSentInGroup() {
        return this.numQueriesSentInGroup;
    }

    public int getNumQueriesSentViaWalker() {
        return this.numQueriesSentViaWalker;
    }

    public int getNumQueriesSentViaUnicast() {
        return this.numQueriesSentViaUnicast;
    }

    public int getNumErrorsSendingQueries() {
        return this.numErrorsSendingQueries;
    }

    public int getNumErrorsPropagatingQueries() {
        return this.numErrorsPropagatingQueries;
    }

    public int getNumResponsesSentInGroup() {
        return this.numResponsesSentInGroup;
    }

    public int getNumResponsesSentViaWalker() {
        return this.numResponsesSentViaWalker;
    }

    public int getNumResponsesSentViaUnicast() {
        return this.numResponsesSentViaUnicast;
    }

    public int getNumErrorsSendingResponses() {
        return this.numErrorsSendingResponses;
    }

    public int getNumErrorsPropagatingResponses() {
        return this.numErrorsPropagatingResponses;
    }

    public int getNumQueriesSent() {
        return this.numQueriesSentInGroup + this.numQueriesSentViaWalker + this.numQueriesSentViaUnicast;
    }

    public int getNumQuerySendErrors() {
        return this.numErrorsSendingQueries + this.numErrorsPropagatingQueries;
    }

    public int getNumResponsesSent() {
        return this.numResponsesSentInGroup + this.numResponsesSentViaWalker + this.numResponsesSentViaUnicast;
    }

    public int getNumResponseSendErrors() {
        return this.numErrorsSendingResponses + this.numErrorsPropagatingResponses;
    }

    public void addQueryDestinationMetric(QueryDestinationMetric queryDestinationMetric) {
        this.destinationMetrics.put(queryDestinationMetric.getPeerID(), queryDestinationMetric);
    }

    public QueryDestinationMetric getQueryDestinationMetric(PeerID peerID) {
        QueryDestinationMetric destinationMetric = (QueryDestinationMetric)this.destinationMetrics.get(peerID);
        if (destinationMetric == null) {
            destinationMetric = new QueryDestinationMetric(peerID);
            this.destinationMetrics.put(peerID, destinationMetric);
        }
        return destinationMetric;
    }

    public Iterator getDestinationMetrics() {
        return this.destinationMetrics.values().iterator();
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        if (this.handlerName != null) {
            DocumentSerializableUtilities.addString(element2, "handlerName", this.handlerName);
        }
        if (this.registered != null) {
            DocumentSerializableUtilities.addString(element2, REGISTERED, this.registered);
        }
        if (this.numResponses != 0) {
            DocumentSerializableUtilities.addInt(element2, "numResponses", this.numResponses);
        }
        if (this.responseProcessingTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "responseProcessingTime", this.responseProcessingTime);
        }
        if (this.responseTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "responseTime", this.responseTime);
        }
        if (this.numResponseErrors != 0) {
            DocumentSerializableUtilities.addInt(element2, "numResponseErrors", this.numResponseErrors);
        }
        if (this.numQueries != 0) {
            DocumentSerializableUtilities.addInt(element2, "numQueries", this.numQueries);
        }
        if (this.numQueriesRepropagated != 0) {
            DocumentSerializableUtilities.addInt(element2, "numQueriesRepropagated", this.numQueriesRepropagated);
        }
        if (this.queryProcessingTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "queryProcessingTime", this.queryProcessingTime);
        }
        if (this.numQueryErrors != 0) {
            DocumentSerializableUtilities.addInt(element2, "numQueryErrors", this.numQueryErrors);
        }
        if (this.numQueriesSentInGroup != 0) {
            DocumentSerializableUtilities.addInt(element2, "numQueriesSentInGroup", this.numQueriesSentInGroup);
        }
        if (this.numQueriesSentViaWalker != 0) {
            DocumentSerializableUtilities.addInt(element2, "numQueriesSentViaWalker", this.numQueriesSentViaWalker);
        }
        if (this.numQueriesSentViaUnicast != 0) {
            DocumentSerializableUtilities.addInt(element2, "numQueriesSentViaUnicast", this.numQueriesSentViaUnicast);
        }
        if (this.numErrorsSendingQueries != 0) {
            DocumentSerializableUtilities.addInt(element2, "numErrorsSendingQueries", this.numErrorsSendingQueries);
        }
        if (this.numErrorsPropagatingQueries != 0) {
            DocumentSerializableUtilities.addInt(element2, "numErrorsPropagatingQueries", this.numErrorsPropagatingQueries);
        }
        if (this.numQueriesHopCountDropped != 0) {
            DocumentSerializableUtilities.addInt(element2, "numQueriesHopCountDropped", this.numQueriesHopCountDropped);
        }
        if (this.numPropagationQueriesDropped != 0) {
            DocumentSerializableUtilities.addInt(element2, "numPropagationQueriesDropped", this.numPropagationQueriesDropped);
        }
        if (this.numPropagatedInGroup != 0) {
            DocumentSerializableUtilities.addInt(element2, "numPropagatedInGroup", this.numPropagatedInGroup);
        }
        if (this.numPropagatedViaWalker != 0) {
            DocumentSerializableUtilities.addInt(element2, "numPropagatedViaWalker", this.numPropagatedViaWalker);
        }
        if (this.numUnableToPropagate != 0) {
            DocumentSerializableUtilities.addInt(element2, "numUnableToPropagate", this.numUnableToPropagate);
        }
        if (this.numResponsesToUnregisteredHandler != 0) {
            DocumentSerializableUtilities.addInt(element2, "numResponsesToUnregisteredHandler", this.numResponsesToUnregisteredHandler);
        }
        if (this.numQueriesToUnregisteredHandler != 0) {
            DocumentSerializableUtilities.addInt(element2, "numQueriesToUnregisteredHandler", this.numQueriesToUnregisteredHandler);
        }
        if (this.numResponsesSentInGroup != 0) {
            DocumentSerializableUtilities.addInt(element2, "numResponsesSentInGroup", this.numResponsesSentInGroup);
        }
        if (this.numResponsesSentViaWalker != 0) {
            DocumentSerializableUtilities.addInt(element2, "numResponsesSentViaWalker", this.numResponsesSentViaWalker);
        }
        if (this.numResponsesSentViaUnicast != 0) {
            DocumentSerializableUtilities.addInt(element2, "numResponsesSentViaUnicast", this.numResponsesSentViaUnicast);
        }
        if (this.numErrorsSendingResponses != 0) {
            DocumentSerializableUtilities.addInt(element2, "numErrorsSendingResponses", this.numErrorsSendingResponses);
        }
        if (this.numErrorsPropagatingResponses != 0) {
            DocumentSerializableUtilities.addInt(element2, "numErrorsPropagatingResponses", this.numErrorsPropagatingResponses);
        }
        Iterator i = this.destinationMetrics.values().iterator();
        while (i.hasNext()) {
            Element queryDestinationElement = DocumentSerializableUtilities.createChildElement(element2, "destination");
            QueryDestinationMetric queryDestinationMetric = (QueryDestinationMetric)i.next();
            queryDestinationMetric.serializeTo(queryDestinationElement);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("handlerName")) {
                this.handlerName = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (tagName.equals(REGISTERED)) {
                this.registered = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (tagName.equals("numResponses")) {
                this.numResponses = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("responseProcessingTime")) {
                this.responseProcessingTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("responseTime")) {
                this.responseTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numResponseErrors")) {
                this.numResponseErrors = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numQueries")) {
                this.numQueries = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numQueriesRepropagated")) {
                this.numQueriesRepropagated = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("queryProcessingTime")) {
                this.queryProcessingTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numQueryErrors")) {
                this.numQueryErrors = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numQueriesSentInGroup")) {
                this.numQueriesSentInGroup = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numQueriesSentViaWalker")) {
                this.numQueriesSentViaWalker = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numQueriesSentViaUnicast")) {
                this.numQueriesSentViaUnicast = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numErrorsSendingQueries")) {
                this.numErrorsSendingQueries = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numErrorsPropagatingQueries")) {
                this.numErrorsPropagatingQueries = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numQueriesHopCountDropped")) {
                this.numQueriesHopCountDropped = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numPropagationQueriesDropped")) {
                this.numPropagationQueriesDropped = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numPropagatedInGroup")) {
                this.numPropagatedInGroup = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numPropagatedViaWalker")) {
                this.numPropagatedViaWalker = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numUnableToPropagate")) {
                this.numUnableToPropagate = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numResponsesToUnregisteredHandler")) {
                this.numResponsesToUnregisteredHandler = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numQueriesToUnregisteredHandler")) {
                this.numQueriesToUnregisteredHandler = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numResponsesSentInGroup")) {
                this.numResponsesSentInGroup = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numResponsesSentViaWalker")) {
                this.numResponsesSentViaWalker = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numResponsesSentViaUnicast")) {
                this.numResponsesSentViaUnicast = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numErrorsSendingResponses")) {
                this.numErrorsSendingResponses = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numErrorsPropagatingResponses")) {
                this.numErrorsPropagatingResponses = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (!tagName.equals("destination")) continue;
            QueryDestinationMetric queryDestinationMetric = new QueryDestinationMetric();
            queryDestinationMetric.initializeFrom(childElement);
            this.addQueryDestinationMetric(queryDestinationMetric);
        }
    }

    public void mergeMetrics(QueryHandlerMetric otherQueryHandlerMetric) {
        this.numResponses += otherQueryHandlerMetric.numResponses;
        this.responseProcessingTime += otherQueryHandlerMetric.responseProcessingTime;
        this.responseTime += otherQueryHandlerMetric.responseTime;
        this.numResponseErrors += otherQueryHandlerMetric.numResponseErrors;
        this.numQueries += otherQueryHandlerMetric.numQueries;
        this.numQueriesRepropagated += otherQueryHandlerMetric.numQueriesRepropagated;
        this.queryProcessingTime += otherQueryHandlerMetric.queryProcessingTime;
        this.numQueryErrors += otherQueryHandlerMetric.numQueryErrors;
        this.numQueriesSentInGroup += otherQueryHandlerMetric.numQueriesSentInGroup;
        this.numQueriesSentViaWalker += otherQueryHandlerMetric.numQueriesSentViaWalker;
        this.numQueriesSentViaUnicast += otherQueryHandlerMetric.numQueriesSentViaUnicast;
        this.numErrorsSendingQueries += otherQueryHandlerMetric.numErrorsSendingQueries;
        this.numErrorsPropagatingQueries += otherQueryHandlerMetric.numErrorsPropagatingQueries;
        this.numQueriesHopCountDropped += otherQueryHandlerMetric.numQueriesHopCountDropped;
        this.numResponsesSentInGroup += otherQueryHandlerMetric.numResponsesSentInGroup;
        this.numResponsesSentViaWalker += otherQueryHandlerMetric.numResponsesSentViaWalker;
        this.numResponsesSentViaUnicast += otherQueryHandlerMetric.numResponsesSentViaUnicast;
        this.numErrorsSendingResponses += otherQueryHandlerMetric.numErrorsSendingResponses;
        this.numErrorsPropagatingResponses += otherQueryHandlerMetric.numErrorsPropagatingResponses;
        Iterator i = otherQueryHandlerMetric.getDestinationMetrics();
        while (i.hasNext()) {
            QueryDestinationMetric otherQueryDestinationMetric = (QueryDestinationMetric)i.next();
            QueryDestinationMetric ourQueryDestinationMetric = this.getQueryDestinationMetric(otherQueryDestinationMetric.getPeerID());
            if (ourQueryDestinationMetric == null) {
                ourQueryDestinationMetric = new QueryDestinationMetric(otherQueryDestinationMetric);
                this.addQueryDestinationMetric(ourQueryDestinationMetric);
            }
            ourQueryDestinationMetric.mergeMetrics(otherQueryDestinationMetric);
        }
    }
}

