/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util.pipe.reliable;

import java.io.IOException;
import net.jxta.endpoint.Message;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.pipe.reliable.Outgoing;
import net.jxta.pipe.OutputPipe;

public class OutgoingPipeAdaptorSync
implements Outgoing {
    private OutputPipe pipe = null;
    private long lastAccessed = 0L;
    private boolean closed = false;

    public OutgoingPipeAdaptorSync(OutputPipe pipe) {
        this.pipe = pipe;
        this.lastAccessed = TimeUtils.timeNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendNb(Message msg) throws IOException {
        OutputPipe locPipe;
        OutgoingPipeAdaptorSync outgoingPipeAdaptorSync = this;
        synchronized (outgoingPipeAdaptorSync) {
            locPipe = this.pipe;
        }
        if (this.closed || locPipe == null) {
            return false;
        }
        locPipe.send(msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Message msg) throws IOException {
        OutputPipe locPipe;
        OutgoingPipeAdaptorSync outgoingPipeAdaptorSync = this;
        synchronized (outgoingPipeAdaptorSync) {
            while (this.pipe == null && !this.closed) {
                try {
                    this.wait();
                }
                catch (InterruptedException ignore) {}
            }
            if (this.closed) {
                return false;
            }
            locPipe = this.pipe;
        }
        return locPipe.send(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPipe(OutputPipe pipe) {
        OutgoingPipeAdaptorSync outgoingPipeAdaptorSync = this;
        synchronized (outgoingPipeAdaptorSync) {
            if (this.closed || this.pipe != null) {
                throw new IllegalStateException("Cannot change pipe nor re-open");
            }
            this.pipe = pipe;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        OutgoingPipeAdaptorSync outgoingPipeAdaptorSync = this;
        synchronized (outgoingPipeAdaptorSync) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.pipe != null) {
                this.pipe.close();
                this.pipe = null;
            }
            this.notifyAll();
        }
    }

    public long getMinIdleReconnectTime() {
        return 600000L;
    }

    public long getIdleTimeout() {
        return Long.MAX_VALUE;
    }

    public void setTimeout(int timeout) {
    }

    public long getMaxRetryAge() {
        return 60000L;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(long time) {
        this.lastAccessed = time;
    }

    public String toString() {
        return (this.pipe == null ? "no pipe yet" : this.pipe.toString()) + " lastAccessed=" + Long.toString(this.lastAccessed);
    }
}

