/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util.pipe.reliable;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.WireFormatMessage;
import net.jxta.endpoint.WireFormatMessageFactory;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.pipe.reliable.Defs;
import net.jxta.impl.util.pipe.reliable.FixedFlowControl;
import net.jxta.impl.util.pipe.reliable.FlowControl;
import net.jxta.impl.util.pipe.reliable.Incoming;
import net.jxta.impl.util.pipe.reliable.Outgoing;
import net.jxta.logging.Logging;

public class ReliableOutputStream
extends OutputStream
implements Incoming {
    private static final Logger LOG = Logger.getLogger(ReliableOutputStream.class.getName());
    private static final long initRTT = 10000L;
    private static final int DEFAULT_MESSAGE_CHUNK_SIZE = 64512;
    private static final MessageElement RETELT = new StringMessageElement("retry", "RETRY", null);
    private final Object writeLock = new String("writeLock");
    private byte[] writeBuffer = null;
    private int writeCount = 0;
    private int writeBufferSize = 64512;
    private long writeBufferAge = Long.MAX_VALUE;
    private long closedAt = Long.MAX_VALUE;
    private volatile boolean remoteClosed = false;
    private volatile boolean localClosed = false;
    private long lingerDelay = 120000L;
    private AtomicInteger sequenceNumber = new AtomicInteger(0);
    private volatile int maxACK = 0;
    private final Outgoing outgoing;
    private Thread retrThread = null;
    private volatile long aveRTT = 10000L;
    private volatile long remRTT = 0L;
    private boolean aveRTTreset = false;
    private AtomicInteger numACKS = new AtomicInteger(0);
    private int rttThreshold = 0;
    private volatile long RTO = 0L;
    private volatile long minRTO = 50000L;
    private volatile long maxRTO = 600000L;
    private volatile long lastACKTime = 0L;
    private volatile long sackRetransTime = 0L;
    private int nIQTests = 0;
    private int aveIQSize = 0;
    private volatile int mrrIQFreeSpace = 0;
    private int rmaxQSize = 100;
    private final FlowControl fc;
    private volatile int rwindow = 0;
    protected final List<RetrQElt> retrQ = new ArrayList<RetrQElt>();

    public ReliableOutputStream(Outgoing outgoing) {
        this(outgoing, new FixedFlowControl(20));
    }

    public ReliableOutputStream(Outgoing outgoing, FlowControl fc) {
        this.outgoing = outgoing;
        this.RTO = this.maxRTO;
        this.mrrIQFreeSpace = this.rmaxQSize;
        this.rttThreshold = this.rmaxQSize;
        this.lastACKTime = TimeUtils.timeNow();
        this.sackRetransTime = TimeUtils.timeNow();
        this.fc = fc;
        this.rwindow = fc.getRwindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.flush();
        super.close();
        this.localClosed = true;
        this.closedAt = TimeUtils.toRelativeTimeMillis(this.lingerDelay);
        List<RetrQElt> list = this.retrQ;
        synchronized (list) {
            this.retrQ.notifyAll();
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Closed.");
        }
    }

    public long getLingerDelay() {
        return this.lingerDelay;
    }

    public void setLingerDelay(long linger) {
        if (linger < 0L) {
            throw new IllegalArgumentException("Linger delay may not be negative.");
        }
        if (0L == linger) {
            linger = Long.MAX_VALUE;
        }
        this.lingerDelay = linger;
    }

    public int setSendBufferSize() {
        return this.writeBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSendBufferSize(int size) throws IOException {
        if (size <= 0) {
            throw new IllegalArgumentException("Send buffer size may not be <= 0");
        }
        Object object = this.writeLock;
        synchronized (object) {
            this.flushBuffer();
            this.writeBufferSize = size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hardClose() {
        this.remoteClosed = true;
        this.closedAt = TimeUtils.timeNow();
        Object object = this.retrQ;
        synchronized (object) {
            this.retrQ.clear();
            this.retrQ.notifyAll();
        }
        object = this.writeLock;
        synchronized (object) {
            this.writeCount = 0;
            this.writeBuffer = null;
            this.writeBufferAge = Long.MAX_VALUE;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Hard closed.");
        }
    }

    public boolean isClosed() {
        return this.localClosed || this.remoteClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.flushBuffer();
        }
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            int copy;
            int current;
            if (this.isClosed()) {
                throw new IOException("stream is closed");
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            int end = current + len;
            for (current = off; current < end; current += copy) {
                if (0 == this.writeCount) {
                    this.writeBuffer = new byte[this.writeBufferSize];
                    this.writeBufferAge = TimeUtils.timeNow();
                }
                int remain = end - current;
                int available = this.writeBuffer.length - this.writeCount;
                copy = Math.min(available, remain);
                System.arraycopy(b, current, this.writeBuffer, this.writeCount, copy);
                this.writeCount += copy;
                if (this.writeBuffer.length != this.writeCount) continue;
                this.flushBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        if (this.writeCount > 0) {
            try {
                this.writeBuffer(this.writeBuffer, 0, this.writeCount);
            }
            finally {
                this.writeCount = 0;
                this.writeBuffer = null;
                this.writeBufferAge = Long.MAX_VALUE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBuffer(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (null == this.retrThread) {
            this.retrThread = new Thread((Runnable)new Retransmitter(), "JXTA Reliable Retransmiter for " + this);
            this.retrThread.setDaemon(true);
            this.retrThread.start();
        }
        Message jmsg = new Message();
        List<RetrQElt> list = this.retrQ;
        synchronized (list) {
            while (true) {
                if (this.isClosed()) {
                    throw new IOException("Connection is " + (this.localClosed ? "closing" : "closed"));
                }
                if (this.retrQ.size() <= Math.min(this.rwindow, this.mrrIQFreeSpace * 2)) break;
                try {
                    this.retrQ.wait(1000L);
                }
                catch (InterruptedException ignored) {}
            }
            int sequenceToUse = this.sequenceNumber.incrementAndGet();
            ByteArrayMessageElement element2 = new ByteArrayMessageElement(Integer.toString(sequenceToUse), Defs.MIME_TYPE_BLOCK, b, off, len, null);
            jmsg.addMessageElement("jxtarel", element2);
            RetrQElt retrQel = new RetrQElt(sequenceToUse, jmsg.clone());
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Reliable WRITE : seqn#" + this.sequenceNumber + " length=" + len);
            }
            this.retrQ.add(retrQel);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Retrans Enqueue added seqn#" + this.sequenceNumber + " retrQ.size()=" + this.retrQ.size());
            }
        }
        this.outgoing.send(jmsg);
        --this.mrrIQFreeSpace;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("SENT : seqn#" + this.sequenceNumber + " length=" + len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(Message msg) throws IOException {
        WireFormatMessage msgSerialized = WireFormatMessageFactory.toWire(msg, Defs.MIME_TYPE_MSG, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)msgSerialized.getByteLength());
        msgSerialized.sendToStream(baos);
        baos.close();
        byte[] bytes = baos.toByteArray();
        Object object = this.writeLock;
        synchronized (object) {
            this.flushBuffer();
            this.writeBuffer(bytes, 0, bytes.length);
            return this.sequenceNumber.get();
        }
    }

    public int getMaxAck() {
        return this.maxACK;
    }

    public int getSeqNumber() {
        return this.sequenceNumber.get();
    }

    protected boolean isQueueFull() {
        return this.mrrIQFreeSpace < 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueueEmpty() {
        List<RetrQElt> list = this.retrQ;
        synchronized (list) {
            return this.retrQ.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitQueueEmpty(long timeout) throws InterruptedException {
        long timeoutAt = TimeUtils.toAbsoluteTimeMillis(timeout);
        List<RetrQElt> list = this.retrQ;
        synchronized (list) {
            while (!this.retrQ.isEmpty() && TimeUtils.timeNow() < timeoutAt) {
                long sleepTime = TimeUtils.toRelativeTimeMillis(timeoutAt);
                if (sleepTime <= 0L) continue;
                this.retrQ.wait(sleepTime);
            }
            return this.retrQ.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitQueueEvent(long timeout) throws InterruptedException {
        List<RetrQElt> list = this.retrQ;
        synchronized (list) {
            this.retrQ.wait(timeout);
        }
    }

    private void calcRTT(long dt, int msgSeqNum) {
        if (this.numACKS.incrementAndGet() == 1) {
            this.rttThreshold = this.sequenceNumber.get() + 1;
        }
        if (msgSeqNum > this.rttThreshold) {
            if (!this.aveRTTreset) {
                this.aveRTT = dt;
                this.aveRTTreset = true;
            } else {
                long tmp = 8L * this.aveRTT + 8L * this.remRTT / 9L + dt;
                this.aveRTT = tmp / 9L;
                this.remRTT = tmp - this.aveRTT * 9L;
            }
        }
        this.RTO = this.aveRTT * 2L;
        this.RTO = Math.max(this.RTO, this.minRTO);
        this.RTO = Math.min(this.RTO, this.maxRTO);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("RTT = " + dt + "ms aveRTT = " + this.aveRTT + "ms" + " RTO = " + this.RTO + "ms");
        }
    }

    private int calcAVEIQ(int iq) {
        int n = this.nIQTests++;
        this.aveIQSize = (n * this.aveIQSize + iq) / this.nIQTests;
        return this.aveIQSize;
    }

    public void recv(Message msg) {
        Message.ElementIterator eachACK = msg.getMessageElements("jxtarel", Defs.MIME_TYPE_ACK);
        while (eachACK.hasNext()) {
            MessageElement elt = (MessageElement)eachACK.next();
            eachACK.remove();
            int sackCount = (int)elt.getByteLength() / 4 - 1;
            try {
                DataInputStream dis = new DataInputStream(elt.getStream());
                int seqack = dis.readInt();
                int[] sacs = new int[sackCount];
                for (int eachSac = 0; eachSac < sackCount; ++eachSac) {
                    sacs[eachSac] = dis.readInt();
                }
                Arrays.sort(sacs);
                this.ackReceived(seqack, sacs);
            }
            catch (IOException failed) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Failure processing ACK", failed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackReceived(int seqnum, int[] sackList) {
        int numberACKed = 0;
        long rttCalcDt = 0L;
        int rttCalcSeqnum = -1;
        long fallBackDt = 0L;
        int fallBackSeqnum = -1;
        List<RetrQElt> list = this.retrQ;
        synchronized (list) {
            this.lastACKTime = TimeUtils.timeNow();
            this.fc.ackEventBegin();
            this.maxACK = Math.max(this.maxACK, seqnum);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                int y;
                StringBuilder dumpRETRQ = new StringBuilder("ACK RECEIVE : " + Integer.toString(seqnum));
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    dumpRETRQ.append('\n');
                }
                dumpRETRQ.append("\tRETRQ (size=").append(this.retrQ.size()).append(")");
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    dumpRETRQ.append(" : ");
                    for (y = 0; y < this.retrQ.size(); ++y) {
                        if (0 != y) {
                            dumpRETRQ.append(", ");
                        }
                        RetrQElt r = this.retrQ.get(y);
                        dumpRETRQ.append(r.seqnum);
                    }
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    dumpRETRQ.append('\n');
                }
                dumpRETRQ.append("\tSACKLIST (size=").append(sackList.length).append(")");
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    dumpRETRQ.append(" : ");
                    for (y = 0; y < sackList.length; ++y) {
                        if (0 != y) {
                            dumpRETRQ.append(", ");
                        }
                        dumpRETRQ.append(sackList[y]);
                    }
                }
                LOG.fine(dumpRETRQ.toString());
            }
            Iterator<RetrQElt> eachRetryQueueEntry = this.retrQ.iterator();
            while (eachRetryQueueEntry.hasNext()) {
                RetrQElt retrQElt = eachRetryQueueEntry.next();
                if (retrQElt.seqnum > seqnum) break;
                eachRetryQueueEntry.remove();
                long enqueuetime = retrQElt.enqueuedAt;
                long dt = TimeUtils.toRelativeTimeMillis(this.lastACKTime, enqueuetime);
                if (retrQElt.marked == 0) {
                    if (dt > rttCalcDt) {
                        rttCalcDt = dt;
                        rttCalcSeqnum = retrQElt.seqnum;
                    }
                } else if ((dt /= (long)(retrQElt.marked + 1)) > fallBackDt) {
                    fallBackDt = dt;
                    fallBackSeqnum = retrQElt.seqnum;
                }
                this.fc.packetACKed(retrQElt.seqnum);
                retrQElt = null;
                ++numberACKed;
            }
            if (numberACKed > 0) {
                this.outgoing.setLastAccessed(TimeUtils.timeNow());
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("SEQUENTIALLY ACKD SEQN = " + seqnum + ", (" + numberACKed + " acked)");
            }
            this.mrrIQFreeSpace = this.rmaxQSize - sackList.length;
            int aveIQ = this.calcAVEIQ(sackList.length);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("remote IQ free space = " + this.mrrIQFreeSpace + " remote avg IQ occupancy = " + aveIQ);
            }
            int retrans = 0;
            if (sackList.length > 0) {
                Iterator<RetrQElt> eachRetrQElement = this.retrQ.iterator();
                int currentSACK = 0;
                while (eachRetrQElement.hasNext()) {
                    RetrQElt retrQElt = eachRetrQElement.next();
                    while (sackList[currentSACK] < retrQElt.seqnum && ++currentSACK != sackList.length) {
                    }
                    if (currentSACK == sackList.length) break;
                    if (sackList[currentSACK] == retrQElt.seqnum) {
                        this.fc.packetACKed(retrQElt.seqnum);
                        ++numberACKed;
                        eachRetrQElement.remove();
                        long enqueuetime = retrQElt.enqueuedAt;
                        long dt = TimeUtils.toRelativeTimeMillis(this.lastACKTime, enqueuetime);
                        if (retrQElt.marked == 0) {
                            if (dt > rttCalcDt) {
                                rttCalcDt = dt;
                                rttCalcSeqnum = retrQElt.seqnum;
                            }
                        } else if ((dt /= (long)(retrQElt.marked + 1)) > fallBackDt) {
                            fallBackDt = dt;
                            fallBackSeqnum = retrQElt.seqnum;
                        }
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("SACKD SEQN = " + retrQElt.seqnum);
                        }
                        retrQElt = null;
                        continue;
                    }
                    if (seqnum >= retrQElt.seqnum) continue;
                    this.fc.packetMissing(retrQElt.seqnum);
                    ++retrans;
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("RETR: Fill hole, SACK, seqn#" + retrQElt.seqnum + ", Window =" + retrans);
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("SELECTIVE ACKD (" + numberACKed + ") " + retrans + " retrans wanted");
                }
            }
            if (rttCalcSeqnum != -1) {
                this.calcRTT(rttCalcDt, rttCalcSeqnum);
                this.rwindow = this.fc.ackEventEnd(this.rmaxQSize, this.aveRTT, rttCalcDt);
            } else if (fallBackSeqnum != -1 && fallBackDt > this.aveRTT) {
                this.calcRTT(fallBackDt, fallBackSeqnum);
                this.rwindow = this.fc.ackEventEnd(this.rmaxQSize, this.aveRTT, fallBackDt);
            }
            this.retrQ.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int retransmit(int rwin, long triggerTime) {
        RetrQElt r;
        int numberToRetrans;
        ArrayList<RetrQElt> retransMsgs = new ArrayList<RetrQElt>();
        List<RetrQElt> list = this.retrQ;
        synchronized (list) {
            numberToRetrans = Math.min(this.retrQ.size(), rwin);
            if (numberToRetrans > 0 && Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Number of messages pending retransmit =" + numberToRetrans);
            }
            for (int j = 0; j < numberToRetrans; ++j) {
                r = this.retrQ.get(j);
                if (r.marked == 0 ? TimeUtils.toRelativeTimeMillis(triggerTime, r.sentAt) < 6L * this.aveRTT / 5L : TimeUtils.toRelativeTimeMillis(triggerTime, r.sentAt) < this.aveRTT) continue;
                ++r.marked;
                retransMsgs.add(r);
            }
        }
        int retransmitted = 0;
        Iterator eachRetrans = retransMsgs.iterator();
        while (eachRetrans.hasNext()) {
            r = (RetrQElt)eachRetrans.next();
            eachRetrans.remove();
            try {
                Message sending;
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("RETRANSMIT seqn#" + r.seqnum);
                }
                if (null == (sending = r.msg)) continue;
                sending = sending.clone();
                sending.replaceMessageElement("jxtarel", RETELT);
                if (!this.outgoing.send(sending)) break;
                r.sentAt = TimeUtils.timeNow();
                --this.mrrIQFreeSpace;
                ++retransmitted;
            }
            catch (IOException e) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, "FAILED RETRANS seqn#" + r.seqnum, e);
                break;
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("RETRANSMITED " + retransmitted + " of " + numberToRetrans);
        }
        return retransmitted;
    }

    private class Retransmitter
    implements Runnable {
        int nAtThisRTO = 0;
        volatile int nretransmitted = 0;

        public Retransmitter() {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("STARTED Reliable Retransmitter, RTO = " + ReliableOutputStream.this.RTO);
            }
        }

        public int getRetransCount() {
            return this.nretransmitted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int idleCounter = 0;
                while (TimeUtils.toRelativeTimeMillis(ReliableOutputStream.this.closedAt) > 0L) {
                    long oldestInQueueWait;
                    long sinceLastACK;
                    long conn_idle = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), ReliableOutputStream.this.outgoing.getLastAccessed());
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine(ReliableOutputStream.this.outgoing + " idle for " + conn_idle);
                    }
                    if (ReliableOutputStream.this.outgoing.getIdleTimeout() < conn_idle) {
                        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                            LOG.info("Shutting down idle connection " + ReliableOutputStream.this.outgoing);
                        }
                        break;
                    }
                    List<RetrQElt> list = ReliableOutputStream.this.retrQ;
                    synchronized (list) {
                        try {
                            if (ReliableOutputStream.this.RTO > 0L) {
                                ReliableOutputStream.this.retrQ.wait(ReliableOutputStream.this.RTO);
                            }
                            Thread.currentThread().setName("JXTA Reliable Retransmiter for " + this + " Queue size : " + ReliableOutputStream.this.retrQ.size());
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (TimeUtils.toRelativeTimeMillis(ReliableOutputStream.this.closedAt) <= 0L) {
                            break;
                        }
                        long sinceLastSACKRetr = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), ReliableOutputStream.this.sackRetransTime);
                        if (sinceLastSACKRetr < ReliableOutputStream.this.RTO) {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("SACK retrans " + sinceLastSACKRetr + "ms ago");
                            }
                            continue;
                        }
                        sinceLastACK = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), ReliableOutputStream.this.lastACKTime);
                        if (!ReliableOutputStream.this.retrQ.isEmpty()) {
                            RetrQElt elt = ReliableOutputStream.this.retrQ.get(0);
                            oldestInQueueWait = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), elt.enqueuedAt);
                        } else {
                            oldestInQueueWait = 0L;
                        }
                    }
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Last ACK " + sinceLastACK + "ms ago. Age of oldest in Queue " + oldestInQueueWait + "ms.");
                    }
                    if (oldestInQueueWait > ReliableOutputStream.this.outgoing.getMaxRetryAge()) {
                        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                            LOG.info("Shutting down stale connection " + ReliableOutputStream.this.outgoing);
                        }
                        break;
                    }
                    long realWait = Math.max(oldestInQueueWait, sinceLastACK);
                    if (realWait >= ReliableOutputStream.this.RTO && oldestInQueueWait >= ReliableOutputStream.this.RTO) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("RTO RETRANSMISSION [" + ReliableOutputStream.this.rwindow + "]");
                        }
                        int retransed = ReliableOutputStream.this.retransmit(ReliableOutputStream.this.rwindow, TimeUtils.timeNow());
                        this.nretransmitted += retransed;
                        this.nAtThisRTO += retransed;
                        if (retransed > 0 && realWait >= 2L * ReliableOutputStream.this.RTO && this.nAtThisRTO >= 2 * ReliableOutputStream.this.rwindow) {
                            ReliableOutputStream.this.RTO = realWait > ReliableOutputStream.this.maxRTO ? ReliableOutputStream.this.maxRTO : 2L * ReliableOutputStream.this.RTO;
                            this.nAtThisRTO = 0;
                        }
                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("RETRANSMISSION " + retransed + " retrans " + this.nAtThisRTO + " at this RTO (" + ReliableOutputStream.this.RTO + ") " + this.nretransmitted + " total retrans");
                        continue;
                    }
                    if (++idleCounter == 2) {
                        ReliableOutputStream.this.RTO = ReliableOutputStream.this.minRTO;
                        idleCounter = 0;
                        this.nAtThisRTO = 0;
                    }
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("IDLE : RTO=" + ReliableOutputStream.this.RTO + " WAIT=" + realWait);
                }
            }
            catch (Throwable all) {
                LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
            }
            finally {
                ReliableOutputStream.this.hardClose();
                ReliableOutputStream.this.retrThread = null;
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("STOPPED Retransmit thread");
                }
            }
        }
    }

    private static class RetrQElt {
        final int seqnum;
        final Message msg;
        final long enqueuedAt;
        int marked;
        long sentAt;

        public RetrQElt(int seqnum, Message msg) {
            this.seqnum = seqnum;
            this.msg = msg;
            this.sentAt = this.enqueuedAt = TimeUtils.timeNow();
            this.marked = 0;
        }
    }
}

