/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.meter;

import net.jxta.meter.MonitorFilter;
import net.jxta.meter.MonitorReport;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;

public class MonitorEvent {
    public static final int OK = 200;
    public static final int CANCELLED_LOCALLY = 201;
    public static final int CANCELLED_REMOTELY = 202;
    public static final int TIMEOUT = 203;
    public static final int REFUSED = 204;
    public static final int INVALID_REPORT_RATE = 205;
    public static final int INVALID_MONITOR_FILTER = 206;
    public static final int LEASE_CANCELLED = 207;
    public static final int LEASE_RENEWAL_TIMEOUT = 208;
    public static final int ERROR = 209;
    public static final int PEERGROUP_DESTROYED = 210;
    private int type;
    private int requestId;
    private PeerID peerID;
    private PeerGroupID peerGroupID;
    private MonitorFilter monitorFilter;
    private long reportRate;
    private long leaseTime;
    private MonitorReport monitorReport;

    private MonitorEvent() {
    }

    public MonitorEvent(PeerGroupID peerGroupID, MonitorReport monitorReport) {
        this.peerGroupID = peerGroupID;
        this.monitorReport = monitorReport;
    }

    public int getType() {
        return this.type;
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    public PeerGroupID getPeerGroupID() {
        return this.peerGroupID;
    }

    public MonitorFilter getMonitorFilter() {
        return this.monitorFilter;
    }

    public long getReportRate() {
        return this.reportRate;
    }

    public long getLeaseTime() {
        return this.leaseTime;
    }

    public MonitorReport getMonitorReport() {
        return this.monitorReport;
    }

    public MonitorFilter getValidMonitorFilter() {
        return this.monitorFilter;
    }

    public static MonitorEvent createRemoteMonitorReportEvent(PeerID peerID, int requestId, MonitorReport monitorReport) {
        MonitorEvent event = new MonitorEvent();
        event.type = 200;
        event.peerID = peerID;
        event.requestId = requestId;
        event.monitorReport = monitorReport;
        return event;
    }

    public static MonitorEvent createFailureEvent(int type, PeerID peerID, int requestId) {
        MonitorEvent event = new MonitorEvent();
        event.type = type;
        event.peerID = peerID;
        event.requestId = requestId;
        return event;
    }
}

