/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.peergroup;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.access.AccessService;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.id.ID;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeService;
import net.jxta.platform.JxtaLoader;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;

public class LightWeightPeerGroup
implements PeerGroup {
    private static final Logger LOG = Logger.getLogger(LightWeightPeerGroup.class.getName());
    private PeerGroup group = null;
    private ID assignedID = null;
    private ModuleImplAdvertisement implAdv = null;
    private final PeerGroupAdvertisement adv;

    public LightWeightPeerGroup(PeerGroupAdvertisement adv) {
        this.adv = adv;
    }

    public void init(PeerGroup group, ID assignedID, Advertisement implAdv) {
        this.group = group;
        this.assignedID = assignedID;
        this.implAdv = (ModuleImplAdvertisement)implAdv;
    }

    public int startApp(String[] args) {
        if (null == this.group) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("No base peer group defined.");
            }
            return -1;
        }
        return 0;
    }

    public void stopApp() {
    }

    public Service getInterface() {
        return this;
    }

    public ModuleImplAdvertisement getImplAdvertisement() {
        return this.implAdv;
    }

    public ThreadGroup getHomeThreadGroup() {
        if (this.group != null) {
            return this.group.getHomeThreadGroup();
        }
        return null;
    }

    public URI getStoreHome() {
        if (this.group != null) {
            return this.group.getStoreHome();
        }
        return null;
    }

    public JxtaLoader getLoader() {
        if (this.group != null) {
            return this.group.getLoader();
        }
        return null;
    }

    public PeerGroup getParentGroup() {
        try {
            return this.group;
        }
        catch (Exception ex) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("LightWeightPeerGroup is a base PeerGroup: no parent");
            }
            throw new RuntimeException("LightWeightPeerGroup is a base PeerGroup: no parent");
        }
    }

    public boolean isRendezvous() {
        return this.group != null && this.group.isRendezvous();
    }

    public PeerGroupAdvertisement getPeerGroupAdvertisement() {
        if (this.adv != null) {
            return this.adv;
        }
        if (this.group != null) {
            return this.group.getPeerGroupAdvertisement();
        }
        return null;
    }

    public PeerAdvertisement getPeerAdvertisement() {
        if (this.group != null) {
            return this.group.getPeerAdvertisement();
        }
        return null;
    }

    public Service lookupService(ID name) throws ServiceNotFoundException {
        if (this.group != null) {
            return this.group.lookupService(name);
        }
        throw new ServiceNotFoundException("Not implemented");
    }

    public Service lookupService(ID name, int ignoredForNow) throws ServiceNotFoundException {
        if (this.group != null) {
            return this.group.lookupService(name);
        }
        throw new ServiceNotFoundException("Not implemented");
    }

    public Iterator getRoleMap(ID name) {
        if (this.group != null) {
            return this.group.getRoleMap(name);
        }
        return Collections.singletonList(name).iterator();
    }

    public boolean compatible(Element compat) {
        return this.group != null && this.group.compatible(compat);
    }

    public Module loadModule(ID assignedID, Advertisement impl) throws ProtocolNotSupportedException, PeerGroupException {
        if (this.group != null) {
            return this.group.loadModule(assignedID, impl);
        }
        throw new ProtocolNotSupportedException("LightWeightPeerGroup does not implement this operation");
    }

    public Module loadModule(ID assignedID, ModuleSpecID specID, int where) {
        if (this.group != null) {
            return this.group.loadModule(assignedID, specID, where);
        }
        return null;
    }

    public void publishGroup(String name, String description) throws IOException {
        if (this.group == null) {
            throw new IOException("Not implemented");
        }
        this.group.publishGroup(name, description);
    }

    public PeerGroup newGroup(Advertisement pgAdv) throws PeerGroupException {
        if (this.group != null) {
            return this.group.newGroup(pgAdv);
        }
        throw new PeerGroupException("Not implemented");
    }

    public PeerGroup newGroup(PeerGroupID gid, Advertisement impl, String name, String description) throws PeerGroupException {
        if (this.group != null) {
            return this.group.newGroup(gid, impl, name, description);
        }
        throw new PeerGroupException("Not implemented");
    }

    public PeerGroup newGroup(PeerGroupID gid) throws PeerGroupException {
        if (this.group != null) {
            return this.group.newGroup(gid);
        }
        throw new PeerGroupException("Not implemented");
    }

    public RendezVousService getRendezVousService() {
        if (this.group != null) {
            return this.group.getRendezVousService();
        }
        return null;
    }

    public EndpointService getEndpointService() {
        if (this.group != null) {
            return this.group.getEndpointService();
        }
        return null;
    }

    public ResolverService getResolverService() {
        if (this.group != null) {
            return this.group.getResolverService();
        }
        return null;
    }

    public DiscoveryService getDiscoveryService() {
        if (this.group != null) {
            return this.group.getDiscoveryService();
        }
        return null;
    }

    public PeerInfoService getPeerInfoService() {
        if (this.group != null) {
            return this.group.getPeerInfoService();
        }
        return null;
    }

    public MembershipService getMembershipService() {
        if (this.group != null) {
            return this.group.getMembershipService();
        }
        return null;
    }

    public PipeService getPipeService() {
        if (this.group != null) {
            return this.group.getPipeService();
        }
        return null;
    }

    public AccessService getAccessService() {
        if (this.group != null) {
            return this.group.getAccessService();
        }
        return null;
    }

    public PeerGroupID getPeerGroupID() {
        if (this.adv != null) {
            return (PeerGroupID)this.adv.getID();
        }
        if (this.group != null) {
            return this.group.getPeerGroupID();
        }
        throw new RuntimeException("No PeerGroupID");
    }

    public PeerID getPeerID() {
        if (this.group != null) {
            return this.group.getPeerID();
        }
        throw new RuntimeException("No PeerID");
    }

    public String getPeerGroupName() {
        if (this.adv != null) {
            return this.adv.getName();
        }
        if (this.group != null) {
            return this.group.getPeerGroupName();
        }
        throw new RuntimeException("No name");
    }

    public String getPeerName() {
        if (this.group != null) {
            return this.group.getPeerName();
        }
        throw new RuntimeException("No name");
    }

    public ConfigParams getConfigAdvertisement() {
        if (this.group != null) {
            return this.group.getConfigAdvertisement();
        }
        throw new RuntimeException("No ConfigAdvertisement");
    }

    public ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() throws Exception {
        if (this.group != null) {
            return this.group.getAllPurposePeerGroupImplAdvertisement();
        }
        throw new RuntimeException("Not implemented");
    }

    public void unref() {
    }

    public PeerGroup getWeakInterface() {
        return this;
    }
}

