/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;

public abstract class PipeAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    public static final String IdTag = "Id";
    public static final String TypeTag = "Type";
    public static final String NameTag = "Name";
    public static final String descTag = "Desc";
    private transient ID pipeId = ID.nullID;
    private String type = null;
    private String name = null;
    private Element description = null;

    public static String getAdvertisementType() {
        return "jxta:PipeAdvertisement";
    }

    public PipeAdvertisement clone() {
        try {
            PipeAdvertisement likeMe = (PipeAdvertisement)super.clone();
            likeMe.setPipeID(this.getPipeID());
            likeMe.setType(this.getType());
            likeMe.setName(this.getName());
            likeMe.setDesc(this.getDesc());
            return likeMe;
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PipeAdvertisement) {
            PipeAdvertisement likeMe = (PipeAdvertisement)obj;
            if (!this.getPipeID().equals(likeMe.getPipeID())) {
                return false;
            }
            if (!this.getType().equals(likeMe.getType())) {
                return false;
            }
            String pipeName = this.getName();
            if (pipeName == null ? likeMe.getName() != null : !pipeName.equals(likeMe.getName())) {
                return false;
            }
            String pipeDescription = this.getDescription();
            return !(pipeDescription != null ? pipeDescription.equals(likeMe.getDescription()) : likeMe.getDescription() != null);
        }
        return false;
    }

    public int hashCode() {
        String pipeDescription;
        int result = 17;
        result = 37 * result + this.getPipeID().hashCode();
        result = 37 * result + this.getType().hashCode();
        String pipeName = this.getName();
        if (pipeName != null) {
            result = 37 * result + pipeName.hashCode();
        }
        if ((pipeDescription = this.getDescription()) != null) {
            result = 37 * result + pipeDescription.hashCode();
        }
        return result;
    }

    public final String getBaseAdvType() {
        return PipeAdvertisement.getAdvertisementType();
    }

    public ID getID() {
        ID result = this.getPipeID();
        if (null == result) {
            result = ID.nullID;
        }
        return result;
    }

    public ID getPipeID() {
        return this.pipeId;
    }

    public void setPipeID(ID pipeId) {
        this.pipeId = pipeId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        if (null != this.description) {
            return (String)this.description.getValue();
        }
        return null;
    }

    public void setDescription(String description) {
        if (null != description) {
            StructuredDocument newdoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, descTag, description);
            this.setDesc(newdoc);
        } else {
            this.description = null;
        }
    }

    public StructuredDocument getDesc() {
        if (null != this.description) {
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(this.description);
            return newDoc;
        }
        return null;
    }

    public void setDesc(Element desc) {
        this.description = null != desc ? StructuredDocumentUtils.copyAsDocument(desc) : null;
    }
}

