/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.websphere;

import com.sun.jbi.framework.JBIFramework;
import com.sun.jbi.framework.websphere.WebSphereJBIFrameworkMBean;
import com.sun.jbi.framework.websphere.WebSpherePlatformContext;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class WebSphereJBIFramework
extends JBIFramework
implements WebSphereJBIFrameworkMBean {
    public static final String INSTALL_ROOT = "install.root";
    public static final String INSTANCE_NAME = "instance.name";
    private static final String DEFAULT_INSTALL_ROOT = System.getProperty("user.dir");
    private static final String DEFAULT_INSTANCE_NAME = "server";
    private WebSpherePlatformContext mPlatformContext;
    private boolean mLoaded;
    private Properties mEnvironment;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());

    public WebSphereJBIFramework(Properties environment) {
        this.mEnvironment = environment;
        this.mPlatformContext = new WebSpherePlatformContext(this.mEnvironment.getProperty(INSTANCE_NAME, DEFAULT_INSTANCE_NAME), this.mEnvironment.getProperty(INSTALL_ROOT, DEFAULT_INSTALL_ROOT));
    }

    public synchronized void load() throws Exception {
        try {
            if (this.mLoaded) {
                throw new IllegalStateException("JBI framework already loaded!");
            }
            ObjectName fwMBeanName = new ObjectName("com.sun.jbi", "instance", this.mPlatformContext.getInstanceName());
            MBeanServer mbs = this.mPlatformContext.getMBeanServer();
            if (mbs.isRegistered(fwMBeanName)) {
                if (mbs.getAttribute(fwMBeanName, "Loaded").equals(Boolean.TRUE)) {
                    throw new IllegalStateException("JBI framework instance " + this.mPlatformContext.getInstanceName() + " has already been loaded");
                }
                mbs.unregisterMBean(fwMBeanName);
            }
            try {
                mbs.registerMBean(this, fwMBeanName);
            }
            catch (Exception ex) {
                this.mLog.severe(ex.getMessage());
                ex.printStackTrace();
            }
            this.mEnvironment.setProperty("com.sun.jbi.home", this.mPlatformContext.getInstallRoot());
            this.init(this.mPlatformContext, this.mEnvironment);
            this.startup(this.mPlatformContext.getNamingContext(), "");
            this.prepare();
            this.ready(true);
            this.mLoaded = true;
        }
        catch (Exception ex) {
            this.mLog.severe(ex.getMessage());
        }
    }

    public boolean isLoaded() {
        return this.mLoaded;
    }

    public synchronized void unload() throws Exception {
        if (!this.mLoaded) {
            return;
        }
        this.shutdown();
        this.terminate();
        this.mLoaded = false;
    }

    public MBeanServerConnection getMBeanServerConnection() throws Exception {
        return this.mPlatformContext.getMBeanServerConnection(null);
    }
}

