/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.config;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.config.ConfigurationFactory;
import com.sun.jbi.management.config.DescriptorSupport;
import com.sun.jbi.management.util.PropertyFilter;
import com.sun.jbi.util.EnvironmentAccess;
import java.io.File;
import java.util.Properties;
import javax.management.modelmbean.ModelMBeanAttributeInfo;

public class InstallationConfigurationFactory
extends ConfigurationFactory {
    public static final String COMPONENT_TIMEOUT = "componentTimeout";
    public static final String INSTALLATION_TIMEOUT = "installationTimeout";
    public static final String ENABLE_AUTO_INSTALL = "autoInstallEnabled";
    public static final String ENABLE_AUTO_REINSTALL = "autoReinstallEnabled";
    public static final String ENABLE_AUTO_UNINSTALL = "autoUninstallEnabled";
    public static final String AUTO_INSTALL_DIR = "autoInstallDir";
    private static final int sNumAttributes = 6;

    public InstallationConfigurationFactory(Properties defProps) {
        super(defProps, ConfigurationCategory.Installation);
    }

    public ModelMBeanAttributeInfo[] createMBeanAttributeInfo() {
        ModelMBeanAttributeInfo[] attributeInfos = new ModelMBeanAttributeInfo[6];
        DescriptorSupport descr = new DescriptorSupport();
        String attrDescr = this.getString("COMPONENT_TIMEOUT_DESCR");
        descr.setAttributeName(COMPONENT_TIMEOUT);
        descr.setDisplayName(this.getString("COMPONENT_TIMEOUT_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("COMPONENT_TIMEOUT_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("COMPONENT_TIMEOUT_DESCR"));
        descr.setToolTip(this.getString("COMPONENT_TIMEOUT_TOOLTIP"));
        descr.setToolTipId(this.getToken("COMPONENT_TIMEOUT_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        String defCompTimeout = this.mDefaults.getProperty(this.getQualifiedKey(COMPONENT_TIMEOUT), "0");
        descr.setDefault(Integer.parseInt(defCompTimeout));
        descr.setMinValue("0");
        descr.setMaxValue(Integer.MAX_VALUE);
        descr.setUnit("milliseconds");
        attributeInfos[0] = new ModelMBeanAttributeInfo(COMPONENT_TIMEOUT, "int", attrDescr, true, true, false, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("INSTALLATION_TIMEOUT_DESCR");
        descr.setAttributeName(INSTALLATION_TIMEOUT);
        descr.setDisplayName(this.getString("INSTALLATION_TIMEOUT_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("INSTALLATION_TIMEOUT_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("INSTALLATION_TIMEOUT_DESCR"));
        descr.setToolTip(this.getString("INSTALLATION_TIMEOUT_TOOLTIP"));
        descr.setToolTipId(this.getToken("INSTALLATION_TIMEOUT_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        String defInstTimeout = this.mDefaults.getProperty(this.getQualifiedKey(INSTALLATION_TIMEOUT), "0");
        descr.setDefault(Integer.parseInt(defInstTimeout));
        descr.setMinValue(0);
        descr.setMaxValue(Integer.MAX_VALUE);
        descr.setUnit("milliseconds");
        attributeInfos[1] = new ModelMBeanAttributeInfo(INSTALLATION_TIMEOUT, "int", attrDescr, true, true, false, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("ENABLE_AUTO_INSTALL_DESCR");
        descr.setAttributeName(ENABLE_AUTO_INSTALL);
        descr.setDisplayName(this.getString("ENABLE_AUTO_INSTALL_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("ENABLE_AUTO_INSTALL_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("ENABLE_AUTO_INSTALL_DESCR"));
        descr.setToolTip(this.getString("ENABLE_AUTO_INSTALL_TOOLTIP"));
        descr.setToolTipId(this.getToken("ENABLE_AUTO_INSTALL_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        String defEnableAutoInstall = this.mDefaults.getProperty(this.getQualifiedKey(ENABLE_AUTO_INSTALL), "true");
        boolean autoInstallEnabled = Boolean.parseBoolean(defEnableAutoInstall);
        descr.setDefault(autoInstallEnabled);
        attributeInfos[2] = new ModelMBeanAttributeInfo(ENABLE_AUTO_INSTALL, "boolean", attrDescr, true, true, true, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("ENABLE_AUTO_UNINSTALL_DESCR");
        descr.setAttributeName(ENABLE_AUTO_UNINSTALL);
        descr.setDisplayName(this.getString("ENABLE_AUTO_UNINSTALL_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("ENABLE_AUTO_UNINSTALL_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("ENABLE_AUTO_UNINSTALL_DESCR"));
        descr.setToolTip(this.getString("ENABLE_AUTO_UNINSTALL_TOOLTIP"));
        descr.setToolTipId(this.getToken("ENABLE_AUTO_UNINSTALL_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        String defEnableAutoUninstall = this.mDefaults.getProperty(this.getQualifiedKey(ENABLE_AUTO_UNINSTALL), "true");
        boolean autoUninstallEnabled = Boolean.parseBoolean(defEnableAutoUninstall) && autoInstallEnabled;
        descr.setDefault(autoUninstallEnabled);
        attributeInfos[3] = new ModelMBeanAttributeInfo(ENABLE_AUTO_UNINSTALL, "boolean", attrDescr, true, true, true, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("ENABLE_AUTO_REINSTALL_DESCR");
        descr.setAttributeName(ENABLE_AUTO_REINSTALL);
        descr.setDisplayName(this.getString("ENABLE_AUTO_REINSTALL_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("ENABLE_AUTO_REINSTALL_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("ENABLE_AUTO_REINSTALL_DESCR"));
        descr.setToolTip(this.getString("ENABLE_AUTO_REINSTALL_TOOLTIP"));
        descr.setToolTipId(this.getToken("ENABLE_AUTO_REINSTALL_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(false);
        String defEnableAutoReinstall = this.mDefaults.getProperty(this.getQualifiedKey(ENABLE_AUTO_REINSTALL), "true");
        boolean autoReinstallEnabled = Boolean.parseBoolean(defEnableAutoReinstall) && autoInstallEnabled && autoUninstallEnabled;
        descr.setDefault(autoReinstallEnabled);
        attributeInfos[4] = new ModelMBeanAttributeInfo(ENABLE_AUTO_REINSTALL, "boolean", attrDescr, true, true, true, descr);
        descr = new DescriptorSupport();
        attrDescr = this.getString("AUTO_INSTALL_DIR_DESCR");
        descr.setAttributeName(AUTO_INSTALL_DIR);
        descr.setDisplayName(this.getString("AUTO_INSTALL_DIR_DISPLAY_NAME"));
        descr.setDisplayNameId(this.getToken("AUTO_INSTALL_DIR_DISPLAY_NAME"));
        descr.setDescriptionId(this.getToken("AUTO_INSTALL_DIR_DESCR"));
        descr.setToolTip(this.getString("AUTO_INSTALL_DIR_TOOLTIP"));
        descr.setToolTipId(this.getToken("AUTO_INSTALL_DIR_TOOLTIP"));
        descr.setResourceBundleName("com.sun.jbi.management");
        descr.setIsStatic(true);
        descr.setDefault(this.getAutoInstallDir());
        attributeInfos[5] = new ModelMBeanAttributeInfo(AUTO_INSTALL_DIR, "java.lang.String", attrDescr, true, false, false, descr);
        return attributeInfos;
    }

    private String getAutoInstallDir() {
        EnvironmentContext envCtx = EnvironmentAccess.getContext();
        StringBuffer installDir = new StringBuffer(envCtx.getJbiInstanceRoot());
        installDir.append(File.separator);
        installDir.append("autoinstall");
        String defInstallDir = this.mDefaults.getProperty(this.getQualifiedKey(AUTO_INSTALL_DIR), installDir.toString());
        String absInstalldir = PropertyFilter.filterProperties(defInstallDir);
        if (absInstalldir != null) {
            absInstalldir = absInstalldir.replace('\\', '/');
        }
        return absInstalldir;
    }
}

