/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.ee;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.ee.ApplicationInterceptor;
import com.sun.jbi.management.message.MessageBuilder;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.xml.sax.InputSource;

public class JavaEEApplicationInterceptor
implements ApplicationInterceptor {
    private static final String JAVA_EE_SE = "sun-javaee-engine";
    private static final String JAVA_EE_DEPLOYER_MBEAN = "JavaEEDeployer";
    private static final String FAILED = "FAILED";
    private EnvironmentContext mCtx;
    private ObjectName mJavaEEDeployerMBean;
    private Logger mLog = Logger.getLogger("com.sun.jbi.management.ee");
    private StringTranslator mTranslator;
    private XPath mXPath;

    public JavaEEApplicationInterceptor(EnvironmentContext ctx) {
        this.mCtx = ctx;
        this.mTranslator = ctx.getStringTranslator(this.getClass().getPackage().getName());
        this.mJavaEEDeployerMBean = this.mCtx.getMBeanNames().getCustomEngineMBeanName(JAVA_EE_DEPLOYER_MBEAN, JAVA_EE_SE);
        this.mXPath = XPathFactory.newInstance().newXPath();
        this.mXPath.setNamespaceContext(new JBINSContext());
    }

    public String performAction(String operation, String serviceAssemblyName, String serviceUnitName, String serviceUnitRootPath, String target) throws Exception {
        String result = null;
        if ("deploy".equals(operation) || "undeploy".equals(operation)) {
            result = this.invokeJavaEEMBean(operation, new String[]{serviceAssemblyName, serviceUnitName, serviceUnitRootPath, target});
        } else if ("start".equals(operation) || "stop".equals(operation) || "shutDown".equals(operation)) {
            result = this.invokeJavaEEMBean(operation, new String[]{serviceAssemblyName, serviceUnitName, target});
        } else {
            this.mLog.fine("ApplicationInterceptor: unknown operation " + operation + "for service unit " + serviceUnitName);
        }
        if (result != null) {
            this.verifyResult(operation, result);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String invokeJavaEEMBean(String operation, String[] params) throws Exception {
        String response = null;
        Object[] methodSig = new String[params.length];
        Arrays.fill(methodSig, "java.lang.String");
        if (this.mCtx.getMBeanServer().isRegistered(this.mJavaEEDeployerMBean)) {
            try {
                response = (String)this.mCtx.getMBeanServer().invoke(this.mJavaEEDeployerMBean, operation, params, (String[])methodSig);
                this.mLog.finer("Response from JavaEEDeployer MBean: " + response);
                return response;
            }
            catch (MBeanException ex) {
                response = ex.getTargetException().getMessage();
                if (MessageBuilder.isXmlString(response)) return response;
                throw ex.getTargetException();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return response;
            }
        } else {
            this.mLog.warning(this.mTranslator.getString("JBI_ADMIN_NO_JAVAEEDEPLOYER_MBEAN", this.mJavaEEDeployerMBean));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyResult(String operation, String result) throws Exception {
        XPath xPath = this.mXPath;
        synchronized (xPath) {
            if (FAILED.equals(this.mXPath.evaluate("//jbi:task-result", new InputSource(new StringReader(result))))) {
                throw new Exception(this.mXPath.evaluate("//jbi:loc-message", new InputSource(new StringReader(result))));
            }
        }
    }

    class JBINSContext
    implements NamespaceContext {
        String JBI_NS_PREFIX = "jbi";
        String JBI_NS_URI = "http://java.sun.com/xml/ns/jbi/management-message";

        JBINSContext() {
        }

        public Iterator getPrefixes(String namespaceURI) {
            ArrayList<String> p = new ArrayList<String>();
            if (namespaceURI.equals(this.JBI_NS_PREFIX)) {
                p.add(this.JBI_NS_URI);
            }
            return p.iterator();
        }

        public String getPrefix(String namespaceURI) {
            return this.JBI_NS_PREFIX;
        }

        public String getNamespaceURI(String prefix) {
            return this.JBI_NS_URI;
        }
    }
}

