/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.VersionInfo;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.facade.Facade;
import com.sun.jbi.management.system.ManagementException;
import com.sun.jbi.management.util.FacadeMbeanHelper;
import java.util.ArrayList;
import javax.jbi.management.AdminServiceMBean;
import javax.management.ObjectName;

public class AdminService
extends Facade
implements AdminServiceMBean {
    private final String SERVICE_SUFFIX = "Service";

    public AdminService(EnvironmentContext ctx, String target) throws ManagementException {
        super(ctx, target);
    }

    public ObjectName getSystemService(String serviceName) {
        return this.mMBeanNames.getSystemServiceMBeanName(Enum.valueOf(MBeanNames.ServiceName.class, serviceName), this.getServiceType(serviceName), this.mTarget);
    }

    public ObjectName[] getSystemServices() {
        ObjectName[] names = new ObjectName[]{this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.AdminService, MBeanNames.ServiceType.Admin, this.mTarget), this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, this.mTarget), this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, this.mTarget)};
        return names;
    }

    public ObjectName getComponentByName(String componentName) {
        ObjectName objName = null;
        try {
            if (this.isBinding(componentName)) {
                objName = this.mMBeanNames.getBindingMBeanName(componentName, MBeanNames.ComponentServiceType.ComponentLifeCycle, this.mTarget);
            } else if (this.isEngine(componentName)) {
                objName = this.mMBeanNames.getEngineMBeanName(componentName, MBeanNames.ComponentServiceType.ComponentLifeCycle, this.mTarget);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return objName;
    }

    public ObjectName[] getBindingComponents() {
        ObjectName[] bindingComponents = new ObjectName[]{};
        try {
            ObjectName[] names = FacadeMbeanHelper.getComponentLifeCycleObjectNames(this.mEnvCtx.getMBeanServer(), this.mEnvCtx.getMBeanNames(), this.mTarget);
            bindingComponents = this.filterComponentLifeCyleNames(names, ComponentType.BINDING);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bindingComponents;
    }

    public ObjectName[] getEngineComponents() {
        ObjectName[] engineComponents = new ObjectName[]{};
        try {
            ObjectName[] names = FacadeMbeanHelper.getComponentLifeCycleObjectNames(this.mEnvCtx.getMBeanServer(), this.mEnvCtx.getMBeanNames(), this.mTarget);
            engineComponents = this.filterComponentLifeCyleNames(names, ComponentType.ENGINE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return engineComponents;
    }

    public boolean isBinding(String componentName) {
        boolean isBinding = false;
        try {
            isBinding = ComponentType.BINDING == this.getGenericQuery().getComponentType(componentName);
        }
        catch (Exception rex) {
            isBinding = false;
        }
        return isBinding;
    }

    public boolean isEngine(String componentName) {
        boolean isEngine = false;
        try {
            isEngine = ComponentType.ENGINE == this.getGenericQuery().getComponentType(componentName);
        }
        catch (Exception rex) {
            isEngine = false;
        }
        return isEngine;
    }

    public String getSystemInfo() {
        VersionInfo vers = this.mEnvCtx.getVersionInfo();
        return vers.fullProductName() + "\n" + vers.majorVersion() + "." + vers.minorVersion() + "(" + vers.buildNumber() + ")" + "\n" + vers.copyright() + "\n";
    }

    private ObjectName[] filterComponentLifeCyleNames(ObjectName[] names, ComponentType type) throws Exception {
        ArrayList<ObjectName> resultObjNames = new ArrayList<ObjectName>();
        for (ObjectName compLCName : names) {
            String compName = compLCName.getKeyProperty("ComponentName");
            if (type != this.getGenericQuery().getComponentType(compName)) continue;
            resultObjNames.add(compLCName);
        }
        return resultObjNames.toArray(new ObjectName[resultObjNames.size()]);
    }

    private MBeanNames.ServiceType getServiceType(String serviceName) {
        MBeanNames.ServiceType serviceType = null;
        if (serviceName.endsWith("Service")) {
            String type = serviceName.replaceAll("Service", "");
            serviceType = Enum.valueOf(MBeanNames.ServiceType.class, type);
        }
        return serviceType;
    }
}

