/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import com.sun.jbi.ComponentManager;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceUnitRegistration;
import com.sun.jbi.VersionInfo;
import com.sun.jbi.management.MBeanHelper;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.repository.Repository;
import com.sun.jbi.management.support.MBeanNamesImpl;
import com.sun.jbi.management.system.AdminService;
import com.sun.jbi.management.system.BuildManagementMessageImpl;
import com.sun.jbi.management.system.ConfigurationService;
import com.sun.jbi.management.system.DeploymentService;
import com.sun.jbi.management.system.InstallationService;
import com.sun.jbi.management.system.LoggingService;
import com.sun.jbi.messaging.ConnectionManager;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;

public class ManagementContext {
    private static EnvironmentContext sEnv = null;
    private static Logger sLog = null;
    private static MBeanHelper sMBeanHelper = null;
    private static BuildManagementMessageImpl mMMImpl = null;
    private static Repository sRepository;
    private static int sMBeanServerPort;
    private static ObjectName sHtmlAdaptorName;
    private static int sHtmlAdaptorPort;
    private static JMXConnectorServer sJmxRemoteServer;
    private static String sJbiRoot;
    private static AdminService sAdminServiceHandle;
    private static ConfigurationService sConfigurationServiceHandle;
    private static DeploymentService sDeploymentServiceHandle;
    private static InstallationService sInstallationServiceHandle;
    private static LoggingService sLoggingServiceHandle;

    public ManagementContext(EnvironmentContext anEnv) {
        sEnv = anEnv;
        sLog = Logger.getLogger("com.sun.jbi.management");
        sMBeanHelper = anEnv.getMBeanHelper();
        mMMImpl = new BuildManagementMessageImpl();
    }

    public static String getJbiInstallRoot() {
        return sEnv.getJbiInstanceRoot();
    }

    public static VersionInfo getVersionInfo() {
        return sEnv.getVersionInfo();
    }

    public static Logger getLogger() {
        return sLog;
    }

    public static MBeanNames getMBeanNames() {
        return sEnv.getMBeanNames();
    }

    public MBeanNames getMBeanNames(String instanceName) {
        ObjectName someName = ManagementContext.getMBeanNames().getBindingMBeanName("xyz", "Lifecycle");
        String domainName = someName.getDomain();
        MBeanNamesImpl mbnNames = new MBeanNamesImpl(domainName, instanceName);
        return mbnNames;
    }

    public static MBeanHelper getMBeanHelper() {
        return sMBeanHelper;
    }

    public static MBeanServer getMBeanServer() {
        return sEnv.getMBeanServer();
    }

    public static MBeanServerConnection getCentralMBeanServer() {
        return sEnv.getMBeanServer();
    }

    public ComponentManager getComponentManager() {
        return sEnv.getComponentManager();
    }

    public ComponentQuery getComponentQuery() {
        return sEnv.getComponentQuery();
    }

    public Object getManagementClass(String aServiceName) {
        return sEnv.getManagementClass(aServiceName);
    }

    public static String getJbiDomainRoot() {
        return System.getProperty("com.sun.jbi.domain.root");
    }

    public static EnvironmentContext getEnvironmentContext() {
        return sEnv;
    }

    public static String getJbiPropertiesFullPath() {
        return ManagementContext.getJbiDomainRoot() + "/jbi/config/jbienv.properties";
    }

    public static BuildManagementMessageImpl getManagementMessageObject() {
        return mMMImpl;
    }

    public ServiceUnitRegistration getServiceUnitRegistration() {
        return sEnv.getServiceUnitRegistration();
    }

    public static void setMBeanServerPort(int aMBeanServerPort) {
        sMBeanServerPort = aMBeanServerPort;
    }

    public static int getMBeanServerPort() {
        return sMBeanServerPort;
    }

    public static void setHtmlAdaptorName(ObjectName aHtmlAdaptorName) {
        sHtmlAdaptorName = aHtmlAdaptorName;
    }

    public static ObjectName getHtmlAdaptorName() {
        return sHtmlAdaptorName;
    }

    public static void setHtmlAdaptorPort(int aHtmlAdaptorPort) {
        sHtmlAdaptorPort = aHtmlAdaptorPort;
    }

    public static int getHtmlAdaptorPort() {
        return sHtmlAdaptorPort;
    }

    public static void setJmxRemoteServer(JMXConnectorServer aJmxRemoteServer) {
        sJmxRemoteServer = aJmxRemoteServer;
    }

    public static JMXConnectorServer getJmxRemoteServer() {
        return sJmxRemoteServer;
    }

    public static void setJbiRoot(String aJbiRoot) {
        sJbiRoot = aJbiRoot;
    }

    public static String getJbiRoot() {
        return sJbiRoot;
    }

    public static void setAdminServiceHandle(AdminService aAdminServiceHandle) {
        sAdminServiceHandle = aAdminServiceHandle;
    }

    public static AdminService getAdminServiceHandle() {
        return sAdminServiceHandle;
    }

    public static void setDeploymentServiceHandle(DeploymentService aDeploymentServiceHandle) {
        sDeploymentServiceHandle = aDeploymentServiceHandle;
    }

    public static DeploymentService getDeploymentServiceHandle() {
        return sDeploymentServiceHandle;
    }

    public static void setInstallationServiceHandle(InstallationService aInstallationServiceHandle) {
        sInstallationServiceHandle = aInstallationServiceHandle;
    }

    public static InstallationService getInstallationServiceHandle() {
        return sInstallationServiceHandle;
    }

    public static void setLoggingServiceHandle(LoggingService aLoggingServiceHandle) {
        sLoggingServiceHandle = aLoggingServiceHandle;
    }

    public static LoggingService getLoggingServiceHandle() {
        return sLoggingServiceHandle;
    }

    public static ConnectionManager getConnectionManager() {
        return sEnv.getConnectionManager();
    }

    public static ObjectName getFrameworkConfigurationMBeanName() {
        MBeanNames mBeanNames = ManagementContext.getMBeanNames();
        ManagementContext.getMBeanNames();
        ManagementContext.getMBeanNames();
        return mBeanNames.getSystemServiceMBeanName("Framework", "Configuration");
    }

    public Repository getRepository() {
        return sRepository;
    }

    public void setRepository(Repository repos) {
        sRepository = repos;
    }
}

