/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.ConnectionManager;
import com.sun.jbi.messaging.ExternalEndpoint;
import com.sun.jbi.messaging.InternalEndpoint;
import com.sun.jbi.messaging.Link;
import com.sun.jbi.messaging.LinkedEndpoint;
import com.sun.jbi.messaging.MessageService;
import com.sun.jbi.messaging.RegisteredEndpoint;
import com.sun.jbi.messaging.util.Translator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;

public class EndpointRegistry
implements ConnectionManager {
    private static EndpointRegistry mMe;
    private ConcurrentHashMap<Endpoint, RegisteredEndpoint> mInternalEndpoints;
    private ConcurrentHashMap<QName, VectorArray> mIEbyService;
    private ConcurrentHashMap<QName, VectorArray> mIEbyInterface;
    private LinkedList<RegisteredEndpoint> mPendingInternalInterfaces;
    private ConcurrentHashMap<Endpoint, RegisteredEndpoint> mExternalEndpoints;
    private ConcurrentHashMap<QName, VectorArray> mEEbyService;
    private ConcurrentHashMap<QName, VectorArray> mEEbyInterface;
    private LinkedList<RegisteredEndpoint> mPendingExternalInterfaces;
    private ConcurrentHashMap<Endpoint, LinkedEndpoint> mLinkedEndpoints;
    private ConcurrentHashMap<QName, Endpoint> mInterfaceConnections;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());

    private EndpointRegistry() {
        this.mInternalEndpoints = new ConcurrentHashMap();
        this.mIEbyService = new ConcurrentHashMap();
        this.mIEbyInterface = new ConcurrentHashMap();
        this.mPendingInternalInterfaces = new LinkedList();
        this.mExternalEndpoints = new ConcurrentHashMap();
        this.mEEbyService = new ConcurrentHashMap();
        this.mEEbyInterface = new ConcurrentHashMap();
        this.mPendingExternalInterfaces = new LinkedList();
        this.mLinkedEndpoints = new ConcurrentHashMap();
        this.mInterfaceConnections = new ConcurrentHashMap();
    }

    static final synchronized EndpointRegistry getInstance() {
        if (mMe == null) {
            mMe = new EndpointRegistry();
        }
        return mMe;
    }

    public synchronized RegisteredEndpoint registerExternalEndpoint(ServiceEndpoint endpoint, String ownerId) throws MessagingException {
        Endpoint ep = new Endpoint(endpoint.getServiceName(), endpoint.getEndpointName());
        RegisteredEndpoint re = this.mExternalEndpoints.get(ep);
        if (re != null) {
            throw new MessagingException(Translator.translate("DUPLICATE_ENDPOINT"));
        }
        re = new ExternalEndpoint(endpoint, ownerId);
        this.mEEbyService.put(endpoint.getServiceName(), new VectorArray(this.mEEbyService.get(endpoint.getServiceName()), re));
        this.mExternalEndpoints.put(ep, re);
        this.mPendingExternalInterfaces.add(re);
        this.mLog.fine(Translator.translate("ENDPOINT_REGISTER", new Object[]{re.toString()}));
        return re;
    }

    public RegisteredEndpoint getExternalEndpoint(QName service, String endpoint) {
        return this.mExternalEndpoints.get(new Endpoint(service, endpoint));
    }

    public RegisteredEndpoint[] getExternalEndpointsForService(QName service) {
        VectorArray va = this.mEEbyService.get(service);
        return va == null ? new RegisteredEndpoint[]{} : va.mArray;
    }

    public RegisteredEndpoint[] getExternalEndpointsForInterface(QName interfaceName, MessageService msgSvc) {
        return this.getEndpointsForInterface(interfaceName, 20, msgSvc);
    }

    public synchronized RegisteredEndpoint registerInternalEndpoint(QName service, String endpoint, String ownerId) throws MessagingException {
        Endpoint ep = new Endpoint(service, endpoint);
        RegisteredEndpoint re = this.mInternalEndpoints.get(ep);
        if (re != null) {
            if (!re.getOwnerId().equals(ownerId)) {
                throw new MessagingException(Translator.translate("DUPLICATE_ENDPOINT"));
            }
            this.mLog.fine(Translator.translate("ENDPOINT_DUPLICATE_OK", new Object[]{endpoint, ownerId}));
            return re;
        }
        re = new InternalEndpoint(service, endpoint, ownerId);
        this.mIEbyService.put(service, new VectorArray(this.mIEbyService.get(service), re));
        this.mInternalEndpoints.put(ep, re);
        this.mPendingInternalInterfaces.add(re);
        this.mLog.fine(Translator.translate("ENDPOINT_REGISTER", new Object[]{re.toString()}));
        return re;
    }

    public RegisteredEndpoint getInternalEndpoint(QName service, String endpoint) {
        Endpoint e = new Endpoint(service, endpoint);
        RegisteredEndpoint re = this.mLinkedEndpoints.get(e);
        if (re == null) {
            re = this.mInternalEndpoints.get(e);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RegisteredEndpoint[] getInternalEndpointsForService(QName service, boolean convertLinks) {
        RegisteredEndpoint[] endpoints;
        Object va;
        boolean cloned = false;
        if (service != null) {
            va = this.mIEbyService.get(service);
            endpoints = va == null ? new RegisteredEndpoint[]{} : ((VectorArray)va).mArray;
        } else {
            va = this;
            synchronized (va) {
                endpoints = new RegisteredEndpoint[this.mInternalEndpoints.size()];
                this.mInternalEndpoints.values().toArray(endpoints);
            }
        }
        if (convertLinks) {
            RegisteredEndpoint re;
            for (int i = 0; i < endpoints.length && (re = endpoints[i]) instanceof LinkedEndpoint; ++i) {
                LinkedEndpoint le;
                if (!cloned) {
                    endpoints = (RegisteredEndpoint[])endpoints.clone();
                    cloned = true;
                }
                if ((re = this.mInternalEndpoints.get(new Endpoint((le = (LinkedEndpoint)re).getServiceLink(), le.getEndpointLink()))) == null) {
                    this.mLog.warning(Translator.translate("BAD_SERVICE_CONNECTION", new Object[]{service}));
                    continue;
                }
                endpoints[i] = re;
            }
        }
        return endpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredEndpoint[] getInternalEndpointsForInterface(QName interfaceName, MessageService msgSvc) {
        RegisteredEndpoint[] endpoints;
        if (interfaceName != null) {
            Endpoint link = this.mInterfaceConnections.get(interfaceName);
            if (link != null) {
                RegisteredEndpoint ep = this.mInternalEndpoints.get(new Endpoint(link.mServiceName, link.mEndpointName));
                if (ep == null) {
                    this.mLog.warning(Translator.translate("BAD_INTERFACE_CONNECTION", new Object[]{interfaceName}));
                    endpoints = new RegisteredEndpoint[]{};
                } else {
                    endpoints = new RegisteredEndpoint[]{ep};
                }
            } else {
                endpoints = this.getEndpointsForInterface(interfaceName, 20, msgSvc);
            }
        } else {
            EndpointRegistry endpointRegistry = this;
            synchronized (endpointRegistry) {
                endpoints = new RegisteredEndpoint[this.mInternalEndpoints.size()];
                this.mInternalEndpoints.values().toArray(endpoints);
            }
        }
        return endpoints;
    }

    public synchronized void removeEndpoint(ServiceEndpoint ref) {
        RegisteredEndpoint re = ref instanceof RegisteredEndpoint ? (RegisteredEndpoint)ref : this.mExternalEndpoints.get(new Endpoint(ref.getServiceName(), ref.getEndpointName()));
        if (re != null) {
            re.setActive(false);
            if (re.isInternal()) {
                this.removeInternalEndpoint(re);
            } else if (re.isExternal()) {
                this.removeExternalEndpoint(re);
            } else if (re.isLinked()) {
                this.removeLinkedEndpoint(re);
            }
            this.mLog.fine(Translator.translate("ENDPOINT_REMOVED", new Object[]{ref.toString()}));
        }
    }

    public synchronized void addEndpointConnection(QName fromService, String fromEndpoint, QName toService, String toEndpoint, Link linkType) throws MessagingException {
        Endpoint ep = new Endpoint(fromService, fromEndpoint);
        this.mLog.fine(Translator.translate("ADD_ENDPOINT_CONNECTION", new Object[]{fromService, fromEndpoint}));
        LinkedEndpoint re = this.mLinkedEndpoints.get(ep);
        LinkedEndpoint link = new LinkedEndpoint(fromService, fromEndpoint, toService, toEndpoint, linkType);
        if (re != null && !((RegisteredEndpoint)re).equals(link)) {
            throw new MessagingException(Translator.translate("ENDPOINT_CONNECTION_EXISTS", new Object[]{fromService, fromEndpoint}));
        }
        VectorArray va = new VectorArray(this.mIEbyService.get(fromService), link);
        this.mIEbyService.put(fromService, va);
        this.mLinkedEndpoints.put(ep, link);
    }

    public synchronized boolean removeEndpointConnection(QName fromService, String fromEndpoint, QName toService, String toEndpoint) {
        boolean isRemoved = false;
        this.mLog.fine(Translator.translate("REMOVE_ENDPOINT_CONNECTION", new Object[]{fromService, fromEndpoint}));
        LinkedEndpoint link = this.mLinkedEndpoints.get(new Endpoint(fromService, fromEndpoint));
        if (link != null) {
            this.removeEndpoint(link);
            isRemoved = true;
        }
        return isRemoved;
    }

    public synchronized void addInterfaceConnection(QName fromInterface, QName toService, String toEndpoint) throws MessagingException {
        Endpoint ep = new Endpoint(toService, toEndpoint);
        if (this.mInterfaceConnections.containsKey(fromInterface) && !ep.equals(this.mInterfaceConnections.get(fromInterface))) {
            throw new MessagingException(Translator.translate("INTERFACE_CONNECTION_EXISTS", new Object[]{fromInterface}));
        }
        this.mLog.fine(Translator.translate("ADD_INTERFACE_CONNECTION", new Object[]{fromInterface}));
        this.mInterfaceConnections.put(fromInterface, ep);
    }

    public synchronized boolean removeInterfaceConnection(QName fromInterface, QName toService, String toEndpoint) {
        this.mLog.fine(Translator.translate("REMOVE_INTERFACE_CONNECTION", new Object[]{fromInterface}));
        return this.mInterfaceConnections.remove(fromInterface) != null;
    }

    public RegisteredEndpoint resolveLinkedEndpoint(LinkedEndpoint link) {
        return this.mInternalEndpoints.get(new Endpoint(link.getServiceLink(), link.getEndpointLink()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private RegisteredEndpoint[] getEndpointsForInterface(QName interfaceName, int type, MessageService msgSvc) {
        interfaces = type == 20 ? this.mPendingInternalInterfaces : this.mPendingExternalInterfaces;
        interfaceMap = type == 20 ? this.mIEbyInterface : this.mEEbyInterface;
        block5: while (true) {
            var7_7 = this;
            synchronized (var7_7) {
                ep = interfaces.poll();
            }
            if (ep == null) break;
            interfaceNames = ep.getInterfaces();
            if (interfaceNames == null) {
                try {
                    ep.parseDescriptor(msgSvc.queryDescriptor(ep));
                    interfaceNames = ep.getInterfaces();
                }
                catch (MessagingException msgEx) {
                    this.mLog.warning(msgEx.toString());
                }
            }
            if (interfaceNames == null) continue;
            arr$ = interfaceNames;
            len$ = arr$.length;
            i$ = 0;
            while (true) {
                if (i$ < len$) ** break;
                continue block5;
                i = arr$[i$];
                interfaceMap.put(i, new VectorArray(interfaceMap.get(i), ep));
                ++i$;
            }
            break;
        }
        va = interfaceMap.get(interfaceName);
        return va == null ? new RegisteredEndpoint[]{} : va.mArray;
    }

    private void removeInternalEndpoint(RegisteredEndpoint endpoint) {
        VectorArray va = this.mIEbyService.get(endpoint.getServiceName());
        va.remove(endpoint);
        this.mIEbyService.put(endpoint.getServiceName(), va);
        QName[] interfaceNames = endpoint.getInterfaces();
        if (interfaceNames != null) {
            for (QName i : interfaceNames) {
                va = this.mIEbyInterface.get(i);
                va.remove(endpoint);
                this.mIEbyInterface.put(i, va);
            }
        }
        this.mInternalEndpoints.remove(new Endpoint(endpoint.getServiceName(), endpoint.getEndpointName()));
        this.mPendingInternalInterfaces.remove(endpoint);
    }

    private void removeExternalEndpoint(RegisteredEndpoint endpoint) {
        VectorArray va = this.mEEbyService.get(endpoint.getServiceName());
        va.remove(endpoint);
        this.mEEbyService.put(endpoint.getServiceName(), va);
        QName[] interfaceNames = endpoint.getInterfaces();
        if (interfaceNames != null) {
            for (QName i : interfaceNames) {
                va = this.mEEbyInterface.get(i);
                va.remove(endpoint);
                this.mEEbyInterface.put(i, va);
            }
        }
        this.mExternalEndpoints.remove(new Endpoint(endpoint.getServiceName(), endpoint.getEndpointName()));
        this.mPendingExternalInterfaces.remove(endpoint);
    }

    private void removeLinkedEndpoint(RegisteredEndpoint endpoint) {
        VectorArray va = this.mIEbyService.get(endpoint.getServiceName());
        va.remove(endpoint);
        this.mIEbyService.put(endpoint.getServiceName(), va);
        this.mLinkedEndpoints.remove(new Endpoint(endpoint.getServiceName(), endpoint.getEndpointName()));
    }

    int countEndpoints(int type) {
        int count = 0;
        count = type == 20 ? this.mInternalEndpoints.size() : (type == 30 ? this.mExternalEndpoints.size() : this.mLinkedEndpoints.size());
        return count;
    }

    ServiceEndpoint[] listEndpoints(int type) {
        Collection<RegisteredEndpoint> values = type == 20 ? this.mInternalEndpoints.values() : this.mExternalEndpoints.values();
        ServiceEndpoint[] endpoints = new ServiceEndpoint[values.size()];
        values.toArray(endpoints);
        return endpoints;
    }

    void clear() {
        this.mLinkedEndpoints.clear();
        this.mInternalEndpoints.clear();
        this.mExternalEndpoints.clear();
        this.mInterfaceConnections.clear();
        this.mIEbyService.clear();
        this.mEEbyService.clear();
        this.mIEbyInterface.clear();
        this.mEEbyInterface.clear();
        this.mPendingInternalInterfaces.clear();
        this.mPendingExternalInterfaces.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  EndpointRegistry\n");
        sb.append("    InternalEndpoints Count: ");
        sb.append(this.mInternalEndpoints.size());
        sb.append("\n");
        Iterator<Map.Entry<Object, Object>> i = this.mInternalEndpoints.entrySet().iterator();
        while (i.hasNext()) {
            sb.append(i.next().getValue().toString());
        }
        sb.append("    ExternalEndpoints Count: ");
        sb.append(this.mExternalEndpoints.size());
        sb.append("\n");
        i = this.mExternalEndpoints.entrySet().iterator();
        while (i.hasNext()) {
            sb.append(i.next().getValue().toString());
        }
        sb.append("    LinkedEndpoints Count: ");
        sb.append(this.mLinkedEndpoints.size());
        sb.append("\n");
        i = this.mLinkedEndpoints.entrySet().iterator();
        while (i.hasNext()) {
            sb.append(((LinkedEndpoint)i.next().getValue()).toString());
        }
        sb.append("    InterfaceConnections Count: ");
        sb.append(this.mInterfaceConnections.size());
        sb.append("\n");
        for (Map.Entry<Object, Object> entry : this.mInterfaceConnections.entrySet()) {
            sb.append("      InterfaceName: " + entry.getKey());
            sb.append("\n");
            sb.append(((Endpoint)entry.getValue()).toString());
        }
        return sb.toString();
    }

    private class VectorArray {
        Vector mVector;
        RegisteredEndpoint[] mArray;

        VectorArray(VectorArray va, RegisteredEndpoint o) {
            this.mVector = va == null ? new Vector() : va.mVector;
            if (o instanceof LinkedEndpoint) {
                this.mVector.add(0, o);
            } else {
                this.mVector.add(o);
            }
            this.mArray = new RegisteredEndpoint[this.mVector.size()];
            this.mVector.toArray(this.mArray);
        }

        void remove(Object o) {
            this.mVector.remove(o);
            this.mArray = new RegisteredEndpoint[this.mVector.size()];
            this.mVector.toArray(this.mArray);
        }
    }

    class Endpoint {
        private QName mServiceName;
        private String mEndpointName;

        Endpoint(QName serviceName, String endpointName) {
            this.mServiceName = serviceName;
            this.mEndpointName = endpointName;
        }

        public boolean equals(Object obj) {
            boolean isEqual = false;
            if (obj instanceof Endpoint && ((Endpoint)obj).mServiceName.equals(this.mServiceName) && ((Endpoint)obj).mEndpointName.equals(this.mEndpointName)) {
                isEqual = true;
            }
            return isEqual;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("        ServiceName: " + this.mServiceName);
            sb.append("\n        EndpointName: " + this.mEndpointName);
            sb.append("\n");
            return sb.toString();
        }

        public int hashCode() {
            return this.mServiceName.hashCode() ^ this.mEndpointName.hashCode();
        }
    }
}

