/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.runtime;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceLifecycle;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import com.sun.jbi.ui.runtime.mbeans.JBIAdminCommandsUIMBean;
import com.sun.jbi.ui.runtime.mbeans.UIMBeanFactory;
import javax.jbi.JBIException;
import javax.management.MBeanServer;
import javax.management.StandardMBean;

public class ToolsRuntimeService
implements ServiceLifecycle {
    private EnvironmentContext mEnvContext = null;

    public void initService(EnvironmentContext aContext) throws JBIException {
        this.mEnvContext = aContext;
    }

    public void startService() throws JBIException {
        this.registerJbiAdminUiMBeans();
    }

    public void stopService() throws JBIException {
        this.unregisterJbiAdminUiMBeans();
    }

    private void registerJbiAdminUiMBeans() throws JBIException {
        MBeanServer mbeanServer = null;
        JBIAdminCommandsUIMBean jbiAdminCommandsUIMBeanImpl = null;
        StandardMBean mbean = null;
        try {
            mbeanServer = this.mEnvContext.getMBeanServer();
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            jbiAdminCommandsUIMBeanImpl = this.createJBIAdminCommandsUIMBean(this.mEnvContext);
            mbean = new StandardMBean(jbiAdminCommandsUIMBeanImpl, JBIAdminCommandsUIMBean.class);
            mbeanServer.registerMBean(mbean, JBIJMXObjectNames.getJbiAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            jbiAdminCommandsUIMBeanImpl = this.createReferenceJBIAdminCommandsUIMBean(this.mEnvContext);
            mbean = new StandardMBean(jbiAdminCommandsUIMBeanImpl, JBIAdminCommandsUIMBean.class);
            mbeanServer.registerMBean(mbean, JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void unregisterJbiAdminUiMBeans() throws JBIException {
        MBeanServer mbeanServer = null;
        try {
            mbeanServer = this.mEnvContext.getMBeanServer();
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            mbeanServer.unregisterMBean(JBIJMXObjectNames.getJbiAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        try {
            mbeanServer.unregisterMBean(JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    protected JBIAdminCommandsUIMBean createJBIAdminCommandsUIMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJBIAdminCommandsUIMBean(aContext);
    }

    protected JBIAdminCommandsUIMBean createReferenceJBIAdminCommandsUIMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getReferenceInstance().createJBIAdminCommandsUIMBean(aContext);
    }
}

