/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.util.jmx;

import com.sun.jbi.util.StringTranslator;
import javax.jbi.JBIException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class MBeanUtils {
    private static MBeanServer sMBeanServer;
    private static StringTranslator sTranslator;

    public static void init(MBeanServer server) {
        if (null == server) {
            throw new IllegalArgumentException(sTranslator.getString("NULL_ARGUMENT", "server"));
        }
        sMBeanServer = server;
        sTranslator = new StringTranslator("com.sun.jbi.util", null);
    }

    public static void registerStandardMBean(Class interfaceClass, Object instance, ObjectName mbeanName, boolean replace) throws JBIException {
        if (null == sMBeanServer) {
            return;
        }
        StandardMBean mbean = null;
        try {
            mbean = new StandardMBean(instance, interfaceClass);
        }
        catch (NotCompliantMBeanException ncEx) {
            throw new JBIException(sTranslator.getString("MBEAN_CREATION_NOT_JMX_COMPLIANT", mbeanName, instance.getClass().getName()));
        }
        if (replace && sMBeanServer.isRegistered(mbeanName)) {
            try {
                sMBeanServer.unregisterMBean(mbeanName);
            }
            catch (InstanceNotFoundException infEx) {
            }
            catch (MBeanRegistrationException mbrEx) {
                String msg = mbrEx.getMessage();
                Throwable cause = mbrEx.getCause();
                String causeName = cause.getClass().getName();
                throw new JBIException(sTranslator.getString("MBEAN_UNREGISTRATION_EXCEPTION", mbeanName, causeName, null == msg ? "" : msg), (Throwable)mbrEx);
            }
        }
        try {
            sMBeanServer.registerMBean(mbean, mbeanName);
        }
        catch (InstanceAlreadyExistsException iaeEx) {
            throw new JBIException(sTranslator.getString("MBEAN_ALREADY_REGISTERED", mbeanName));
        }
        catch (MBeanRegistrationException mbrEx) {
            String msg = mbrEx.getMessage();
            Throwable cause = mbrEx.getCause();
            String causeName = cause.getClass().getName();
            throw new JBIException(sTranslator.getString("MBEAN_REGISTRATION_EXCEPTION", mbeanName, causeName, null == msg ? "" : msg), (Throwable)mbrEx);
        }
        catch (NotCompliantMBeanException ncEx) {
            throw new JBIException(sTranslator.getString("MBEAN_REGISTRATION_NOT_JMX_COMPLIANT", mbeanName, instance.getClass().getName()));
        }
    }

    public static void unregisterMBean(ObjectName mbeanName) throws JBIException {
        if (null == sMBeanServer) {
            return;
        }
        try {
            sMBeanServer.unregisterMBean(mbeanName);
        }
        catch (InstanceNotFoundException infEx) {
        }
        catch (MBeanRegistrationException mbrEx) {
            String msg = mbrEx.getMessage();
            Throwable cause = mbrEx.getCause();
            String causeName = cause.getClass().getName();
            throw new JBIException(sTranslator.getString("MBEAN_UNREGISTRATION_EXCEPTION", mbeanName, causeName, null == msg ? "" : msg), (Throwable)mbrEx);
        }
    }
}

