/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.ee.cli.commands.BaseHttpLBCommand;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.Vector;
import javax.management.MBeanServerConnection;

public class ExportLBConfigCommand
extends BaseHttpLBCommand {
    private static final String CONFIG_OPTION = "config";
    private static final String LBNAME_OPTION = "lbname";
    private static final StringManager _strMgr = StringManager.getManager(ExportLBConfigCommand.class);

    protected void handleReturnValue(Object retVal) {
        String exportDirMsg = _strMgr.getString("LBConfigLocation", (Object)((String)retVal));
        CLILogger.getInstance().printMessage(exportDirMsg);
    }

    protected Object[] getParamsInfo() throws CommandException, CommandValidationException {
        String configName = this.getOption(CONFIG_OPTION);
        String lbName = this.getOption(LBNAME_OPTION);
        this.checkConfigAndLBNameOptions(configName, lbName);
        if (lbName != null) {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
            DomainConfig domainConfig = domainRoot.getDomainConfig();
            LoadBalancerConfig loadBalancerConfig = (LoadBalancerConfig)domainConfig.getLoadBalancerConfigMap().get(lbName);
            if (loadBalancerConfig == null) {
                throw new CommandException(_strMgr.getString("LoadBalancerConfigNotDefined", new Object[]{lbName}));
            }
            configName = loadBalancerConfig.getLbConfigName();
            CLILogger.getInstance().printDebugMessage("Config name for " + lbName + " is " + configName);
        }
        Vector oprnds = this.getOperands();
        String fileName = null;
        if (oprnds != null && oprnds.size() >= 1) {
            File file = new File((String)oprnds.get(0));
            fileName = file.getPath();
            if (!file.isAbsolute()) {
                fileName = file.getAbsolutePath();
            }
        }
        CLILogger.getInstance().printDebugMessage("Path = " + fileName);
        return new Object[]{configName, fileName};
    }
}

