// ==============================================================
//	This file is part of Glest (www.glest.org)
//
//	Copyright (C) 2001-2008 Martio Figueroa
//
//	You can redistribute this code and/or modify it under 
//	the terms of the GNU General Public License as published 
//	by the Free Software Foundation; either version 2 of the 
//	License, or (at your option) any later version
// ==============================================================

#include "network_manager.h"

namespace Glest{ namespace Game{

// =====================================================
//	class NetworkManager
// =====================================================

NetworkManager &NetworkManager::getInstance(){
	static NetworkManager networkManager;
	return networkManager;
}

NetworkManager::NetworkManager(){
	networkInterface= NULL;
	networkRole= nrIdle;
}

void NetworkManager::init(NetworkRole networkRole)
{
	assert(networkInterface==NULL);

	this->networkRole = networkRole;

	if(networkRole==nrServer){
		networkInterface = new ServerInterface();
	}
	else
	{
		networkInterface = new ClientInterface();
	}
}

void NetworkManager::end(){
	delete networkInterface;
	networkInterface= NULL;
	networkRole= nrIdle;
}

void NetworkManager::update(){
	if(networkInterface!=NULL){
		networkInterface->update();
	}
}

bool NetworkManager::isNetworkGame(){
	return networkRole==nrClient || getServerInterface()->getConnectedSlotCount()>0;
}

ServerInterface* NetworkManager::getServerInterface(){
	assert(networkRole==nrServer);
	return static_cast<ServerInterface*>(networkInterface);
}

ClientInterface* NetworkManager::getClientInterface(){
	assert(networkRole==nrClient);
	return static_cast<ClientInterface*>(networkInterface);
}

}}//end namespace
