/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Hashtable;

public class DestinationHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Hashtable<String, Object> hashtable;
        Packet packet2;
        block35: {
            block34: {
                int n = 200;
                String string = null;
                packet2 = new Packet(iMQConnection.useDirectBuffers());
                packet2.setConsumerID(packet.getConsumerID());
                hashtable = new Hashtable<String, Object>();
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = packet.getProperties();
                }
                catch (Exception exception) {
                    assert (false);
                    this.logger.logStack(32, "B3100", "Unable to create/destroy destination - no properties", (Throwable)exception);
                    throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Can not handle create/destroy destination"));
                }
                String string2 = (String)hashtable2.get("JMQDestination");
                Integer n2 = (Integer)hashtable2.get("JMQDestType");
                int n3 = n2 == null ? 0 : n2;
                packet2.setPacketType(packet.getPacketType() + 1);
                if (packet.getPacketType() == 34) {
                    if (DEBUG) {
                        this.logger.log(1, "ConsumerHandler: handle() [ Received AddDestination message {0}]", packet.toString());
                    }
                    assert (string2 != null);
                    assert (n2 != null);
                    if (iMQConnection.isAdminConnection()) {
                        n3 |= 0x20A0;
                    }
                    assert (packet2.getPacketType() == 35);
                    try {
                        Destination destination = null;
                        if (DestType.isTemporary(n3)) {
                            boolean bl = iMQConnection.getConnectionUID().getCanReconnect();
                            long l = iMQConnection.getReconnectInterval();
                            destination = Destination.createTempDestination(string2, n3, iMQConnection.getConnectionUID(), bl, l);
                            if (iMQConnection.getConnectionUID().equals(destination.getConnectionUID())) {
                                iMQConnection.attachTempDestination(destination.getDestinationUID());
                            }
                        } else if (!string2.startsWith("MQ_")) {
                            destination = Destination.getDestination(string2, n3, true, !iMQConnection.isAdminConnection());
                        }
                        hashtable.put("JMQDestType", new Integer(n3));
                        hashtable.put("JMQDestUID", string2);
                    }
                    catch (BrokerException brokerException) {
                        n = brokerException.getStatusCode();
                        string = brokerException.getMessage();
                        if (n != 409) {
                            this.logger.log(16, "B2007", (Object)string2, (Throwable)brokerException);
                        } else if (DEBUG) {
                            this.logger.log(4, "B2007", (Object)string2, (Throwable)brokerException);
                        }
                    }
                    catch (IOException iOException) {
                        n = 500;
                        string = iOException.getMessage();
                        this.logger.log(16, "B2007", (Object)string2, (Throwable)iOException);
                    }
                } else {
                    assert (packet.getPacketType() == 36);
                    assert (packet2.getPacketType() == 37);
                    Object var11_15 = null;
                    try {
                        DestinationUID destinationUID = DestinationUID.getUID(string2, DestType.isQueue(n3));
                        if (string2 == null) {
                            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "protocol error,  destination is null"), 404);
                        }
                        assert (Destination.getDestination(destinationUID) != null);
                        Destination.removeDestination(destinationUID, true, Globals.getBrokerResources().getString("B0067", iMQConnection.getConnectionUID()));
                    }
                    catch (BrokerException brokerException) {
                        n = brokerException.getStatusCode();
                        string = brokerException.getMessage();
                        this.logger.log(16, "B2008", (Object)string2, (Throwable)brokerException);
                    }
                    catch (IOException iOException) {
                        n = 500;
                        string = iOException.getMessage();
                        this.logger.log(16, "B2008", (Object)string2, (Throwable)iOException);
                    }
                }
                hashtable.put("JMQStatus", new Integer(n));
                if (string != null) {
                    hashtable.put("JMQReason", string);
                }
                IMQIPConnection cfr_ignored_0 = (IMQIPConnection)iMQConnection;
                if (IMQIPConnection.getDumpPacket()) break block34;
                IMQIPConnection cfr_ignored_1 = (IMQIPConnection)iMQConnection;
                if (!IMQIPConnection.getDumpOutPacket()) break block35;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        return true;
    }
}

