/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist;

import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

public class StoreManager {
    private static final String PERSIST_PROP = "imq.persist.";
    private static final String CLASS_PROP = ".class";
    private static final String STORE_TYPE_PROP = "imq.persist.store";
    private static final String DEFAULT_STORE_TYPE = "file";
    private static final String DEFAULT_FILESTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.file.FileStore";
    private static final String DEFAULT_JDBCSTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore";
    private static Store store = null;

    public static synchronized Store getStore() throws BrokerException {
        Logger logger = Globals.getLogger();
        BrokerResources brokerResources = Globals.getBrokerResources();
        if (store == null) {
            String string;
            if (BrokerStateHandler.shuttingDown) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140");
            }
            BrokerConfig brokerConfig = Globals.getConfig();
            String string2 = brokerConfig.getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
            if (Store.getDEBUG()) {
                logger.log(4, "imq.persist.store=" + string2);
            }
            if ((string = brokerConfig.getProperty(PERSIST_PROP + string2 + CLASS_PROP)) == null || string.equals("")) {
                string = string2.equals(DEFAULT_STORE_TYPE) ? DEFAULT_FILESTORE_CLASS : (string2.equals("jdbc") ? DEFAULT_JDBCSTORE_CLASS : null);
            }
            if (string == null) {
                throw new BrokerException(brokerResources.getString("B3005", string2));
            }
            if (Store.getDEBUG()) {
                logger.log(4, PERSIST_PROP + string2 + CLASS_PROP + "=" + string);
            }
            try {
                store = (Store)Class.forName(string).newInstance();
                if (store.initTxnLogger()) {
                    store.close();
                    store = (Store)Class.forName(string).newInstance();
                }
            }
            catch (Exception exception) {
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                throw new BrokerException(brokerResources.getString("B3006"), exception);
            }
        }
        return store;
    }

    public static synchronized void releaseStore(boolean bl) {
        if (store != null) {
            if (!store.closed()) {
                store.close(bl);
            }
            store = null;
        }
    }

    public static Store getStoreForTonga() throws BrokerException {
        BrokerConfig brokerConfig = Globals.getConfig();
        String string = brokerConfig.getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        if (string.equals("jdbc")) {
            brokerConfig.put("imq.persist.jdbc.lockstore.enabled", "false");
            brokerConfig.put("imq.persist.jdbc.connection.limit", "2");
        }
        return StoreManager.getStore();
    }
}

