/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.ConfigChangeRecord;
import com.sun.messaging.jmq.jmsserver.persist.file.DestinationList;
import com.sun.messaging.jmq.jmsserver.persist.file.InterestStore;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.PropertiesFile;
import com.sun.messaging.jmq.jmsserver.persist.file.TidList;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import com.sun.messaging.jmq.util.timer.MQTimer;
import com.sun.messaging.jmq.util.txnlog.CheckPointListener;
import com.sun.messaging.jmq.util.txnlog.TransactionLogRecord;
import com.sun.messaging.jmq.util.txnlog.TransactionLogWriter;
import com.sun.messaging.jmq.util.txnlog.file.FileTransactionLogWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;

public class FileStore
extends Store
implements CheckPointListener {
    public static final int OLD_STORE_VERSION_200 = 200;
    public static final int OLD_STORE_VERSION = 350;
    public static final int STORE_VERSION = 370;
    static final String FILE_PROP_PREFIX = "imq.persist.file.";
    static final String SYNC_ENABLED_PROP = "imq.persist.file.sync.enabled";
    static final String SYNC_ALL_PROP = "imq.persist.file.sync.all";
    static final boolean DEFAULT_SYNC_ENABLED = false;
    static final boolean DEFAULT_SYNC_ALL = false;
    static final String TXNLOG_FILE_SIZE_PROP = "imq.persist.file.txnLog.file.size";
    static final long DEFAULT_TXNLOG_FILE_SIZE = 10240L;
    static final String FILESTORE_BASENAME = "fs";
    static final String FILESTORE_TOP = "fs370";
    static final String FILESTORE350_TOP = "fs350";
    static final String FILESTORE200_TOP = "filestore";
    static final String VERSIONFILE = "version";
    static final boolean syncEnabled = config.getBooleanProperty("imq.persist.file.sync.enabled", false);
    static final boolean syncAll = config.getBooleanProperty("imq.persist.file.sync.all", false);
    private File rootDir = null;
    private MsgStore msgStore = null;
    private InterestStore intStore = null;
    private DestinationList dstList = null;
    private TidList tidList = null;
    private ConfigChangeRecord configStore = null;
    private PropertiesFile propFile = null;
    static final String MSG_LOG_FILENAME = "txnlogmsg";
    static final String ACK_LOG_FILENAME = "txnlogack";
    boolean txnLoggerInited = false;
    private TransactionLogWriter msgLogWriter = null;
    private TransactionLogWriter ackLogWriter = null;
    private static final ConsumerUID[] emptyiid = new ConsumerUID[0];
    private static final int[] emptystate = new int[0];
    private static FilenameFilter storeFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return new File(file, string).isDirectory() && string.startsWith(FileStore.FILESTORE_BASENAME);
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileStore() throws BrokerException {
        String string = Globals.JMQ_INSTANCES_HOME + File.separator + Globals.getConfigName() + File.separator;
        logger.logToAll(8, br.getString("B1141", string));
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.sync.enabled=" + syncEnabled);
        }
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.sync.all=" + syncAll);
        }
        String string2 = Globals.JMQ_INSTANCES_HOME + File.separator + Globals.getConfigName() + File.separator;
        File file = new File(string2);
        int n = this.checkFileStore(file);
        this.rootDir = new File(file, FILESTORE_TOP);
        if (this.removeStore) {
            try {
                FileUtil.removeFiles(this.rootDir, true);
                return;
            }
            catch (IOException iOException) {
                logger.log(32, "B3120", (Object)this.rootDir, (Throwable)iOException);
                throw new BrokerException(br.getString("B3120", this.rootDir), iOException);
            }
        }
        if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
            logger.log(32, "B3017", this.rootDir);
            throw new BrokerException(br.getString("B3017", this.rootDir));
        }
        if (n > 0) {
            File file2 = null;
            try {
                Object[] objectArray = new Object[]{new Integer(370), FILESTORE_TOP};
                logger.logToAll(8, "B1105", objectArray);
                if (this.resetMessage) {
                    logger.logToAll(8, "B1101");
                    logger.logToAll(8, "B1102");
                } else if (this.resetInterest) {
                    logger.logToAll(8, "B1103");
                    logger.logToAll(8, "B1102");
                }
                if (n == 350) {
                    file2 = new File(file, FILESTORE350_TOP);
                    try {
                        FileUtil.copyDirectory(file2, this.rootDir);
                        FileUtil.removeFiles(new File(this.rootDir, "txn"), false);
                        FileUtil.removeFiles(new File(this.rootDir, "txnack"), false);
                    }
                    catch (IOException iOException) {
                        String string3 = "Failed to copy old persistent data under " + file2 + " to " + this.rootDir;
                        logger.log(32, string3, iOException);
                        throw new BrokerException(string3, iOException);
                    }
                    this.dstList = new DestinationList(this, this.rootDir, false);
                    this.msgStore = new MsgStore(this, this.rootDir, this.resetMessage);
                    this.intStore = new InterestStore(this.rootDir, this.resetInterest);
                    this.tidList = new TidList(this, this.rootDir, file2);
                    this.configStore = new ConfigChangeRecord(this.rootDir, false);
                    this.propFile = new PropertiesFile(this.rootDir, false);
                } else {
                    file2 = new File(file, FILESTORE200_TOP);
                    this.dstList = new DestinationList(this, this.rootDir, file2);
                    this.msgStore = new MsgStore(this, this.rootDir, file2, this.resetMessage);
                    this.intStore = new InterestStore(this, this.rootDir, file2, this.resetInterest);
                    this.tidList = new TidList(this.rootDir, true);
                    this.propFile = new PropertiesFile(this, this.rootDir, file2);
                    this.configStore = new ConfigChangeRecord(this, this.rootDir, file2);
                }
                if (Store.getDEBUG()) {
                    logger.log(4, "FileStore upgraded successfully.");
                }
                if (this.upgradeNoBackup) {
                    try {
                        FileUtil.removeFiles(file2, true);
                    }
                    catch (IOException iOException) {
                        logger.log(32, "B3120", (Object)file2, (Throwable)iOException);
                    }
                }
                logger.logToAll(8, "B1106");
                if (this.upgradeNoBackup) return;
                logger.logToAll(8, "B1099", file2);
                return;
            }
            catch (BrokerException brokerException) {
                logger.log(8, "B1110", this.rootDir);
                try {
                    FileUtil.removeFiles(this.rootDir, true);
                    throw brokerException;
                }
                catch (IOException iOException) {
                    logger.log(32, "B3120", (Object)this.rootDir, (Throwable)brokerException);
                }
                throw brokerException;
            }
        }
        this.dstList = new DestinationList(this, this.rootDir, this.resetStore);
        this.msgStore = new MsgStore(this, this.rootDir, this.resetStore || this.resetMessage);
        this.intStore = new InterestStore(this.rootDir, this.resetStore || this.resetInterest);
        this.tidList = new TidList(this.rootDir, this.resetStore);
        this.configStore = new ConfigChangeRecord(this.rootDir, this.resetStore);
        this.propFile = new PropertiesFile(this.rootDir, this.resetStore);
        if (!Store.getDEBUG()) return;
        logger.log(4, "FileStore instantiated successfully.");
    }

    public FileStore(String string, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.sync.enabled=" + syncEnabled);
        }
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.sync.all=" + syncAll);
        }
        logger.log(8, br.getString("B1141", string));
        this.rootDir = new File(string, FILESTORE_TOP);
        if (bl) {
            try {
                FileUtil.removeFiles(this.rootDir, false);
                return;
            }
            catch (IOException iOException) {
                logger.log(32, "B3120", (Object)this.rootDir, (Throwable)iOException);
                throw new BrokerException(br.getString("B3120", this.rootDir), iOException);
            }
        }
        if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
            logger.log(32, "B3017", this.rootDir.toString());
            throw new BrokerException(br.getString("B3017", this.rootDir.toString()));
        }
        this.dstList = new DestinationList(this, this.rootDir, false);
        this.msgStore = new MsgStore(this, this.rootDir, false);
        this.intStore = new InterestStore(this.rootDir, false);
        this.tidList = new TidList(this.rootDir, false);
        this.configStore = new ConfigChangeRecord(this.rootDir, false);
        this.propFile = new PropertiesFile(this.rootDir, false);
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore instantiated successfully.");
        }
    }

    public LoadException getLoadDestinationException() {
        return this.dstList.getLoadException();
    }

    public LoadException getLoadConsumerException() {
        return this.intStore.getLoadException();
    }

    public LoadException getLoadPropertyException() {
        return this.propFile.getLoadException();
    }

    public LoadException getLoadTransactionException() {
        return this.tidList.getLoadException();
    }

    public LoadException getLoadTransactionAckException() {
        return this.tidList.getLoadTransactionAckException();
    }

    public void close(boolean bl) {
        super.setClosedAndWait();
        this.dstList.close(bl);
        this.tidList.close(bl);
        this.configStore.close(bl);
        this.propFile.close(bl);
        this.intStore.close(bl);
        this.msgStore.close(bl);
        try {
            if (this.msgLogWriter != null) {
                this.msgLogWriter.close();
            }
            if (this.ackLogWriter != null) {
                this.ackLogWriter.close();
            }
        }
        catch (IOException iOException) {
            logger.logStack(32, "B3100", "Got IOException while closing transaction log file", (Throwable)iOException);
        }
        if (config.getBooleanProperty("imq.persist.file.transaction.memorymappedfile.enabled", true)) {
            for (int i = 0; i < 3; ++i) {
                Broker.runGC();
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.close(" + bl + ") done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll(boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.clearAll() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.clearAll(bl);
            this.intStore.clearAll(bl);
            this.dstList.clearAll(bl, false);
            this.tidList.clearAll(bl);
            this.configStore.clearAll(bl);
            this.propFile.clearAll(bl);
            try {
                if (this.msgLogWriter != null) {
                    this.msgLogWriter.reset();
                }
                if (this.ackLogWriter != null) {
                    this.ackLogWriter.reset();
                }
            }
            catch (IOException iOException) {
                logger.log(32, "B3100", (Object)"Got IOException while resetting transaction log file", (Throwable)iOException);
            }
            if (Store.getDEBUG()) {
                logger.log(4, "File store cleared");
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeMessage() called for " + packet.getSysMessageID());
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destinationUID == null || packet == null || consumerUIDArray == null || nArray == null) {
                throw new NullPointerException();
            }
            if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
                throw new BrokerException(br.getString("B3085"));
            }
            this.msgStore.storeMessage(destinationUID, packet, consumerUIDArray, nArray, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    public final int getStoreVersion() {
        return 370;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMessage(DestinationUID destinationUID, Packet packet, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeMessage() called for " + packet.getSysMessageID());
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.storeMessage(destinationUID, packet, emptyiid, emptystate, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(DestinationUID destinationUID, SysMessageID sysMessageID, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeMessage() called for " + destinationUID + ";" + sysMessageID);
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.removeMessage(destinationUID, sysMessageID, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveMessage(Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.moveMessage() called for: " + packet.getSysMessageID() + " from " + destinationUID + " to " + destinationUID2);
        }
        if (packet == null || destinationUID == null || destinationUID2 == null) {
            throw new NullPointerException();
        }
        if (consumerUIDArray == null) {
            consumerUIDArray = emptyiid;
            nArray = emptystate;
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.moveMessage(packet, destinationUID, destinationUID2, consumerUIDArray, nArray, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMessages(Destination destination, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeAllMessages(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.removeAllMessages(destination.getDestinationUID(), bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration messageEnumeration(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.messageEnumeration(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Enumeration enumeration = this.msgStore.messageEnumeration(destination.getDestinationUID());
            return enumeration;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public Packet getMessage(DestinationUID destinationUID, String string) throws BrokerException {
        return this.getMessage(destinationUID, SysMessageID.get(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet getMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getMessage() called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            Packet packet = this.msgStore.getMessage(destinationUID, sysMessageID);
            return packet;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeInterestStates() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (sysMessageID == null || consumerUIDArray == null || nArray == null) {
                throw new NullPointerException();
            }
            if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
                throw new BrokerException(br.getString("B3085"));
            }
            this.msgStore.storeInterestStates(destinationUID, sysMessageID, consumerUIDArray, nArray, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateInterestState() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (sysMessageID == null || consumerUID == null) {
                throw new NullPointerException();
            }
            this.msgStore.updateInterestState(destinationUID, sysMessageID, consumerUID, n, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getInterestState() called");
        }
        if (sysMessageID == null || consumerUID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            int n = this.msgStore.getInterestState(destinationUID, sysMessageID, consumerUID);
            return n;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getInterestStates() called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.msgStore.getInterestStates(destinationUID, sysMessageID);
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerUID[] getConsumerUIDs(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getConsumerUIDs() called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            ConsumerUID[] consumerUIDArray = this.msgStore.getConsumerUIDs(destinationUID, sysMessageID);
            return consumerUIDArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessageBeenAcked(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.hasMessageBeenAcked() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            boolean bl = this.msgStore.hasMessageBeenAcked(destinationUID, sysMessageID);
            return bl;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeInterest() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.intStore.storeInterest(consumer, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeInterest() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.intStore.removeInterest(consumer, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer[] getAllInterests() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getAllInterests() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Consumer[] consumerArray = this.intStore.getAllInterests();
            return consumerArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstList.storeDestination(destination, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDestination(Destination destination, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstList.updateDestination(destination, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstList.removeDestination(destination, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getDestination(DestinationUID destinationUID) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destinationUID == null) {
                throw new NullPointerException();
            }
            Destination destination = this.dstList.getDestination(destinationUID);
            return destination;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination[] getAllDestinations() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getAllDestinations() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Destination[] destinationArray = this.dstList.getAllDestinations();
            return destinationArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTransaction(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null || transactionState == null) {
                throw new NullPointerException();
            }
            this.tidList.storeTransaction(transactionUID, transactionState, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void removeTransaction(TransactionUID transactionUID, boolean bl) throws IOException, BrokerException {
        this.removeTransaction(transactionUID, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransaction(TransactionUID transactionUID, boolean bl, boolean bl2) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            if (bl) {
                this.tidList.removeTransactionAck(transactionUID, bl2);
            }
            this.tidList.removeTransaction(transactionUID, bl2);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransactionState(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateTransactionState( id=" + transactionUID + ", ts=" + transactionState.getState() + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            this.tidList.updateTransactionState(transactionUID, transactionState.getState(), bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAllTransactionStates() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getAllTransactionStates() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.tidList.getAllTransactionStates();
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeTransactionAck() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null || transactionAcknowledgement == null) {
                throw new NullPointerException();
            }
            this.tidList.storeTransactionAck(transactionUID, transactionAcknowledgement, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeTransactionAck() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            this.tidList.removeTransactionAck(transactionUID, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getTransactionAcks() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            TransactionAcknowledgement[] transactionAcknowledgementArray = this.tidList.getTransactionAcks(transactionUID);
            return transactionAcknowledgementArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAllTransactionAcks() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getAllTransactionAcks() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.tidList.getAllTransactionAcks();
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTransaction(TransactionUID transactionUID, TransactionInfo transactionInfo, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.tidList.storeTransaction(transactionUID, transactionInfo, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeClusterTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeClusterTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.tidList.storeClusterTransaction(transactionUID, transactionState, transactionBrokerArray, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterTransaction(TransactionUID transactionUID, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateClusterTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.tidList.updateClusterTransaction(transactionUID, transactionBrokerArray, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionBroker[] getClusterTransactionBrokers(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateClusterTransactionBrokerState() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            TransactionBroker[] transactionBrokerArray = this.tidList.getClusterTransactionBrokers(transactionUID);
            return transactionBrokerArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterTransactionBrokerState(TransactionUID transactionUID, int n, TransactionBroker transactionBroker, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateClusterTransactionBrokerState() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.tidList.updateTransactionBrokerState(transactionUID, n, transactionBroker, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRemoteTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeRemoteTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.tidList.storeRemoteTransaction(transactionUID, transactionState, transactionAcknowledgementArray, brokerAddress, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerAddress getRemoteTransactionHomeBroker(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getRemoteTransactionHomeBroker() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            BrokerAddress brokerAddress = this.tidList.getRemoteTransactionHomeBroker(transactionUID);
            return brokerAddress;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAllRemoteTransactionStates() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getAllRemoteTransactionStates() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.tidList.getAllRemoteTransactionStates();
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionState getTransactionState(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getTransactionState() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            TransactionState transactionState = this.tidList.getTransactionState(transactionUID);
            return transactionState;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionInfo getTransactionInfo(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getTransactionInfo() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            TransactionInfo transactionInfo = this.tidList.getTransactionInfo(transactionUID);
            return transactionInfo;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTransactions(String string) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getTransactions() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Collection collection = this.tidList.getAllTransactions();
            return collection;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(String string, Object object, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateProperty() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (string == null) {
                throw new NullPointerException();
            }
            this.propFile.updateProperty(string, object, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getProperty() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (string == null) {
                throw new NullPointerException();
            }
            Object object = this.propFile.getProperty(string);
            return object;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPropertyNames() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getPropertyNames() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            String[] stringArray = this.propFile.getPropertyNames();
            return stringArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getAllProperties() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getAllProperties() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Properties properties = this.propFile.getProperties();
            return properties;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeConfigChangeRecord(long l, byte[] byArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeConfigChangeRecord() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (l <= 0L) {
                logger.log(32, "B3074", new Long(l));
                throw new BrokerException(br.getString("B3074", new Long(l)));
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            this.configStore.storeConfigChangeRecord(l, byArray, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getConfigChangeRecordsSince(long l) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getConfigChangeRecordsSince() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            ArrayList arrayList = this.configStore.getConfigChangeRecordsSince(l);
            return arrayList;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAllConfigRecords() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getAllConfigRecords() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Object[] objectArray = this.configStore.getAllConfigRecords();
            return objectArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllConfigChangeRecords(boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.clearAllConfigChangeRecords() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.configStore.clearAll(bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getMessageStorageInfo(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getMessageStorageInfo(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            DestinationUID destinationUID = destination.getDestinationUID();
            HashMap<String, Number> hashMap = new HashMap<String, Number>(2);
            hashMap.put("numMsgs", new Integer(this.msgStore.getMessageCount(destinationUID)));
            hashMap.put("totalMsgBytes", new Long(this.msgStore.getByteCount(destinationUID)));
            HashMap<String, Number> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public String getStoreType() {
        return "file";
    }

    public boolean isJDBCStore() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getStorageInfo(" + destination + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.msgStore.getStorageInfo(destination);
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("File-based store", this.rootDir.getPath());
        hashtable.put("Store version", String.valueOf(370));
        hashtable.putAll(this.dstList.getDebugState());
        hashtable.putAll(this.msgStore.getDebugState());
        hashtable.putAll(this.intStore.getDebugState());
        hashtable.putAll(this.tidList.getDebugState());
        hashtable.putAll(this.propFile.getDebugState());
        hashtable.putAll(this.configStore.getDebugState());
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactDestination(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.compactDestination(" + destination + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.compactDestination(destination);
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void syncDestination(Destination destination) throws BrokerException {
        if (destination == null) {
            try {
                Destination[] destinationArray = this.dstList.getAllDestinations();
                int n = destinationArray.length;
                for (int i = 0; i < n; ++i) {
                    this.msgStore.sync(destinationArray[i].getDestinationUID());
                }
            }
            catch (IOException iOException) {
                logger.logStack(32, "B3100", "Failed to synchronize message stores", (Throwable)iOException);
                throw new BrokerException("B4031", iOException);
            }
        } else {
            this.msgStore.sync(destination.getDestinationUID());
        }
    }

    public void syncTransaction(TransactionUID transactionUID) throws BrokerException {
        this.tidList.sync(transactionUID);
        this.tidList.syncTransactionAck(transactionUID);
    }

    public void logTxn(int n, byte[] byArray) throws IOException {
        if (!this.txnLoggerInited) {
            return;
        }
        if (n == 1) {
            TransactionLogRecord transactionLogRecord = this.msgLogWriter.newTransactionLogRecord();
            transactionLogRecord.setType(n);
            transactionLogRecord.setBody(byArray);
            this.msgLogWriter.write(transactionLogRecord);
        } else {
            TransactionLogRecord transactionLogRecord = this.ackLogWriter.newTransactionLogRecord();
            transactionLogRecord.setType(n);
            transactionLogRecord.setBody(byArray);
            this.ackLogWriter.write(transactionLogRecord);
        }
    }

    MsgStore getMsgStore() {
        return this.msgStore;
    }

    DestinationList getDstStore() {
        return this.dstList;
    }

    private int checkFileStore(File file) throws BrokerException {
        String[] stringArray;
        int n = 0;
        if (Store.getDEBUG()) {
            logger.log(4, "topDir=" + file);
        }
        if ((stringArray = file.list(storeFilter)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(FILESTORE_TOP) || stringArray[i].equals(FILESTORE350_TOP)) continue;
                File file2 = new File(file, stringArray[i]);
                logger.log(32, "B3129", file2);
                throw new BrokerException(br.getString("B3129", file2));
            }
        }
        File file3 = new File(file, FILESTORE_TOP);
        File file4 = new File(file, FILESTORE350_TOP);
        File file5 = new File(file, FILESTORE200_TOP);
        boolean bl = file5.exists();
        boolean bl2 = file4.exists();
        int n2 = 200;
        File file6 = file5;
        if (bl2) {
            n2 = 350;
            file6 = file4;
        } else if (bl) {
            this.checkOldVersion(new File(file6, VERSIONFILE), n2);
        }
        if (file3.exists()) {
            if (!this.removeStore) {
                if (bl2) {
                    logger.logToAll(8, "B1107", file6);
                } else if (bl) {
                    logger.logToAll(8, "B1107", file6);
                }
            }
        } else if (bl || bl2) {
            if (this.removeStore) {
                logger.logToAll(8, "B1104", file6);
            } else if (this.resetStore) {
                logger.logToAll(8, "B1100", file6);
                logger.logToAll(8, "B1114");
                try {
                    FileUtil.removeFiles(file6, true);
                }
                catch (IOException iOException) {
                    logger.log(32, "B3117", (Object)file6, (Throwable)iOException);
                    throw new BrokerException(br.getString("B3117", file6), iOException);
                }
            } else {
                logger.logToAll(8, "B1109", new Integer(n2));
                if (this.upgradeNoBackup && !Broker.getBroker().force) {
                    this.getConfirmation();
                }
                n = n2;
            }
        }
        return n;
    }

    private void checkOldVersion(File file, int n) throws BrokerException {
        if (!file.exists()) {
            logger.log(32, "B3126", file);
            throw new BrokerException(br.getString("B3126", file));
        }
        RandomAccessFile randomAccessFile = null;
        int n2 = 0;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            String string = randomAccessFile.readLine();
            randomAccessFile.close();
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(32, "B3125", string, Integer.toString(n), numberFormatException);
                throw new BrokerException(br.getString("B3125", string, Integer.toString(n)), numberFormatException);
            }
            if (n2 != n) {
                logger.log(32, "B3125", (Object)string, Integer.toString(n));
                throw new BrokerException(br.getString("B3125", string, Integer.toString(n)));
            }
        }
        catch (IOException iOException) {
            logger.log(32, "B4114", iOException);
            throw new BrokerException(br.getString("B4114"), iOException);
        }
    }

    public boolean initTxnLogger() throws BrokerException {
        Object object;
        boolean bl = false;
        if (this.removeStore || !Globals.txnLogEnabled()) {
            return bl;
        }
        logger.log(8, "B1269");
        String string = null;
        try {
            object = config.getSizeProperty(TXNLOG_FILE_SIZE_PROP, 10240L);
            string = MSG_LOG_FILENAME;
            this.msgLogWriter = new FileTransactionLogWriter(this.rootDir, string, ((SizeString)object).getBytes());
            this.msgLogWriter.setCheckPointListener(this);
            string = ACK_LOG_FILENAME;
            this.ackLogWriter = new FileTransactionLogWriter(this.rootDir, string, ((SizeString)object).getBytes());
            this.ackLogWriter.setCheckPointListener(this);
            if (this.resetMessage || this.resetStore) {
                this.msgLogWriter.reset();
                this.ackLogWriter.reset();
                this.txnLoggerInited = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            logger.logStack(32, "B3225", string, (Throwable)iOException);
            throw new BrokerException(br.getString("B3225", string), iOException);
        }
        try {
            TransactionUID transactionUID;
            int n;
            String string2;
            long l;
            DataInputStream dataInputStream;
            ByteArrayInputStream byteArrayInputStream;
            byte[] byArray;
            int n2;
            Object object22;
            int n3;
            HashSet hashSet = new HashSet();
            if (this.msgLogWriter.playBackRequired()) {
                bl = true;
                logger.log(64, "B1270");
                Destination.init();
                Subscription.initSubscriptions();
                n3 = 0;
                object22 = this.msgLogWriter.iterator();
                while (object22.hasNext()) {
                    ++n3;
                    object = (TransactionLogRecord)object22.next();
                    n2 = object.getType();
                    if (n2 != 1) {
                        logger.log(32, "B3226", (Object)String.valueOf(object.getSequence()), "record type " + n2 + " is invalid");
                        continue;
                    }
                    byArray = object.getBody();
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    dataInputStream = new DataInputStream(byteArrayInputStream);
                    l = dataInputStream.readLong();
                    string2 = String.valueOf(l);
                    logger.log(64, "B1272", (Object)string2, String.valueOf(n2));
                    this.processTxnRecMsgPart(dataInputStream, hashSet);
                    if (l > 0L && (n = this.tidList.getTransactionStateValue(transactionUID = new TransactionUID(l))) != -1 && n != 6) {
                        logger.log(64, "B1273", string2);
                        this.tidList.updateTransactionState(transactionUID, 6, false);
                    }
                    dataInputStream.close();
                    byteArrayInputStream.close();
                }
                logger.log(64, "B1274", String.valueOf(n3));
                logger.flush();
            }
            if (this.ackLogWriter.playBackRequired()) {
                bl = true;
                logger.log(64, "B1271");
                Destination.init();
                Subscription.initSubscriptions();
                n3 = 0;
                object22 = this.ackLogWriter.iterator();
                while (object22.hasNext()) {
                    ++n3;
                    object = (TransactionLogRecord)object22.next();
                    n2 = object.getType();
                    if (n2 != 2 && n2 != 4) {
                        logger.log(32, "B3226", (Object)String.valueOf(object.getSequence()), "record type " + n2 + " is invalid");
                        continue;
                    }
                    byArray = object.getBody();
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    dataInputStream = new DataInputStream(byteArrayInputStream);
                    l = dataInputStream.readLong();
                    string2 = String.valueOf(l);
                    logger.log(64, "B1272", (Object)string2, String.valueOf(n2));
                    if (n2 == 4) {
                        this.processTxnRecMsgPart(dataInputStream, hashSet);
                    }
                    this.processTxnRecAckPart(dataInputStream, hashSet);
                    transactionUID = new TransactionUID(l);
                    n = this.tidList.getTransactionStateValue(transactionUID);
                    if (n != -1 && n != 6) {
                        logger.log(64, "B1273", string2);
                        this.tidList.updateTransactionState(transactionUID, 6, false);
                    }
                    dataInputStream.close();
                    byteArrayInputStream.close();
                }
                logger.log(64, "B1275", String.valueOf(n3));
                logger.flush();
            }
            if (bl) {
                for (Object object22 : hashSet) {
                    ((Destination)object22).sync();
                    ((Destination)object22).unload(true);
                }
                hashSet = null;
                this.tidList.sync(null);
                this.tidList.syncTransactionAck(null);
                this.msgLogWriter.reset();
                this.ackLogWriter.reset();
                logger.log(64, "B1280");
                logger.flush();
            }
        }
        catch (Throwable throwable) {
            logger.logStack(32, "B3228", throwable);
            throw new BrokerException(br.getString("B3228"), throwable);
        }
        this.txnLoggerInited = true;
        return bl;
    }

    public final void checkpoint() {
        MQTimer mQTimer = Globals.getTimer();
        mQTimer.schedule((TimerTask)new StoreSyncTask(), 1000L);
    }

    private void processTxnRecMsgPart(DataInputStream dataInputStream, Set set) throws IOException, BrokerException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            MsgStore msgStore;
            Packet packet = new Packet(false);
            packet.generateTimestamp(false);
            packet.generateSequenceNumber(false);
            packet.readPacket(dataInputStream);
            SysMessageID sysMessageID = packet.getSysMessageID();
            Destination destination = Destination.getDestination(packet.getDestination(), packet.getIsQueue() ? 1 : 2, true, true);
            DestinationUID destinationUID = destination.getDestinationUID();
            if (!set.contains(destination)) {
                destination.load();
                set.add(destination);
            }
            if ((msgStore = this.getMsgStore()).containsMessage(destinationUID, sysMessageID)) {
                logger.log(64, "B1276", sysMessageID);
                msgStore.removeMessage(destinationUID, sysMessageID, false);
            } else {
                logger.log(64, "B1277", sysMessageID);
            }
            PacketReference packetReference = PacketReference.createReference(packet, destinationUID, null);
            try {
                destination.routeNewMessage(packetReference);
                continue;
            }
            catch (SelectorFormatException selectorFormatException) {
                throw new BrokerException(br.getString("B3227", sysMessageID), selectorFormatException);
            }
        }
    }

    private void processTxnRecAckPart(DataInputStream dataInputStream, Set set) throws IOException, BrokerException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            DestinationUID destinationUID = new DestinationUID(string);
            SysMessageID sysMessageID = new SysMessageID();
            sysMessageID.readID(dataInputStream);
            ConsumerUID consumerUID = new ConsumerUID(dataInputStream.readLong());
            Destination destination = Destination.getDestination(destinationUID.getName(), destinationUID.isQueue() ? 1 : 2, true, true);
            if (!set.contains(destination)) {
                destination.load();
                set.add(destination);
            }
            if (this.msgStore.containsMessage(destinationUID, sysMessageID)) {
                logger.log(64, "B1278", (Object)consumerUID, sysMessageID);
                if (destination.isQueue() && consumerUID.longValue() != 0L) {
                    this.msgStore.updateInterestState(destinationUID, sysMessageID, PacketReference.getQueueUID(), 2, false);
                    continue;
                }
                this.msgStore.updateInterestState(destinationUID, sysMessageID, consumerUID, 2, false);
                continue;
            }
            logger.log(64, "B1279", (Object)consumerUID, sysMessageID);
        }
    }

    private class StoreSyncTask
    extends TimerTask {
        private StoreSyncTask() {
        }

        public void run() {
            try {
                TransactionLogWriter[] transactionLogWriterArray = new TransactionLogWriter[]{FileStore.this.msgLogWriter, FileStore.this.ackLogWriter};
                FileStore.this.syncStore(transactionLogWriterArray);
            }
            catch (Throwable throwable) {
                Store.logger.logStack(32, "B3100", "Failed to synchronize persistence store for transaction log checkpoint", throwable);
            }
        }
    }
}

