/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FilePool;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

abstract class RandomAccessStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    public static final String FREE_FILE = "FREE";
    public static final String GOOD = "GOOD";
    public static final String WRITING = "....";
    static final int LONG_LEN = 8;
    static final int INT_LEN = 4;
    private static final int PUT = 0;
    private static final int REMOVE = 1;
    private static final int GET = 2;
    private RAFilePool raFilePool = null;
    private FilePool filePool = null;
    public static final int LOWEST_FILE_NUM = 0;
    public int high = 1;
    public int low = 1;
    protected File directory = null;
    protected HashMap idToRAFile = new HashMap();
    protected HashMap idToFile = new HashMap();
    private boolean scanned = false;
    private HashSet dataFiles = new HashSet();

    RandomAccessStore(File file, int n, int n2, int n3) throws BrokerException {
        this.raFilePool = new RAFilePool(this, n);
        int n4 = n3 * n2 / 100;
        int n5 = n2 - n4;
        this.filePool = new FilePool(this, n5, n4);
        this.directory = file;
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            this.logger.log(32, "B3017", this.directory.toString());
            throw new BrokerException(this.br.getString("B3017", this.directory.toString()));
        }
    }

    abstract Object parseData(byte[] var1, byte[] var2) throws IOException;

    abstract FilenameFilter getFilenameFilter();

    protected void printFileInfo(PrintStream printStream) {
        this.raFilePool.printFileInfo(printStream);
        this.filePool.printFileInfo(printStream);
    }

    protected void close(boolean bl) {
        this.printStatistics("At close():");
        FileInfo[] fileInfoArray = this.idToRAFile.values().toArray(new FileInfo[this.idToRAFile.size()]);
        this.closeFiles(fileInfoArray, bl);
        if (bl) {
            fileInfoArray = this.idToFile.values().toArray(new FileInfo[this.idToFile.size()]);
            this.truncateFiles(fileInfoArray);
        }
        this.raFilePool.close(bl);
        this.filePool.close(bl);
    }

    void printStatistics(String string) {
        if (Store.getDEBUG()) {
            this.logger.log(4, "class=" + this);
            this.logger.log(4, string);
            this.logger.log(4, "high = " + this.high);
            this.logger.log(4, "low = " + this.low);
            this.logger.log(4, "idToRAFile.size = " + this.idToRAFile.size());
            this.logger.log(4, "idToFile.size = " + this.idToFile.size());
            this.raFilePool.printStatistics();
            this.filePool.printStatistics();
        }
    }

    boolean writeAttachment(Object object, byte[] byArray, boolean bl) throws IOException {
        boolean bl2 = true;
        boolean bl3 = false;
        RandomAccessFile randomAccessFile = null;
        FileInfo fileInfo = (FileInfo)this.idToRAFileOp(2, object, null);
        if (fileInfo != null) {
            randomAccessFile = (RandomAccessFile)fileInfo.file;
        } else {
            fileInfo = (FileInfo)this.idToFileOp(2, object, null);
            if (fileInfo != null) {
                randomAccessFile = new RandomAccessFile((File)fileInfo.file, "rw");
                bl3 = true;
            } else {
                bl2 = false;
            }
        }
        if (bl2) {
            this.writeAttachment(randomAccessFile, fileInfo.endofdata, byArray, bl);
            fileInfo.endoffile = fileInfo.endofdata + 8L + (long)byArray.length;
            if (bl3) {
                randomAccessFile.close();
            }
        }
        return bl2;
    }

    boolean writeAttachmentData(Object object, long l, int n, boolean bl) throws IOException {
        boolean bl2 = true;
        boolean bl3 = false;
        RandomAccessFile randomAccessFile = null;
        FileInfo fileInfo = (FileInfo)this.idToRAFileOp(2, object, null);
        if (fileInfo != null) {
            randomAccessFile = (RandomAccessFile)fileInfo.file;
        } else {
            fileInfo = (FileInfo)this.idToFileOp(2, object, null);
            if (fileInfo != null) {
                randomAccessFile = new RandomAccessFile((File)fileInfo.file, "rw");
                bl3 = true;
            } else {
                bl2 = false;
            }
        }
        if (bl2) {
            long l2 = fileInfo.endofdata + 8L + l;
            this.writeAttachmentData(randomAccessFile, l2, n, bl);
            if (bl3) {
                randomAccessFile.close();
            }
        }
        return bl2;
    }

    private void writeAttachment(RandomAccessFile randomAccessFile, long l, byte[] byArray, boolean bl) throws IOException {
        RandomAccessStore.markWriting(randomAccessFile);
        randomAccessFile.seek(l);
        randomAccessFile.writeLong(byArray.length);
        randomAccessFile.write(byArray);
        RandomAccessStore.markGood(randomAccessFile);
        if (bl) {
            randomAccessFile.getChannel().force(false);
        }
    }

    private void writeAttachmentData(RandomAccessFile randomAccessFile, long l, int n, boolean bl) throws IOException {
        randomAccessFile.seek(l);
        randomAccessFile.writeInt(n);
        if (bl) {
            randomAccessFile.getChannel().force(false);
        }
    }

    byte[] loadData(Object object) throws IOException {
        FileInfo fileInfo = (FileInfo)this.idToRAFileOp(2, object, null);
        byte[] byArray = null;
        if (fileInfo != null) {
            byArray = this.loadDataFromFile((RandomAccessFile)fileInfo.file);
        } else {
            fileInfo = (FileInfo)this.idToFileOp(2, object, null);
            if (fileInfo != null) {
                RandomAccessFile randomAccessFile = new RandomAccessFile((File)fileInfo.file, "r");
                byArray = this.loadDataFromFile(randomAccessFile);
                randomAccessFile.close();
            }
        }
        return byArray;
    }

    boolean removeData(Object object, boolean bl) throws IOException {
        boolean bl2 = true;
        FileInfo fileInfo = (FileInfo)this.idToRAFileOp(1, object, null);
        if (fileInfo != null) {
            this.raFilePool.putRAFile((RandomAccessFile)fileInfo.file, bl);
            return bl2;
        }
        fileInfo = (FileInfo)this.idToFileOp(1, object, null);
        if (fileInfo != null) {
            this.filePool.putFile((File)fileInfo.file, bl);
        } else {
            bl2 = false;
        }
        return bl2;
    }

    void removeAllData(boolean bl) throws IOException {
        boolean bl2 = true;
        for (FileInfo fileInfo : this.idToRAFile.values()) {
            bl2 = this.raFilePool.putRAFile((RandomAccessFile)fileInfo.file, bl);
        }
        this.idToRAFile.clear();
        if (!bl2) {
            System.out.println("Failed to tag some file free");
        }
        for (FileInfo fileInfo : this.idToFile.values()) {
            this.filePool.putFile((File)fileInfo.file, bl);
        }
        this.idToFile.clear();
    }

    protected RandomAccessFile getRAF(Object object) throws IOException {
        FileInfo fileInfo = (FileInfo)this.idToRAFileOp(2, object, null);
        if (fileInfo != null) {
            return (RandomAccessFile)fileInfo.file;
        }
        fileInfo = (FileInfo)this.idToFileOp(2, object, null);
        if (fileInfo != null) {
            return new RandomAccessFile((File)fileInfo.file, "rw");
        }
        RandomAccessFile randomAccessFile = this.raFilePool.getRAFile();
        if (randomAccessFile != null) {
            this.idToRAFileOp(0, object, new FileInfo(randomAccessFile, 0L, 0L));
        } else {
            File file = this.filePool.getFile();
            try {
                randomAccessFile = new RandomAccessFile(file, "rw");
                this.idToFileOp(0, object, new FileInfo(file, 0L, 0L));
            }
            catch (IOException iOException) {
                this.filePool.putFile(file, false);
                throw iOException;
            }
        }
        return randomAccessFile;
    }

    protected void releaseRAF(Object object, RandomAccessFile randomAccessFile, long l, long l2) {
        FileInfo fileInfo = (FileInfo)this.idToRAFileOp(2, object, null);
        if (fileInfo == null) {
            fileInfo = (FileInfo)this.idToFileOp(2, object, null);
            if (fileInfo != null) {
                fileInfo.endofdata = l;
                fileInfo.endoffile = l2;
            } else if (Store.getDEBUG()) {
                this.logger.log(1, "cannot find owner for raf");
            }
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                if (Store.getDEBUG()) {
                    this.logger.log(1, "failed to close RA files " + fileInfo.file, iOException);
                }
            }
        } else {
            fileInfo.endofdata = l;
            fileInfo.endoffile = l2;
        }
    }

    protected void writeData(Object object, byte[] byArray, byte[] byArray2, boolean bl) throws IOException {
        long l = 8 + (byArray2 == null ? 0 : byArray2.length);
        RandomAccessFile randomAccessFile = this.raFilePool.getRAFile();
        if (randomAccessFile != null) {
            try {
                long l2 = this.writeData(randomAccessFile, byArray, byArray2, bl);
                this.idToRAFileOp(0, object, new FileInfo(randomAccessFile, l2, l2 + l));
            }
            catch (IOException iOException) {
                this.raFilePool.putRAFile(randomAccessFile, bl);
                throw iOException;
            }
        }
        File file = this.filePool.getFile();
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            long l3 = this.writeData(randomAccessFile, byArray, byArray2, bl);
            this.idToFileOp(0, object, new FileInfo(file, l3, l3 + l));
        }
        catch (IOException iOException) {
            this.filePool.putFile(file, bl);
            throw iOException;
        }
        finally {
            block14: {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                        if (!Store.getDEBUG()) break block14;
                        this.logger.log(1, "failed to close RA files " + file, iOException);
                    }
                }
            }
        }
    }

    static void markWriting(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(0L);
        randomAccessFile.writeUTF(WRITING);
    }

    static void markGood(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(0L);
        randomAccessFile.writeUTF(GOOD);
    }

    static void markFree(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(0L);
        randomAccessFile.writeUTF(FREE_FILE);
    }

    private long writeData(RandomAccessFile randomAccessFile, byte[] byArray, byte[] byArray2, boolean bl) throws IOException {
        RandomAccessStore.markWriting(randomAccessFile);
        randomAccessFile.writeLong(byArray.length);
        randomAccessFile.write(byArray);
        long l = randomAccessFile.getFilePointer();
        if (byArray2 == null) {
            randomAccessFile.writeLong(0L);
        } else {
            randomAccessFile.writeLong(byArray2.length);
            randomAccessFile.write(byArray2);
        }
        RandomAccessStore.markGood(randomAccessFile);
        if (bl) {
            randomAccessFile.getChannel().force(false);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFiles(FileInfo[] fileInfoArray, boolean bl) {
        int n = 0;
        for (int i = 0; i < fileInfoArray.length; ++i) {
            try {
                RandomAccessFile randomAccessFile;
                if (!bl || (randomAccessFile = (RandomAccessFile)fileInfoArray[i].file).length() <= fileInfoArray[i].endoffile) continue;
                randomAccessFile.setLength(fileInfoArray[i].endoffile);
                ++n;
                continue;
            }
            catch (IOException iOException) {
                File file = this.raFilePool.getFile((RandomAccessFile)fileInfoArray[i].file);
                this.logger.log(8, "B1045", (Object)(file != null ? file.toString() : ""), (Throwable)iOException);
                continue;
            }
            finally {
                try {
                    ((RandomAccessFile)fileInfoArray[i].file).close();
                }
                catch (IOException iOException) {}
            }
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "Truncated " + n + " files");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void truncateFiles(FileInfo[] fileInfoArray) {
        int n = 0;
        for (int i = 0; i < fileInfoArray.length; ++i) {
            RandomAccessFile randomAccessFile = null;
            try {
                File file = (File)fileInfoArray[i].file;
                if (file.length() <= fileInfoArray[i].endoffile) continue;
                randomAccessFile = new RandomAccessFile((File)fileInfoArray[i].file, "rw");
                randomAccessFile.setLength(fileInfoArray[i].endoffile);
                ++n;
                continue;
            }
            catch (IOException iOException) {
                this.logger.log(8, "B1045", fileInfoArray[i].file, (Throwable)iOException);
                continue;
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "Truncated " + n + " files");
        }
    }

    int getNumFreeFiles() {
        return this.filePool.getNumFreeFiles() + this.raFilePool.freeFiles.size();
    }

    void reset(boolean bl) {
        this.high = 1;
        this.low = 1;
        this.raFilePool.clear();
        this.filePool.clear();
        this.idToRAFile.clear();
        this.idToFile.clear();
        try {
            FileUtil.removeFiles(this.directory, bl);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4149", (Object)this.directory, (Throwable)iOException);
        }
    }

    private void addFileNum(int n) {
        if (n >= this.high) {
            this.high = n + 1;
        } else if (n < this.low) {
            this.low = n;
        }
    }

    private void addRAFile(Object object, RandomAccessFile randomAccessFile, File file, long l, long l2) {
        block2: {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                if (!Store.getDEBUG()) break block2;
                this.logger.log(4, "closing RandomAccessFile failed", iOException);
            }
        }
        this.idToFileOp(0, object, new FileInfo(file, l, l2));
    }

    void addFreeRAFile(RandomAccessFile randomAccessFile, File file) {
        if (!this.raFilePool.addRAFile(randomAccessFile, file, true)) {
            block3: {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    if (!Store.getDEBUG()) break block3;
                    this.logger.log(4, "closing RandomAccessFile failed", iOException);
                }
            }
            this.filePool.putFile(file, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object idToFileOp(int n, Object object, Object object2) {
        Object object3 = null;
        HashMap hashMap = this.idToFile;
        synchronized (hashMap) {
            switch (n) {
                case 0: {
                    object3 = this.idToFile.put(object, object2);
                    break;
                }
                case 1: {
                    object3 = this.idToFile.remove(object);
                    break;
                }
                case 2: {
                    object3 = this.idToFile.get(object);
                }
            }
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object idToRAFileOp(int n, Object object, Object object2) {
        Object object3 = null;
        HashMap hashMap = this.idToRAFile;
        synchronized (hashMap) {
            switch (n) {
                case 0: {
                    object3 = this.idToRAFile.put(object, object2);
                    break;
                }
                case 1: {
                    object3 = this.idToRAFile.remove(object);
                    break;
                }
                case 2: {
                    object3 = this.idToRAFile.get(object);
                }
            }
        }
        return object3;
    }

    void addDataFile(File file) {
        this.dataFiles.add(file);
    }

    Enumeration getEnumeration(boolean bl) {
        if (this.scanned) {
            return new FileEnumeration(this, this.dataFiles.iterator(), bl);
        }
        return new FileEnumeration(this, this.directory, bl);
    }

    private byte[] loadDataFromFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(0L);
        String string = randomAccessFile.readUTF();
        byte[] byArray = null;
        if (GOOD.equals(string)) {
            long l = randomAccessFile.readLong();
            byArray = new byte[(int)l];
            randomAccessFile.read(byArray);
        }
        return byArray;
    }

    private static class FileEnumeration
    implements Enumeration {
        RandomAccessStore parent = null;
        boolean peekonly = false;
        String[] filelist = null;
        File directory = null;
        int index = 0;
        Object obj = null;
        Iterator itr = null;
        Logger logger = Globals.getLogger();
        BrokerResources br = Globals.getBrokerResources();

        FileEnumeration(RandomAccessStore randomAccessStore, Iterator iterator, boolean bl) {
            this.parent = randomAccessStore;
            this.peekonly = bl;
            this.itr = iterator;
        }

        FileEnumeration(RandomAccessStore randomAccessStore, File file, boolean bl) {
            this.parent = randomAccessStore;
            this.peekonly = bl;
            this.directory = file;
            this.filelist = file.list(randomAccessStore.getFilenameFilter());
            if (this.filelist == null) {
                this.filelist = new String[0];
            }
        }

        private boolean more() {
            if (this.itr != null) {
                return this.itr.hasNext();
            }
            return this.index < this.filelist.length && this.obj == null;
        }

        public boolean hasMoreElements() {
            this.obj = null;
            if (this.itr == null && this.index >= this.filelist.length) {
                this.parent.scanned = true;
                return false;
            }
            while (this.obj == null && this.more()) {
                Object object;
                File file = null;
                if (this.itr != null) {
                    file = (File)this.itr.next();
                } else {
                    try {
                        int n = Integer.parseInt(this.filelist[this.index]);
                        this.parent.addFileNum(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        object = new File(this.directory, this.filelist[this.index]);
                        ((File)object).delete();
                        this.logger.log(16, "B2019", ((File)object).getAbsolutePath());
                        ++this.index;
                        continue;
                    }
                    file = new File(this.directory, this.filelist[this.index]);
                    ++this.index;
                }
                RandomAccessFile randomAccessFile = null;
                try {
                    if (file.length() == 0L) {
                        this.parent.filePool.putFile(file, false);
                        continue;
                    }
                    randomAccessFile = new RandomAccessFile(file, "rw");
                    object = randomAccessFile.readUTF();
                    if (RandomAccessStore.GOOD.equals(object)) {
                        long l = randomAccessFile.readLong();
                        if (this.peekonly) {
                            this.obj = new Long(l);
                            randomAccessFile.close();
                            if (this.itr != null) continue;
                            this.parent.addDataFile(file);
                            continue;
                        }
                        byte[] byArray = new byte[(int)l];
                        randomAccessFile.read(byArray);
                        long l2 = randomAccessFile.getFilePointer();
                        l = randomAccessFile.readLong();
                        byte[] byArray2 = null;
                        if (l > 0L) {
                            byArray2 = new byte[(int)l];
                            randomAccessFile.read(byArray2);
                        }
                        long l3 = l2 + 8L + l;
                        this.obj = this.parent.parseData(byArray, byArray2);
                        this.parent.addRAFile(this.obj, randomAccessFile, file, l2, l3);
                        continue;
                    }
                    if (!RandomAccessStore.FREE_FILE.equals(object) && Store.getDEBUG()) {
                        this.logger.log(4, file + " was corrupted");
                    }
                    if (this.itr != null) continue;
                    this.parent.addFreeRAFile(randomAccessFile, file);
                }
                catch (IOException iOException) {
                    this.logger.log(16, "B2020", (Object)file, (Throwable)iOException);
                    if (this.itr != null) continue;
                    this.parent.addFreeRAFile(randomAccessFile, file);
                }
            }
            return this.obj != null;
        }

        public Object nextElement() {
            if (this.obj != null) {
                Object object = this.obj;
                this.obj = null;
                return object;
            }
            throw new NoSuchElementException();
        }
    }

    private static class RAFilePool {
        int limit = 0;
        LinkedList freeFiles = new LinkedList();
        HashMap allRAFiles = null;
        RandomAccessStore store;
        Logger logger = Globals.getLogger();

        RAFilePool(RandomAccessStore randomAccessStore, int n) {
            this.limit = n;
            this.store = randomAccessStore;
            this.allRAFiles = new HashMap(n);
            if (Store.getDEBUG()) {
                this.logger.log(4, this.getClass().getName() + ": Created new rafile pool: capacity=" + n);
            }
        }

        synchronized RandomAccessFile getRAFile() throws IOException {
            if (this.limit == 0) {
                return null;
            }
            RandomAccessFile randomAccessFile = null;
            int n = this.freeFiles.size();
            if (n > 0) {
                return (RandomAccessFile)this.freeFiles.remove(n - 1);
            }
            if (this.allRAFiles.size() < this.limit) {
                File file = this.store.filePool.getFile();
                randomAccessFile = new RandomAccessFile(file, "rw");
                this.allRAFiles.put(randomAccessFile, file);
                return randomAccessFile;
            }
            return null;
        }

        synchronized boolean addRAFile(RandomAccessFile randomAccessFile, File file, boolean bl) {
            if (this.limit == 0) {
                return false;
            }
            boolean bl2 = true;
            if (this.allRAFiles.size() < this.limit) {
                if (bl && !this.putRAFile(randomAccessFile, false)) {
                    bl2 = false;
                }
                if (bl2) {
                    this.allRAFiles.put(randomAccessFile, file);
                }
            } else {
                bl2 = false;
            }
            return bl2;
        }

        synchronized boolean putRAFile(RandomAccessFile randomAccessFile, boolean bl) {
            if (randomAccessFile == null) {
                return false;
            }
            try {
                RandomAccessStore.markFree(randomAccessFile);
                if (bl) {
                    randomAccessFile.getChannel().force(false);
                }
                this.freeFiles.add(randomAccessFile);
                return true;
            }
            catch (IOException iOException) {
                File file = (File)this.allRAFiles.remove(randomAccessFile);
                if (file != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                if (Store.getDEBUG()) {
                    this.logger.log(4, "Fail to tag free file" + file.toString(), iOException);
                }
                return false;
            }
        }

        File getFile(RandomAccessFile randomAccessFile) {
            return (File)this.allRAFiles.get(randomAccessFile);
        }

        void clear() {
            if (this.limit == 0) {
                return;
            }
            Object[] objectArray = this.allRAFiles.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                RandomAccessFile randomAccessFile = (RandomAccessFile)objectArray[i];
                try {
                    randomAccessFile.close();
                    continue;
                }
                catch (IOException iOException) {
                    if (!Store.getDEBUG()) continue;
                    this.logger.log(1, "Got exception while closing file", iOException);
                }
            }
            this.freeFiles.clear();
            this.allRAFiles.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(boolean bl) {
            if (this.limit == 0) {
                return;
            }
            RandomAccessFile[] randomAccessFileArray = this.freeFiles.toArray(new RandomAccessFile[this.freeFiles.size()]);
            for (int i = 0; i < randomAccessFileArray.length; ++i) {
                File file = (File)this.allRAFiles.remove(randomAccessFileArray[i]);
                try {
                    if (!bl) continue;
                    try {
                        if (randomAccessFileArray[i].length() == 0L) continue;
                        randomAccessFileArray[i].setLength(0L);
                    }
                    catch (IOException iOException) {
                        if (!Store.getDEBUG()) continue;
                        this.logger.log(4, "truncate file failed for " + (file != null ? file.toString() : ""));
                    }
                    continue;
                }
                finally {
                    block11: {
                        try {
                            randomAccessFileArray[i].close();
                        }
                        catch (IOException iOException) {
                            if (!Store.getDEBUG()) break block11;
                            this.logger.log(4, "failed to close " + file);
                        }
                    }
                }
            }
        }

        void printFileInfo(PrintStream printStream) {
            printStream.println("number of opened files: " + this.allRAFiles.size());
            printStream.println("number of available opened files: " + this.freeFiles.size());
        }

        void printStatistics() {
            if (Store.getDEBUG()) {
                this.logger.log(4, "total number of opened files=" + this.allRAFiles.size());
                this.logger.log(4, "number of free files = " + this.freeFiles.size());
            }
        }
    }

    private static class FileInfo {
        Object file;
        long endofdata;
        long endoffile;

        FileInfo(Object object, long l, long l2) {
            this.file = object;
            this.endofdata = l;
            this.endoffile = l2;
        }
    }
}

