/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import com.sun.messaging.jmq.jmsserver.util.TransactionAckExistException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ConsumerStateDAOImpl
extends BaseDAOImpl
implements ConsumerStateDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateTransactionSQL;
    protected String updateStateSQL;
    protected String updateState2SQL;
    protected String clearTxnSQL;
    protected String deleteByTxnSQL;
    protected String deleteByDstSQL;
    protected String deleteByStateSQL;
    protected String deleteByMsgSQL;
    protected String selectStateSQL;
    protected String selectStatesByMsgSQL;
    protected String selectTransactionSQL;
    protected String selectCountByMsgSQL;
    protected String selectConsumerIDsByMsgSQL;
    protected String selectTransactionAcksSQL;
    protected String selectAllTransactionAcksSQL;

    ConsumerStateDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        String string = Globals.getHAEnabled() ? " AND NOT EXISTS (" + ((BrokerDAOImpl)dBManager.getDAOFactory().getBrokerDAO()).selectIsBeingTakenOverSQL + ")" : "";
        this.tableName = dBManager.getTableName("MQCONSTATE41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ? )").toString();
        this.updateTransactionSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TRANSACTION_ID").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").append(" AND ").append("TRANSACTION_ID").append(" IS NULL").append(string).toString();
        this.updateStateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.updateState2SQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").toString();
        this.clearTxnSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TRANSACTION_ID").append(" = NULL").append(" WHERE ").append("TRANSACTION_ID").append(" = ?").append(string).toString();
        this.deleteByTxnSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").toString();
        this.deleteByDstSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" IN ").append("(SELECT msgTbl.").append("ID").append(" FROM ").append(dBManager.getTableName("MQMSG41")).append(" msgTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(" AND ").append("DESTINATION_ID").append(" = ?)").toString();
        this.deleteByMsgSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.deleteByStateSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("STATE").append(" = ?").toString();
        this.selectStateSQL = new StringBuffer(128).append("SELECT ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.selectStatesByMsgSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER_ID").append(", ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.selectTransactionSQL = new StringBuffer(128).append("SELECT ").append("TRANSACTION_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.selectCountByMsgSQL = new StringBuffer(128).append("SELECT COUNT(*) FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.selectConsumerIDsByMsgSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ? ").append(" AND ").append("STATE").append(" <> ").append(2).toString();
        this.selectTransactionAcksSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER_ID").append(", ").append("MESSAGE_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").toString();
        this.selectAllTransactionAcksSQL = new StringBuffer(128).append("SELECT ").append("TRANSACTION_ID").append(", ").append("CONSUMER_ID").append(", ").append("MESSAGE_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" IS NOT NULL").toString();
    }

    public final String getTableNamePrefix() {
        return "MQCONSTATE41";
    }

    public String getTableName() {
        return this.tableName;
    }

    public void insert(Connection connection, String string, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        block20: {
            PreparedStatement preparedStatement;
            block19: {
                String string2 = sysMessageID.getUniqueName();
                int n = 0;
                boolean bl2 = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl2 = true;
                    }
                    if (bl) {
                        if (this.getConsumerCount(connection, string2) > 0) {
                            throw new BrokerException(this.br.getKString("B3084", string2));
                        }
                        dBManager.getDAOFactory().getMessageDAO().checkMessage(connection, string, string2);
                    }
                    boolean bl3 = dBManager.supportsBatchUpdates();
                    preparedStatement = connection.prepareStatement(this.insertSQL);
                    int n2 = consumerUIDArray.length;
                    while (n < n2) {
                        preparedStatement.setString(1, string2);
                        preparedStatement.setLong(2, consumerUIDArray[n].longValue());
                        preparedStatement.setInt(3, nArray[n]);
                        preparedStatement.setLong(4, System.currentTimeMillis());
                        if (bl3) {
                            preparedStatement.addBatch();
                        } else {
                            preparedStatement.executeUpdate();
                        }
                        ++n;
                    }
                    if (bl3) {
                        preparedStatement.executeBatch();
                    }
                    if (bl2) {
                        connection.commit();
                    }
                    if (!bl2) break block19;
                }
                catch (Exception exception) {
                    try {
                        if (Store.getDEBUG() && n < consumerUIDArray.length) {
                            this.logger.log(4, "Failed to persist interest: " + consumerUIDArray[n].toString() + "(" + consumerUIDArray[n].getUniqueName() + ")");
                        }
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4105", string2), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block20;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void updateState(Connection connection, DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n) throws BrokerException {
        block14: {
            PreparedStatement preparedStatement;
            block13: {
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    String string2 = dBManager.getDAOFactory().getMessageDAO().getBroker(connection, destinationUID, string);
                    if (Globals.getHAEnabled() && !dBManager.getBrokerID().equals(string2)) {
                        throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), 405);
                    }
                    preparedStatement = connection.prepareStatement(this.updateStateSQL);
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, string);
                    preparedStatement.setLong(3, consumerUID.longValue());
                    if (preparedStatement.executeUpdate() == 0) {
                        throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                    }
                    if (!bl) break block13;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateStateSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block14;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void updateState(Connection connection, DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, int n2) throws BrokerException {
        String string = sysMessageID.getUniqueName();
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.updateState2SQL);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            preparedStatement.setLong(3, consumerUID.longValue());
            preparedStatement.setInt(4, n2);
            if (preparedStatement.executeUpdate() == 0) {
                int n3 = this.getState(connection, sysMessageID, consumerUID);
                if (n3 != n2) {
                    Object[] objectArray = new String[]{consumerUID.toString(), sysMessageID.toString(), String.valueOf(n2), String.valueOf(n3)};
                    throw new BrokerException(this.br.getKString("B3180", objectArray), 412);
                }
                throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateState2SQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void updateTransaction(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID, TransactionUID transactionUID) throws BrokerException {
        block19: {
            PreparedStatement preparedStatement;
            block18: {
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    dBManager.getDAOFactory().getTransactionDAO().checkTransaction(connection, transactionUID.longValue());
                    preparedStatement = connection.prepareStatement(this.updateTransactionSQL);
                    preparedStatement.setLong(1, transactionUID.longValue());
                    preparedStatement.setString(2, string);
                    preparedStatement.setLong(3, consumerUID.longValue());
                    if (Globals.getHAEnabled()) {
                        preparedStatement.setString(4, dBManager.getBrokerID());
                    }
                    if (preparedStatement.executeUpdate() == 0) {
                        long l;
                        if (Globals.getHAEnabled()) {
                            String string2 = dBManager.getBrokerID();
                            BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
                            if (brokerDAO.isBeingTakenOver(connection, string2)) {
                                StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                                try {
                                    HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, string2);
                                    this.logger.log(32, this.br.getKString("B4117", hABrokerInfo.toString()), storeBeingTakenOverException);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                throw storeBeingTakenOverException;
                            }
                        }
                        if ((l = this.getTransaction(connection, sysMessageID, consumerUID)) > 0L) {
                            String string3 = "[" + sysMessageID + "]" + consumerUID;
                            throw new TransactionAckExistException(this.br.getKString("B4056", string3, transactionUID) + " : " + this.br.getKString("B3062", string3, String.valueOf(l)), 409);
                        }
                        throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                    }
                    if (!bl) break block18;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateTransactionSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block19;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void clearTransaction(Connection connection, TransactionUID transactionUID) throws BrokerException {
        block17: {
            PreparedStatement preparedStatement;
            block16: {
                long l = transactionUID.longValue();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.clearTxnSQL);
                    preparedStatement.setLong(1, l);
                    if (Globals.getHAEnabled()) {
                        preparedStatement.setString(2, dBManager.getBrokerID());
                    }
                    if (preparedStatement.executeUpdate() == 0 && Globals.getHAEnabled()) {
                        String string = dBManager.getBrokerID();
                        BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
                        if (brokerDAO.isBeingTakenOver(connection, string)) {
                            StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                            try {
                                HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, string);
                                this.logger.log(32, this.br.getKString("B4117", hABrokerInfo.toString()), storeBeingTakenOverException);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            throw storeBeingTakenOverException;
                        }
                    }
                    if (!bl) break block16;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.clearTxnSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4225", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block17;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void deleteByMessageID(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        String string = sysMessageID.getUniqueName();
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.deleteByMsgSQL);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteByMsgSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4037", string), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void deleteByTransaction(Connection connection, TransactionUID transactionUID) throws BrokerException {
        long l = transactionUID.longValue();
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.deleteByTxnSQL);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteByTxnSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4240", transactionUID), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void deleteByDestination(Connection connection, DestinationUID destinationUID) throws BrokerException {
        block12: {
            PreparedStatement preparedStatement;
            block11: {
                String string = destinationUID.toString();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteByDstSQL);
                    preparedStatement.setString(1, dBManager.getBrokerID());
                    preparedStatement.setString(2, string);
                    preparedStatement.executeUpdate();
                    if (!bl) break block11;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteByDstSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4227", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block12;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void deleteAll(Connection connection) throws BrokerException {
        String string = null;
        if (Globals.getHAEnabled()) {
            DBManager dBManager = DBManager.getDBManager();
            string = new StringBuffer(128).append("MESSAGE_ID").append(" IN (SELECT msgTbl.").append("ID").append(" FROM ").append(dBManager.getTableName("MQMSG41")).append(" msgTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = '").append(dBManager.getBrokerID()).append("' AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(")").toString();
        }
        this.deleteAll(connection, string, null, 0);
    }

    public int getState(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        int n;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                n = -1;
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectStateSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setLong(2, consumerUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                    }
                    n = resultSet.getInt(1);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectStateSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4036", consumerUID.toString(), string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return n;
    }

    public HashMap getStates(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        HashMap<ConsumerUID, Integer> hashMap;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                hashMap = new HashMap<ConsumerUID, Integer>();
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectStatesByMsgSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        ConsumerUID consumerUID = new ConsumerUID(resultSet.getLong(1));
                        int n = resultSet.getInt(2);
                        hashMap.put(consumerUID, n);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectStatesByMsgSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4228", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return hashMap;
    }

    public long getTransaction(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        long l;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                l = -1L;
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTransactionSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setLong(2, consumerUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        l = resultSet.getLong(1);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTransactionSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4013", consumerUID.toString()), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return l;
    }

    public List getConsumerUIDs(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        ArrayList<ConsumerUID> arrayList;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                arrayList = new ArrayList<ConsumerUID>();
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectConsumerIDsByMsgSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        ConsumerUID consumerUID = new ConsumerUID(resultSet.getLong(1));
                        arrayList.add(consumerUID);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectConsumerIDsByMsgSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4228", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return arrayList;
    }

    public List getTransactionAcks(Connection connection, TransactionUID transactionUID) throws BrokerException {
        ArrayList<TransactionAcknowledgement> arrayList;
        block12: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block11: {
                arrayList = new ArrayList<TransactionAcknowledgement>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTransactionAcksSQL);
                    preparedStatement.setLong(1, transactionUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        ConsumerUID consumerUID = new ConsumerUID(resultSet.getLong(1));
                        try {
                            SysMessageID sysMessageID = SysMessageID.get(resultSet.getString(2));
                            arrayList.add(new TransactionAcknowledgement(sysMessageID, consumerUID, consumerUID));
                        }
                        catch (Exception exception) {
                            this.logger.logStack(32, "B4129", transactionUID, (Throwable)exception);
                        }
                    }
                    if (!bl) break block11;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTransactionAcksSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4229", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block12;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return arrayList;
    }

    public HashMap getAllTransactionAcks(Connection connection) throws BrokerException {
        ArrayList<TransactionAcknowledgement> arrayList;
        Object object;
        Object object2;
        Object object3;
        HashMap<Object, Object> hashMap;
        block15: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block14: {
                hashMap = new HashMap<Object, Object>(100);
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllTransactionAcksSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        object3 = new TransactionUID(resultSet.getLong(1));
                        object2 = new ConsumerUID(resultSet.getLong(2));
                        try {
                            object = SysMessageID.get(resultSet.getString(3));
                            arrayList = (ArrayList<TransactionAcknowledgement>)hashMap.get(object3);
                            if (arrayList == null) {
                                arrayList = new ArrayList<TransactionAcknowledgement>(25);
                                hashMap.put(object3, arrayList);
                            }
                            arrayList.add(new TransactionAcknowledgement((SysMessageID)object, (ConsumerUID)object2, (ConsumerUID)object2));
                        }
                        catch (Exception exception) {
                            this.logger.logStack(32, "B4129", object3, (Throwable)exception);
                        }
                    }
                    if (!bl) break block14;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllTransactionAcksSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4054"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block15;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        object3 = hashMap.keySet();
        if (!object3.isEmpty()) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (TransactionUID)object2.next();
                arrayList = (List)hashMap.get(object);
                hashMap.put(object, arrayList.toArray(new TransactionAcknowledgement[0]));
            }
        }
        return hashMap;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Message/Consumer states(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }

    public int getConsumerCount(Connection connection, String string) throws BrokerException {
        int n;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                n = -1;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(false);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectCountByMsgSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectCountByMsgSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4228", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return n;
    }
}

