/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.StoreManager;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnectionPool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeHAStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DBTool
implements DBConstants {
    static final String SQLFILEDIR_PROP = "imq.persist.jdbcsqlfile.dirpath";
    static final String SQLFILENAME_PROP = "imq.persist.jdbcsqlfile.name";
    static final String STORE_PROPERTY_HABROKERS = "imq.cluster.haBrokers";
    private static int EXTRA_CMD_SPECIFIED = 0;
    private static int BAD_CMD_ARG = 1;
    private static int BAD_OPT = 2;
    private static int BAD_OPT_ARG = 3;
    private static int MISSING_OPT_ARG = 4;
    private static int MISSING_CMD_ARG = 5;
    private static String CMD_NAME = "dbmgrcmd";
    private static String CREATE_ALL_CMD = "createall";
    private static String CREATE_TBL_CMD = "createtbl";
    private static String DELETE_TBL_CMD = "deletetbl";
    private static String RECREATE_TBL_CMD = "recreatetbl";
    private static String REMOVE_BKR_CMD = "removebkr";
    private static String DUMP_CMD = "dump";
    private static String DROPTBL_CMD = "droptbl";
    private static String RESET_CMD = "reset";
    private static String BACKUP_CMD = "backup";
    private static String RESTORE_CMD = "restore";
    private static String UPGRADE_STORE_CMD = "upgradestore";
    private static String UPGRADE_HASTORE_CMD = "upgradehastore";
    private static String QUERY_CMD = "query";
    private static String ARG_NAME = "dbmgrarg";
    private static String CREATE_CMD_STR = "create";
    private static String DELETE_CMD_STR = "delete";
    private static String RECREATE_CMD_STR = "recreate";
    private static String REMOVE_CMD_STR = "remove";
    private static String UPGRADE_CMD_STR = "upgrade";
    private static String ARGU_ALL = "all";
    private static String ARGU_TBL = "tbl";
    private static String ARGU_BKR = "bkr";
    private static String ARGU_OLDTBL = "oldtbl";
    private static String ARGU_LCK = "lck";
    private static String ARGU_STORE = "store";
    private static String ARGU_HASTORE = "hastore";
    private static String OPT_H = "-h";
    private static String OPT_LH = "-help";
    private static String OPT_V = "-v";
    private static String OPT_LV = "-version";
    private static String OPT_B = "-b";
    private static String OPT_N = "-n";
    private static String OPT_U = "-u";
    private static String OPT_P = "-p";
    private static String OPT_PW = "-pw";
    private static String OPT_PASSFILE = "-passfile";
    private static String OPT_D = "-D";
    private static String OPT_VARHOME = "-varhome";
    private static String OPT_VERBOSE = "-verbose";
    private static String OPT_DEBUG = "-debug";
    private static String OPT_DIR = "-dir";
    private static String OPT_FORCE = "-f";
    private static BrokerResources br = Globals.getBrokerResources();
    private static BrokerConfig config;
    private static Logger logger;
    private Version version = new Version();
    private DBManager dbmgr = null;
    private boolean standalone = true;
    private boolean cliPasswdSpecified = false;
    private boolean debugSpecified = false;
    private boolean forceSpecified = false;

    DBTool(boolean bl) {
        this.standalone = bl;
    }

    private void doCreate(boolean bl) throws BrokerException {
        Connection connection = null;
        try {
            if (bl) {
                connection = this.dbmgr.connectToCreate();
                connection.setAutoCommit(true);
            } else {
                connection = this.dbmgr.newConnection(true);
            }
            boolean bl2 = false;
            int n = this.dbmgr.checkStoreExists(connection);
            if (n > 0) {
                throw new BrokerException(br.getKString("B3210"));
            }
            if (n < 0) {
                bl2 = true;
            }
            DBTool.createTables(connection, bl2);
            if (this.standalone) {
                if (Globals.getHAEnabled()) {
                    System.out.println(br.getString("B1165", Globals.getClusterID()));
                } else {
                    System.out.println(br.getString("B1046"));
                }
            }
        }
        catch (Throwable throwable) {
            String string = bl ? this.dbmgr.getCreateDBURL() : this.dbmgr.getOpenDBURL();
            throw new BrokerException(br.getKString("B3073", string, throwable));
        }
        finally {
            if (!bl && connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException));
                }
            }
        }
    }

    static void createTables(Connection connection) throws BrokerException {
        DBTool.createTables(connection, false);
    }

    static void createTables(Connection connection, boolean bl) throws BrokerException {
        BaseDAO baseDAO2;
        DBManager dBManager = DBManager.getDBManager();
        DAOFactory dAOFactory = dBManager.getDAOFactory();
        block8: for (BaseDAO baseDAO2 : dAOFactory.getAllDAOs()) {
            try {
                Util.RetryStrategy retryStrategy = null;
                while (true) {
                    try {
                        baseDAO2.createTable(connection);
                        continue block8;
                    }
                    catch (Exception exception) {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    break;
                }
            }
            catch (BrokerException brokerException) {
                if (Globals.getHAEnabled()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (dBManager.checkStoreExists(connection) > 0) {
                    Globals.getLogger().log(16, "B3073", Globals.getBrokerResources().getString("B3210"));
                    bl = true;
                    break;
                }
                if (bl) {
                    Globals.getLogger().log(16, brokerException.toString(), brokerException.getCause());
                    continue;
                }
                throw brokerException;
            }
        }
        baseDAO2 = dAOFactory.getVersionDAO();
        try {
            if (bl) {
                int n = baseDAO2.getStoreVersion(connection);
                if (n != 410) {
                    baseDAO2.insert(connection, 410);
                }
            } else {
                baseDAO2.insert(connection, 410);
            }
        }
        catch (BrokerException brokerException) {
            if (Globals.getHAEnabled()) {
                int n = baseDAO2.getStoreVersion(connection);
                if (n != 410) {
                    throw brokerException;
                }
            }
            throw brokerException;
        }
        if (!Globals.getHAEnabled()) {
            String string = Globals.getBrokerID();
            StoreSessionDAO storeSessionDAO = dAOFactory.getStoreSessionDAO();
            if (storeSessionDAO.getStoreSession(connection, string) <= 0L) {
                storeSessionDAO.insert(connection, string, new UID().longValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReset() throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            DBManager.lockTables(connection, false);
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doDelete(String string) throws BrokerException {
        boolean bl = false;
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            if (string == null || string.length() == 0) {
                boolean bl2 = false;
                int n = this.dbmgr.checkStoreExists(connection);
                if (n > 0) {
                    if (!this.forceSpecified && Globals.getHAEnabled() && this.dbmgr.isHAClusterActive(connection)) {
                        throw new BrokerException(br.getKString("B3209", this.dbmgr.getClusterID()));
                    }
                    try {
                        if (!this.forceSpecified) {
                            DBManager.lockTables(connection, true);
                        }
                    }
                    catch (BrokerException brokerException) {
                        if (brokerException.getStatusCode() != 404) throw brokerException;
                        bl2 = true;
                    }
                } else {
                    if (n >= 0) throw new BrokerException(br.getKString("B3211"));
                    bl2 = true;
                }
                bl = DBTool.dropTables(connection, null, bl2);
            } else if (string.equals(ARGU_OLDTBL)) {
                int n = -1;
                if (DBTool.checkVersion(connection, "IMQSV37" + this.dbmgr.getBrokerID())) {
                    n = 370;
                } else {
                    if (!DBTool.checkVersion(connection, "IMQSV35" + this.dbmgr.getBrokerID())) throw new BrokerException("Old persistent store (version 370) not found");
                    n = 350;
                }
                bl = DBTool.dropTables(connection, this.dbmgr.getTableNames(n));
            }
            if (!this.standalone) return;
            if (!bl) return;
            if (Globals.getHAEnabled()) {
                System.out.println(br.getString("B1166", Globals.getClusterID()));
                return;
            }
            System.out.println(br.getString("B1051"));
            return;
        }
        catch (Exception exception) {
            throw new BrokerException(br.getKString("B3075", this.dbmgr.getOpenDBURL()), exception);
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    static boolean dropTables(Connection connection, String[] stringArray) throws SQLException, BrokerException {
        return DBTool.dropTables(connection, stringArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean dropTables(Connection connection, String[] stringArray, boolean bl) throws SQLException, BrokerException {
        boolean bl2 = false;
        try {
            if (stringArray != null && stringArray.length > 0) {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    for (String string : stringArray) {
                        Globals.getLogger().logToAll(8, br.getString("B1164", string));
                        statement.executeUpdate("DROP TABLE " + string);
                    }
                }
                finally {
                    Util.close(null, statement, null);
                }
            } else {
                DAOFactory dAOFactory = DBManager.getDBManager().getDAOFactory();
                block11: for (BaseDAO baseDAO : dAOFactory.getAllDAOs()) {
                    try {
                        Util.RetryStrategy retryStrategy = null;
                        while (true) {
                            try {
                                baseDAO.dropTable(connection);
                                continue block11;
                            }
                            catch (Exception exception) {
                                if (retryStrategy == null) {
                                    retryStrategy = new Util.RetryStrategy();
                                }
                                retryStrategy.assertShouldRetry(exception);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (BrokerException brokerException) {
                        if (bl) {
                            Globals.getLogger().log(16, brokerException.toString(), brokerException.getCause());
                            continue;
                        }
                        throw brokerException;
                    }
                }
            }
            bl2 = true;
        }
        catch (SQLException sQLException) {
            Globals.getLogger().log(32, "B3075", (Object)sQLException.toString(), (Throwable)sQLException);
            throw sQLException;
        }
        catch (BrokerException brokerException) {
            Globals.getLogger().log(32, "B3075", (Object)brokerException.toString(), (Throwable)brokerException);
            throw brokerException;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkVersion(Connection connection, String string) throws BrokerException {
        String string2 = "SELECT * FROM " + string;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
        }
        catch (SQLException sQLException) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                throw throwable;
            }
            Util.close(resultSet, statement, null);
            return bl;
        }
        Util.close(resultSet, statement, null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRecreate() throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            boolean bl = false;
            boolean bl2 = false;
            int n = this.dbmgr.checkStoreExists(connection);
            if (n > 0) {
                if (!this.forceSpecified && Globals.getHAEnabled() && this.dbmgr.isHAClusterActive(connection)) {
                    throw new BrokerException(br.getKString("B3209", this.dbmgr.getClusterID()));
                }
                try {
                    if (!this.forceSpecified) {
                        DBManager.lockTables(connection, true);
                    }
                }
                catch (BrokerException brokerException) {
                    if (brokerException.getStatusCode() != 404) throw brokerException;
                    bl2 = true;
                }
            } else if (n < 0) {
                bl2 = true;
            } else {
                bl = true;
            }
            if (!bl) {
                DBTool.dropTables(connection, null, bl2);
            }
            DBTool.createTables(connection, false);
            if (!this.standalone) return;
            if (Globals.getHAEnabled()) {
                System.out.println(br.getString("B1165", Globals.getClusterID()));
                return;
            }
            System.out.println(br.getString("B1046"));
            return;
        }
        catch (Throwable throwable) {
            throw new BrokerException(br.getKString("B3076", this.dbmgr.getOpenDBURL()), throwable);
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveBkr() throws BrokerException {
        String string;
        String string2;
        block15: {
            string2 = Globals.getBrokerID();
            Connection connection = null;
            string = null;
            try {
                connection = this.dbmgr.getConnection(true);
                DBManager.lockTables(connection, true);
                try {
                    DAOFactory dAOFactory = this.dbmgr.getDAOFactory();
                    BrokerDAO brokerDAO = dAOFactory.getBrokerDAO();
                    BrokerState brokerState = brokerDAO.getState(connection, string2);
                    if (!brokerState.isActiveState()) {
                        try {
                            connection.setAutoCommit(false);
                            dAOFactory.getConsumerStateDAO().deleteAll(connection);
                            dAOFactory.getMessageDAO().deleteAll(connection);
                            dAOFactory.getDestinationDAO().deleteAll(connection);
                            dAOFactory.getTransactionDAO().deleteAll(connection);
                            dAOFactory.getStoreSessionDAO().deleteByBrokerID(connection, string2);
                            brokerDAO.delete(connection, string2);
                            connection.commit();
                            break block15;
                        }
                        finally {
                            connection.setAutoCommit(true);
                        }
                    }
                    string = br.getString("B3182", string2, "broker is still active - " + brokerState);
                }
                finally {
                    DBManager.lockTables(connection, false);
                }
            }
            catch (Exception exception) {
                throw new BrokerException(br.getKString("B3183", string2), exception);
            }
            finally {
                Util.close(null, null, connection);
            }
        }
        if (this.standalone) {
            if (string == null) {
                System.out.println(br.getString("B1167", string2));
            } else {
                System.out.println(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpgrade(boolean bl) throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            if (bl) {
                new UpgradeHAStore().upgradeStore(connection);
            } else {
                JDBCStore jDBCStore = (JDBCStore)StoreManager.getStore();
                int n = -1;
                if (jDBCStore.checkOldStoreVersion(connection, this.dbmgr.getTableName("MQVER40"), "STORE_VERSION", 400)) {
                    n = 400;
                } else if (jDBCStore.checkOldStoreVersion(connection, "IMQSV37" + this.dbmgr.getBrokerID(), "STOREVERSION", 370)) {
                    n = 370;
                } else if (jDBCStore.checkOldStoreVersion(connection, "IMQSV35" + this.dbmgr.getBrokerID(), "STOREVERSION", 350)) {
                    n = 350;
                } else {
                    throw new BrokerException("Old persistent store (version 400) not found");
                }
                new UpgradeStore(jDBCStore, n).upgradeStore(connection);
            }
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDump(String string) throws SQLException, BrokerException {
        int n = 410;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        String[] stringArray = null;
        if (n != 410 && ((stringArray = this.dbmgr.getTableNames(n)) == null || stringArray.length == 0)) {
            throw new BrokerException("version " + string + " not supported");
        }
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            DBTool.doDump(connection, stringArray);
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doDump(Connection connection, String[] stringArray) throws BrokerException, SQLException {
        if (stringArray != null && stringArray.length > 0) {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                for (int i = 0; i < stringArray.length; ++i) {
                    ResultSet resultSet = null;
                    String string = stringArray[i];
                    String string2 = "SELECT COUNT(*) FROM " + string;
                    try {
                        resultSet = statement.executeQuery(string2);
                        if (resultSet.next()) {
                            System.out.println(string + ": number of row=" + resultSet.getInt(1));
                        }
                        resultSet.close();
                        continue;
                    }
                    catch (SQLException sQLException) {
                        SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                        logger.log(32, "failed to dump tables", sQLException2);
                    }
                }
            }
            finally {
                Util.close(null, statement, null);
            }
        } else {
            DAOFactory dAOFactory = DBManager.getDBManager().getDAOFactory();
            for (BaseDAO baseDAO : dAOFactory.getAllDAOs()) {
                System.out.println(baseDAO.getDebugInfo(connection).toString());
            }
        }
    }

    private void doDropTablesByPattern(String string) throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            Map map = this.dbmgr.getTableNamesFromDB(connection, string);
            String[] stringArray = map.values().toArray(new String[0]);
            if (stringArray == null || stringArray.length == 0) {
                System.out.println("There were no tables that match the name pattern 'MQ*" + string + "'.");
                return;
            }
            System.out.println("Tables matching the name pattern 'MQ*" + string + "':");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                System.out.println("\t" + stringArray[i]);
            }
            if (!this.forceSpecified) {
                System.out.println("Remove all tables that match 'MQ*" + string + "'.\nDo you wish to proceed? [y/n] ");
                System.out.flush();
                String string2 = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if (!"y".equalsIgnoreCase(string2) && !"yes".equalsIgnoreCase(string2)) {
                    return;
                }
            }
            DBTool.dropTables(connection, stringArray, true);
        }
        catch (Exception exception) {
            System.err.println("Failed to drop tables by name pattern: " + exception.getMessage());
            throw new BrokerException(br.getKString("B3075", "table name pattern '" + string + "'"), exception);
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBackup() throws BrokerException {
        if (!Globals.getHAEnabled()) {
            throw new BrokerException(br.getKString("B1230", this.dbmgr.getBrokerID()));
        }
        Properties properties = System.getProperties();
        String string = Globals.getClusterID();
        String string2 = (String)properties.get("imq.backupdir") + File.separator + string;
        logger.logToAll(8, "Backup persistent store for HA cluster " + string);
        FileStore fileStore = new FileStore(string2, false);
        fileStore.clearAll(false);
        JDBCStore jDBCStore = null;
        try {
            jDBCStore = (JDBCStore)StoreManager.getStore();
            Properties properties2 = jDBCStore.getAllProperties();
            for (Map.Entry<Object, Object> objectArray2 : properties2.entrySet()) {
                fileStore.updateProperty((String)objectArray2.getKey(), objectArray2.getValue(), false);
            }
            Iterator<Map.Entry<Object, Object>> iterator = null;
            properties2 = null;
            Object[] objectArray = jDBCStore.getAllConfigRecords();
            ArrayList arrayList = (ArrayList)objectArray[0];
            ArrayList arrayList2 = (ArrayList)objectArray[1];
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                fileStore.storeConfigChangeRecord((Long)arrayList.get(i), (byte[])arrayList2.get(i), false);
            }
            Object var8_12 = null;
            arrayList = null;
            arrayList2 = null;
            Consumer[] consumerArray = jDBCStore.getAllInterests();
            for (n = 0; n < consumerArray.length; ++n) {
                fileStore.storeInterest(consumerArray[n], false);
            }
            consumerArray = null;
            HashMap hashMap = jDBCStore.getAllBrokerInfos(true);
            ArrayList arrayList3 = new ArrayList(hashMap.values());
            fileStore.updateProperty(STORE_PROPERTY_HABROKERS, arrayList3, false);
            for (HABrokerInfo hABrokerInfo : arrayList3) {
                String string3 = hABrokerInfo.getId();
                logger.logToAll(8, "Backup persistent data for broker " + string3);
                Store store = null;
                try {
                    TransactionAcknowledgement[] transactionAcknowledgementArray;
                    Serializable serializable;
                    Object object2;
                    int n2;
                    store = new FileStore(string2 + File.separator + string3, false);
                    ((FileStore)store).clearAll(false);
                    Destination[] destinationArray = jDBCStore.getAllDestinations(string3);
                    int n3 = destinationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object2 = destinationArray[n2].getDestinationUID();
                        serializable = ((FileStore)store).getDestination((DestinationUID)object2);
                        if (serializable != null) continue;
                        ((FileStore)store).storeDestination(destinationArray[n2], false);
                    }
                    n3 = destinationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object2 = jDBCStore.messageEnumeration(destinationArray[n2]);
                        while (object2.hasMoreElements()) {
                            SysMessageID sysMessageID;
                            serializable = destinationArray[n2].getDestinationUID();
                            HashMap hashMap2 = jDBCStore.getInterestStates((DestinationUID)serializable, sysMessageID = (transactionAcknowledgementArray = (TransactionAcknowledgement[])object2.nextElement()).getSysMessageID());
                            if (hashMap2 == null || hashMap2.isEmpty()) {
                                ((FileStore)store).storeMessage((DestinationUID)serializable, (Packet)transactionAcknowledgementArray, false);
                                continue;
                            }
                            int n4 = hashMap2.size();
                            ConsumerUID[] consumerUIDArray = new ConsumerUID[n4];
                            int[] nArray = new int[n4];
                            Iterator iterator2 = hashMap2.entrySet().iterator();
                            int n5 = 0;
                            while (iterator2.hasNext()) {
                                Map.Entry entry = iterator2.next();
                                consumerUIDArray[n5] = (ConsumerUID)entry.getKey();
                                nArray[n5] = (Integer)entry.getValue();
                                ++n5;
                            }
                            ((FileStore)store).storeMessage((DestinationUID)serializable, (Packet)transactionAcknowledgementArray, consumerUIDArray, nArray, false);
                        }
                    }
                    Collection collection = jDBCStore.getTransactions(string3);
                    for (Object object2 : collection) {
                        serializable = jDBCStore.getTransactionInfo((TransactionUID)object2);
                        transactionAcknowledgementArray = jDBCStore.getTransactionAcks((TransactionUID)object2);
                        ((FileStore)store).storeTransaction((TransactionUID)object2, (TransactionInfo)serializable, false);
                        int n6 = transactionAcknowledgementArray.length;
                        for (int i = 0; i < n6; ++i) {
                            ((FileStore)store).storeTransactionAck((TransactionUID)object2, transactionAcknowledgementArray[i], false);
                        }
                    }
                }
                finally {
                    store.close();
                }
            }
            logger.logToAll(8, "Backup persistent store complete.");
        }
        catch (Throwable throwable) {
            throw new BrokerException(br.getString("B3124"));
        }
        finally {
            if (fileStore != null) {
                try {
                    fileStore.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            StoreManager.releaseStore(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRestore() throws BrokerException {
        if (!Globals.getHAEnabled()) {
            throw new BrokerException(br.getKString("B1230", this.dbmgr.getBrokerID()));
        }
        Properties properties = System.getProperties();
        String string = Globals.getClusterID();
        String string2 = (String)properties.get("imq.backupdir") + File.separator + string;
        logger.logToAll(8, "Restore persistent store for HA cluster " + string + " from backup dir: " + string2);
        FileStore fileStore = new FileStore(string2, false);
        JDBCStore jDBCStore = null;
        try {
            Object object;
            this.doRecreate();
            jDBCStore = (JDBCStore)StoreManager.getStore();
            List list = null;
            Properties properties2 = fileStore.getAllProperties();
            for (Map.Entry<Object, Object> objectArray2 : properties2.entrySet()) {
                object = (String)objectArray2.getKey();
                if (((String)object).equals(STORE_PROPERTY_HABROKERS)) {
                    list = (List)objectArray2.getValue();
                    continue;
                }
                jDBCStore.updateProperty((String)object, objectArray2.getValue(), false);
            }
            Iterator<Map.Entry<Object, Object>> iterator = null;
            properties2 = null;
            if (list == null || list.isEmpty()) {
                throw new BrokerException(br.getKString("B4221"));
            }
            Object[] objectArray = fileStore.getAllConfigRecords();
            object = (ArrayList)objectArray[0];
            ArrayList arrayList = (ArrayList)objectArray[1];
            int n = ((ArrayList)object).size();
            for (int i = 0; i < n; ++i) {
                jDBCStore.storeConfigChangeRecord((Long)((ArrayList)object).get(i), (byte[])arrayList.get(i), false);
            }
            Object var9_13 = null;
            object = null;
            arrayList = null;
            Consumer[] consumerArray = fileStore.getAllInterests();
            for (n = 0; n < consumerArray.length; ++n) {
                jDBCStore.storeInterest(consumerArray[n], false);
            }
            consumerArray = null;
            for (HABrokerInfo hABrokerInfo : list) {
                jDBCStore.addBrokerInfo(hABrokerInfo, false);
            }
            for (HABrokerInfo hABrokerInfo : list) {
                String string3 = hABrokerInfo.getId();
                long l = hABrokerInfo.getSessionID();
                logger.logToAll(8, "Restore persistent data for broker " + string3);
                Store store = null;
                try {
                    TransactionAcknowledgement[] transactionAcknowledgementArray;
                    Serializable serializable;
                    Object object22;
                    int n2;
                    store = new FileStore(string2 + File.separator + string3, false);
                    Destination[] destinationArray = ((FileStore)store).getAllDestinations();
                    int n3 = destinationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object22 = destinationArray[n2].getDestinationUID();
                        serializable = jDBCStore.getDestination((DestinationUID)object22);
                        if (serializable != null) continue;
                        jDBCStore.storeDestination(destinationArray[n2], l);
                    }
                    n3 = destinationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object22 = ((FileStore)store).messageEnumeration(destinationArray[n2]);
                        while (object22.hasMoreElements()) {
                            SysMessageID sysMessageID;
                            serializable = destinationArray[n2].getDestinationUID();
                            HashMap hashMap = ((FileStore)store).getInterestStates((DestinationUID)serializable, sysMessageID = (transactionAcknowledgementArray = (TransactionAcknowledgement[])object22.nextElement()).getSysMessageID());
                            if (hashMap == null || hashMap.isEmpty()) {
                                jDBCStore.storeMessage((DestinationUID)serializable, (Packet)transactionAcknowledgementArray, null, null, l, false);
                                continue;
                            }
                            int n4 = hashMap.size();
                            ConsumerUID[] consumerUIDArray = new ConsumerUID[n4];
                            int[] nArray = new int[n4];
                            Iterator iterator2 = hashMap.entrySet().iterator();
                            int n5 = 0;
                            while (iterator2.hasNext()) {
                                Map.Entry entry = iterator2.next();
                                consumerUIDArray[n5] = (ConsumerUID)entry.getKey();
                                nArray[n5] = (Integer)entry.getValue();
                                ++n5;
                            }
                            jDBCStore.storeMessage((DestinationUID)serializable, (Packet)transactionAcknowledgementArray, consumerUIDArray, nArray, l, false);
                        }
                    }
                    Collection collection = ((FileStore)store).getTransactions(string3);
                    for (Object object22 : collection) {
                        serializable = ((FileStore)store).getTransactionInfo((TransactionUID)object22);
                        transactionAcknowledgementArray = ((FileStore)store).getTransactionAcks((TransactionUID)object22);
                        jDBCStore.storeTransaction((TransactionUID)object22, (TransactionInfo)serializable, l);
                        int n6 = transactionAcknowledgementArray.length;
                        for (int i = 0; i < n6; ++i) {
                            jDBCStore.storeTransactionAck((TransactionUID)object22, transactionAcknowledgementArray[i], false);
                        }
                    }
                }
                finally {
                    store.close();
                }
            }
            logger.logToAll(8, "Restore persistent store complete.");
        }
        catch (Throwable throwable) {
            throw new BrokerException(br.getString("B3124"));
        }
        finally {
            if (fileStore != null) {
                try {
                    fileStore.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            StoreManager.releaseStore(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuery() throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            if (Globals.getHAEnabled()) {
                System.out.println(br.getString("B1202", Globals.getBrokerID(), Globals.getClusterID()));
            } else {
                System.out.println(br.getString("B1042"));
            }
            int n = this.dbmgr.checkStoreExists(connection);
            if (n == 0) {
                System.out.println(br.getString("B3132"));
            } else if (n > 0) {
                System.out.println(br.getString("B3210"));
            } else {
                System.out.println(br.getString("B3213"));
            }
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    private boolean printHelp(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(OPT_H) && !stringArray[i].equals(OPT_LH)) continue;
            return true;
        }
        return false;
    }

    private boolean printVersion(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(OPT_V) && !stringArray[i].equals(OPT_LV)) continue;
            return true;
        }
        return false;
    }

    private void checkArg(String string, String string2, int n, int n2) throws ParserException {
        if (n >= n2) {
            ParserException parserException;
            if (string != null) {
                parserException = new ParserException(MISSING_CMD_ARG);
                parserException.cmd = string;
            } else {
                parserException = new ParserException(MISSING_OPT_ARG);
                parserException.opt = string2;
            }
            throw parserException;
        }
    }

    private void throwParserException(int n, String string, String string2, String string3, String string4) throws ParserException {
        ParserException parserException = new ParserException(n);
        parserException.cmd = string;
        parserException.cmdarg = string2;
        parserException.opt = string3;
        parserException.optarg = string4;
        throw parserException;
    }

    private void handleParserException(ParserException parserException) {
        if (parserException.reason == MISSING_CMD_ARG) {
            System.out.println(br.getString("B3083", parserException.cmd));
        } else if (parserException.reason == MISSING_OPT_ARG) {
            System.out.println(br.getString("B3080", parserException.opt));
        } else if (parserException.reason == BAD_CMD_ARG) {
            System.out.println(br.getString("B3078", parserException.cmd, parserException.cmdarg));
        } else if (parserException.reason == BAD_OPT) {
            if (parserException.opt.equals(OPT_P)) {
                System.out.println(br.getString("B3217", parserException.opt));
            } else {
                System.out.println(br.getString("B3079", parserException.opt));
            }
        } else if (parserException.reason == BAD_OPT_ARG) {
            System.out.println(br.getString("B3081", parserException.opt, parserException.optarg));
        } else if (parserException.reason == EXTRA_CMD_SPECIFIED) {
            System.out.println(br.getString("B3077", parserException.cmd));
        }
    }

    private Properties parseArgs(String[] stringArray) throws ParserException {
        Properties properties = System.getProperties();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(CREATE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_ALL)) {
                    properties.put(CMD_NAME, CREATE_ALL_CMD);
                    continue;
                }
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, CREATE_TBL_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, CREATE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(DELETE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, DELETE_TBL_CMD);
                    continue;
                }
                if (stringArray[i].equals(ARGU_OLDTBL)) {
                    properties.put(CMD_NAME, DELETE_TBL_CMD);
                    properties.put(ARG_NAME, ARGU_OLDTBL);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, DELETE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(RECREATE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, RECREATE_TBL_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, RECREATE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(REMOVE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_BKR)) {
                    properties.put(CMD_NAME, REMOVE_BKR_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, REMOVE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(DUMP_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                properties.put(CMD_NAME, DUMP_CMD);
                properties.put(ARG_NAME, stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(DROPTBL_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                properties.put(CMD_NAME, DROPTBL_CMD);
                properties.put(ARG_NAME, stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(RESET_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_LCK)) {
                    properties.put(CMD_NAME, RESET_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, RESET_CMD, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(BACKUP_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(OPT_DIR)) {
                    properties.put(CMD_NAME, BACKUP_CMD);
                    this.checkArg(stringArray[i], null, ++i, stringArray.length);
                    properties.put("imq.backupdir", stringArray[i]);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, BACKUP_CMD, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(RESTORE_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(OPT_DIR)) {
                    properties.put(CMD_NAME, RESTORE_CMD);
                    this.checkArg(stringArray[i], null, ++i, stringArray.length);
                    properties.put("imq.backupdir", stringArray[i]);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, RESTORE_CMD, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(UPGRADE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_STORE)) {
                    properties.put(CMD_NAME, UPGRADE_STORE_CMD);
                    continue;
                }
                if (stringArray[i].equals(ARGU_HASTORE)) {
                    properties.put(CMD_NAME, UPGRADE_HASTORE_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, UPGRADE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(QUERY_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                properties.put(CMD_NAME, QUERY_CMD);
                continue;
            }
            if (stringArray[i].equals(OPT_B)) {
                this.checkArg(null, OPT_B, ++i, stringArray.length);
                properties.put("imq.instancename", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(OPT_N)) {
                this.checkArg(null, OPT_N, ++i, stringArray.length);
                properties.put("imq.brokerid", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(OPT_U)) {
                this.checkArg(null, OPT_U, ++i, stringArray.length);
                properties.put("imq.persist.jdbc.user", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(OPT_PW)) {
                this.checkArg(null, OPT_PW, ++i, stringArray.length);
                properties.put("imq.persist.jdbc.password", stringArray[i]);
                this.cliPasswdSpecified = true;
                continue;
            }
            if (stringArray[i].equals(OPT_PASSFILE)) {
                this.checkArg(null, OPT_PASSFILE, ++i, stringArray.length);
                File file = null;
                try {
                    file = new File(stringArray[i]).getCanonicalFile();
                }
                catch (Exception exception) {
                    this.throwParserException(BAD_OPT, null, null, stringArray[i], null);
                }
                properties.put("imq.passfile.enabled", "true");
                properties.put("imq.passfile.dirpath", file.getParent());
                properties.put("imq.passfile.name", file.getName());
                continue;
            }
            if (stringArray[i].equals(OPT_VERBOSE)) continue;
            if (stringArray[i].equals(OPT_DEBUG)) {
                this.debugSpecified = true;
                continue;
            }
            if (stringArray[i].equals(OPT_FORCE)) {
                this.forceSpecified = true;
                continue;
            }
            if (stringArray[i].equals(OPT_VARHOME)) {
                ++i;
                continue;
            }
            if (stringArray[i].startsWith(OPT_D)) {
                int n = 0;
                String string = null;
                String string2 = "";
                n = stringArray[i].indexOf(61);
                if (stringArray[i].length() <= 2) continue;
                if (n < 0) {
                    string = stringArray[i].substring(2);
                } else if (n == stringArray[i].length() - 1) {
                    string = stringArray[i].substring(2, n);
                } else {
                    string = stringArray[i].substring(2, n);
                    string2 = stringArray[i].substring(n + 1);
                }
                properties.put(string, string2);
                continue;
            }
            this.throwParserException(BAD_OPT, null, null, stringArray[i], null);
        }
        return properties;
    }

    private void parsePassfile() throws FileNotFoundException {
        Properties properties;
        String string = null;
        String string2 = null;
        String string3 = null;
        string3 = config.getProperty("imq.passfile.enabled");
        if (string3 == null || !string3.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return;
        }
        string = config.getProperty("imq.passfile.dirpath");
        string2 = string != null ? (string = StringUtil.expandVariables(string, config)) : config.getProperty("imq.etchome") + File.separator + "security";
        String string4 = string2 + File.separator + config.getProperty("imq.passfile.name");
        File file = new File(string4);
        if (file.exists()) {
            properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(string4);
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                logger.log(32, br.getKString("B4023"), iOException);
            }
        } else {
            throw new FileNotFoundException(br.getKString("B3020", string4));
        }
        config.putAll((Map)properties);
    }

    private void exit(int n) {
        if (this.standalone) {
            DBConnectionPool.reset();
            System.exit(n);
        }
    }

    void doCommand(String[] stringArray) throws SQLException, BrokerException, FileNotFoundException {
        String string;
        String string2;
        String string3;
        if (stringArray.length == 0) {
            System.out.println(this.version.getBanner(true));
            System.out.println(br.getString("B0011"));
            this.exit(0);
        }
        if (this.printHelp(stringArray)) {
            System.out.println(br.getString("B0011"));
            this.exit(0);
        }
        if (this.printVersion(stringArray)) {
            System.out.println(this.version.getBanner(true));
            System.out.println(br.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
            System.out.println(br.getString("B1054") + System.getProperty("java.class.path"));
            this.exit(0);
        }
        Properties properties = null;
        try {
            properties = this.parseArgs(stringArray);
        }
        catch (ParserException parserException) {
            this.handleParserException(parserException);
            this.exit(1);
        }
        properties.setProperty("imq.persist.jdbc.connection.limit", "2");
        if (this.cliPasswdSpecified) {
            System.err.println(br.getString("B2088", OPT_PW));
            System.err.println("");
        }
        if ((string3 = properties.getProperty("imq.instancename")) != null && string3.length() > 0) {
            Globals.pathinit(null);
            string2 = Globals.JMQ_INSTANCES_HOME + File.separator + string3;
            if (!new File(string2).exists()) {
                System.err.println(br.getString("B3119", string3));
                System.exit(1);
            }
        }
        Globals.init(properties, false, false);
        config = Globals.getConfig();
        logger = Globals.getLogger();
        this.parsePassfile();
        string2 = config.getProperty("imq.persist.jdbc.dbVendor");
        String string4 = "imq.persist.jdbc." + string2;
        String string5 = properties.getProperty("imq.persist.jdbc.user");
        if (string5 != null && string5.length() > 0) {
            config.put(string4 + ".user", string5);
        }
        if ((string = properties.getProperty("imq.persist.jdbc.password")) != null && string.length() > 0) {
            config.put(string4 + ".password", string);
        }
        this.dbmgr = DBManager.getDBManager();
        String string6 = properties.getProperty(CMD_NAME);
        String string7 = this.dbmgr.getBrokerID();
        String string8 = CREATE_ALL_CMD.equals(string6) ? this.dbmgr.getCreateDBURL() : this.dbmgr.getOpenDBURL();
        if (string8 == null) {
            string8 = "not specified";
        }
        if ((string5 = this.dbmgr.getUser()) == null) {
            string5 = "not specified";
        }
        Object[] objectArray = new String[]{String.valueOf(410), string7, string8, string5};
        logger.logToAll(8, br.getString("B1067", objectArray));
        if (CREATE_ALL_CMD.equals(string6)) {
            this.doCreate(true);
        } else if (CREATE_TBL_CMD.equals(string6)) {
            this.doCreate(false);
        } else if (DELETE_TBL_CMD.equals(string6)) {
            this.doDelete(properties.getProperty(ARG_NAME));
        } else if (RECREATE_TBL_CMD.equals(string6)) {
            this.doRecreate();
        } else if (REMOVE_BKR_CMD.equals(string6)) {
            this.doRemoveBkr();
        } else if (DUMP_CMD.equals(string6)) {
            String string9 = properties.getProperty(ARG_NAME);
            this.doDump(string9);
        } else if (DROPTBL_CMD.equals(string6)) {
            String string10 = properties.getProperty(ARG_NAME);
            this.doDropTablesByPattern(string10);
        } else if (RESET_CMD.equals(string6)) {
            this.doReset();
        } else if (BACKUP_CMD.equals(string6)) {
            this.doBackup();
        } else if (RESTORE_CMD.equals(string6)) {
            this.doRestore();
        } else if (UPGRADE_STORE_CMD.equals(string6)) {
            this.doUpgrade(false);
        } else if (UPGRADE_HASTORE_CMD.equals(string6)) {
            this.doUpgrade(true);
        } else if (QUERY_CMD.equals(string6)) {
            this.doQuery();
        } else if (string6 == null) {
            System.out.println(br.getString("B3105"));
        } else {
            System.out.println(br.getString("B3104", string6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n = 0;
        DBTool dBTool = new DBTool(true);
        try {
            dBTool.doCommand(stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof BrokerException) {
                logger.log(32, exception.getMessage(), exception.getCause());
            } else {
                logger.log(32, exception.getMessage());
            }
            if (dBTool.debugSpecified) {
                exception.printStackTrace();
            }
            n = 1;
        }
        finally {
            if (dBTool.dbmgr != null) {
                dBTool.dbmgr.close();
            }
        }
        System.exit(n);
    }

    private static class ParserException
    extends Exception {
        String cmd;
        String cmdarg;
        String opt;
        String optarg;
        int reason;

        ParserException(int n) {
            this.reason = n;
        }
    }
}

