/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class StoreSessionDAOImpl
extends BaseDAOImpl
implements StoreSessionDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateIsCurrentSQL;
    protected String takeoverSQL;
    protected String deleteSQL;
    protected String deleteByBrokerSQL;
    protected String deleteInactiveByBrokerSQL;
    protected String selectSQL;
    protected String selectAllSQL;
    protected String selectAllOldSessionsSQL;
    protected String selectCurrentSessionSQL;
    protected String selectPreviousSessionSQL;
    protected String selectIDsByBrokerSQL;
    private volatile long localStoreSessionID = 0L;

    StoreSessionDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQSES41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        this.updateIsCurrentSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("IS_CURRENT").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").toString();
        this.takeoverSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("BROKER_ID").append(" = ?, ").append("CREATED_TS").append(" = ?, ").append("IS_CURRENT").append(" = 0").append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteByBrokerSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
        this.deleteInactiveByBrokerSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").append(" AND NOT EXISTS (").append("SELECT 1 FROM ").append(dBManager.getTableName("MQMSG41")).append(" WHERE ").append("STORE_SESSION_ID").append(" = ?").append(" UNION ").append("SELECT 1 FROM ").append(dBManager.getTableName("MQTXN41")).append(" WHERE ").append("STORE_SESSION_ID").append(" = ?").append(")").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" ORDER BY ").append("BROKER_ID").append(", ").append("CREATED_TS").toString();
        this.selectAllOldSessionsSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("CREATED_TS").append(", ").append("BROKER_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("IS_CURRENT").append(" = 0").toString();
        this.selectCurrentSessionSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").append(" AND ").append("IS_CURRENT").append(" = 1").toString();
        this.selectPreviousSessionSQL = new StringBuffer(128).append("SELECT sTbl.").append("ID").append(", sTbl.").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" sTbl, ").append(dBManager.getTableName("MQBKR41")).append(" bTbl WHERE bTbl.").append("ID").append(" = ?").append(" AND bTbl.").append("ID").append(" = sTbl.").append("CREATED_BY").append(" AND bTbl.").append("TAKEOVER_BROKER").append(" = sTbl.").append("BROKER_ID").append(" ORDER BY sTbl.").append("CREATED_TS").append(" DESC").toString();
        this.selectIDsByBrokerSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
    }

    public final String getTableNamePrefix() {
        return "MQSES41";
    }

    public final String getTableName() {
        return this.tableName;
    }

    public void insert(Connection connection, String string, long l) throws BrokerException {
        block16: {
            PreparedStatement preparedStatement;
            block15: {
                boolean bl = false;
                preparedStatement = null;
                String string2 = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    long l2 = -1L;
                    string2 = this.selectCurrentSessionSQL;
                    preparedStatement = connection.prepareStatement(string2);
                    preparedStatement.setString(1, string);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        l2 = resultSet.getLong(1);
                    }
                    resultSet.close();
                    preparedStatement.close();
                    if (l2 != l) {
                        if (l2 > 0L) {
                            string2 = this.updateIsCurrentSQL;
                            preparedStatement = connection.prepareStatement(string2);
                            preparedStatement.setInt(1, 0);
                            preparedStatement.setLong(2, l2);
                            preparedStatement.executeUpdate();
                            preparedStatement.close();
                        }
                        this.insert(connection, string, l, 1, string, System.currentTimeMillis());
                    }
                    if (bl) {
                        connection.commit();
                    }
                    if (!bl) break block15;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4276", String.valueOf(l)), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block16;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void insert(Connection connection, String string, long l, int n, String string2, long l2) throws BrokerException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.insertSQL);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            preparedStatement.setInt(3, n);
            preparedStatement.setString(4, string2);
            preparedStatement.setLong(5, l2);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4276", String.valueOf(l)), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public List takeover(Connection connection, String string, String string2) throws BrokerException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string3 = null;
        PreparedStatement preparedStatement = null;
        try {
            string3 = this.selectIDsByBrokerSQL;
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(1);
                arrayList.add(l);
            }
            resultSet.close();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.takeoverSQL);
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, System.currentTimeMillis());
            preparedStatement.setString(3, string2);
            int n = preparedStatement.executeUpdate();
            if (n != arrayList.size()) {
                throw new BrokerException(this.br.getKString("B3174", string2));
            }
        }
        catch (Exception exception) {
            try {
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080", sQLException);
                }
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.takeoverSQL + "]", (SQLException)exception) : exception;
                throw new BrokerException(this.br.getKString("B3174", string2), exception2);
            }
            catch (Throwable throwable) {
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(null, preparedStatement, null);
        return arrayList;
    }

    public void delete(Connection connection, long l) throws BrokerException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.deleteSQL);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4277", String.valueOf(l)), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void deleteByBrokerID(Connection connection, String string) throws BrokerException {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.deleteByBrokerSQL);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteByBrokerSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4280", string), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void deleteAll(Connection connection) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(connection);
    }

    public void deleteInactiveStoreSession(Connection connection) throws BrokerException {
        block14: {
            PreparedStatement preparedStatement;
            block13: {
                boolean bl = false;
                preparedStatement = null;
                try {
                    String string;
                    long l;
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    HashMap<Long, String> hashMap = new HashMap<Long, String>();
                    long l2 = System.currentTimeMillis();
                    preparedStatement = connection.prepareStatement(this.selectAllOldSessionsSQL);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        long l3 = resultSet.getLong(1);
                        l = resultSet.getLong(2);
                        string = resultSet.getString(3);
                        if (l2 <= l + 1800000L) continue;
                        hashMap.put(new Long(l3), string);
                    }
                    resultSet.close();
                    if (!hashMap.isEmpty()) {
                        preparedStatement.close();
                        preparedStatement = connection.prepareStatement(this.deleteInactiveByBrokerSQL);
                        for (Map.Entry entry : hashMap.entrySet()) {
                            l = (Long)entry.getKey();
                            string = (String)entry.getValue();
                            try {
                                preparedStatement.setLong(1, l);
                                preparedStatement.setLong(2, l);
                                preparedStatement.setLong(3, l);
                                if (preparedStatement.executeUpdate() <= 0) continue;
                                this.logger.log(8, this.br.getString("B1254", String.valueOf(l), string));
                            }
                            catch (SQLException sQLException) {
                                SQLException sQLException2 = DBManager.wrapSQLException("[" + this.deleteInactiveByBrokerSQL + "]", sQLException);
                                this.logger.logStack(32, "B4279", l, string, sQLException2);
                            }
                        }
                    }
                    if (!bl) break block13;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        throw new BrokerException(this.br.getKString("B4166", this.selectAllOldSessionsSQL), exception);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block14;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public long getStoreSession(Connection connection, String string) throws BrokerException {
        long l;
        boolean bl;
        block12: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block11: {
                DBManager dBManager = DBManager.getDBManager();
                bl = dBManager.getBrokerID().equals(string);
                if (bl && this.localStoreSessionID > 0L) {
                    return this.localStoreSessionID;
                }
                l = 0L;
                boolean bl2 = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectCurrentSessionSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        l = resultSet.getLong(1);
                    }
                    if (!bl2) break block11;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectCurrentSessionSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4281", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block12;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        if (bl && this.localStoreSessionID == 0L) {
            this.localStoreSessionID = l;
        }
        return l;
    }

    public String getStoreSessionOwner(Connection connection, long l) throws BrokerException {
        String string;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                string = null;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        string = resultSet.getString("BROKER_ID");
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4278", String.valueOf(l)), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return string;
    }

    public String getStoreSessionCreator(Connection connection, long l) throws BrokerException {
        String string;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                string = null;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        string = resultSet.getString("CREATED_BY");
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4278", String.valueOf(l)), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return string;
    }

    public Map getAllStoreSessions(Connection connection) throws BrokerException {
        HashMap<String, ArrayList<HABrokerInfo.StoreSession>> hashMap;
        block11: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block10: {
                hashMap = new HashMap<String, ArrayList<HABrokerInfo.StoreSession>>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        long l = resultSet.getLong(1);
                        String string = resultSet.getString(2);
                        int n = resultSet.getInt(3);
                        String string2 = resultSet.getString(4);
                        long l2 = resultSet.getLong(5);
                        ArrayList<HABrokerInfo.StoreSession> arrayList = (ArrayList<HABrokerInfo.StoreSession>)hashMap.get(string);
                        if (arrayList == null) {
                            arrayList = new ArrayList<HABrokerInfo.StoreSession>();
                            hashMap.put(string, arrayList);
                        }
                        arrayList.add(new HABrokerInfo.StoreSession(l, string, n, string2, l2));
                    }
                    if (!bl) break block10;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4283"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block11;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return hashMap;
    }

    public List getStoreSessionsByBroker(Connection connection, String string) throws BrokerException {
        ArrayList<Long> arrayList;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                arrayList = new ArrayList<Long>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectIDsByBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        long l = resultSet.getLong(1);
                        arrayList.add(l);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectIDsByBrokerSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4282", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return arrayList;
    }

    public boolean isCurrent(Connection connection, long l) throws BrokerException {
        boolean bl;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                bl = false;
                boolean bl2 = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next() && resultSet.getInt("IS_CURRENT") == 1) {
                        bl = true;
                    }
                    if (!bl2) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4278", String.valueOf(l)), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap getDebugInfo(Connection connection) {
        StringBuffer stringBuffer;
        HashMap<String, String> hashMap;
        block16: {
            hashMap = new HashMap<String, String>();
            stringBuffer = new StringBuffer(512);
            boolean bl = false;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.selectAllSQL);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(5);
                stringBuffer.append("(").append("sessionID=").append(resultSet.getLong(1)).append(", brokerID=").append(resultSet.getString(2)).append(", isCurrent=").append(resultSet.getInt(3) == 1).append(", createdBy=").append(resultSet.getString(4)).append(", createdTS=").append(l).append(l > 0L ? " [" + new Date(l) + "]" : "").append(")").append(BrokerResources.NL);
            }
            try {
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    break block16;
                }
                Util.close(resultSet, preparedStatement, null);
            }
            catch (BrokerException brokerException) {
                this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
            }
            break block16;
            catch (Exception exception) {
                try {
                    this.logger.log(32, "B4166", (Object)this.selectAllSQL, (Throwable)exception);
                }
                catch (Throwable throwable) {
                    try {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                    }
                    throw throwable;
                }
                try {
                    if (bl) {
                        Util.close(resultSet, preparedStatement, connection);
                    }
                    Util.close(resultSet, preparedStatement, null);
                }
                catch (BrokerException brokerException) {
                    this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                }
            }
        }
        hashMap.put("Store Session(" + this.tableName + ")", stringBuffer.toString());
        return hashMap;
    }
}

