/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)BrokerErrorEvent.java	1.4 06/27/07
 */ 

package com.sun.messaging.jmq.admin.apps.console.event;

import java.util.EventObject;

/**
 * Events related to reporting any kind of unexpected
 * errors and/or exceptions.
 */
public class BrokerErrorEvent extends AdminEvent {
    /*
     * Error type
     */
    public final static int	UNEXPECTED_SHUTDOWN	= 0;
    public final static int	ALT_SHUTDOWN		= 1;
    public final static int	CONNECTION_ERROR	= 2;

    private String brokerHost = null;
    private String brokerPort = null;
    private String brokerName = null;

    /**
     * Creates an instance of BrokerErrorEvent
     * @param source the object where the event originated
     */
    public BrokerErrorEvent(Object source, int type) {
	super(source, type);
    }

    public String getBrokerHost() {
	return brokerHost;
    }

    public void setBrokerHost(String host) {
	this.brokerHost = host;
    }

    public String getBrokerPort() {
	return brokerPort;
    }

    public void setBrokerPort(String port) {
	this.brokerPort = port;
    }

    public String getBrokerName() {
	return brokerName;
    }

    public void setBrokerName(String name) {
	this.brokerName = name;
    }
}
