/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)BrokerAdminUtil.java	1.4 06/27/07
 */ 

package com.sun.messaging.jmq.admin.bkrutil;

import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.util.DestType;

/**
 * Class containing useful methods for broker administration.
 */
public class BrokerAdminUtil {

    private static AdminResources ar = Globals.getAdminResources();

    public static String getDestinationType(int mask) {
        if (DestType.isTopic(mask))
            return ar.getString(ar.I_TOPIC);
        else if (DestType.isQueue(mask))
            return ar.getString(ar.I_QUEUE);
        else
            return ar.getString(ar.I_UNKNOWN);
    }

    public static String getDestinationFlavor(int mask) {
        if (DestType.isTopic(mask))
            return "-";
        else if (DestType.isSingle(mask))
            return ar.getString(ar.I_SINGLE);
        else if (DestType.isRRobin(mask))
            return ar.getString(ar.I_RROBIN);
        else if (DestType.isFailover(mask))
            return ar.getString(ar.I_FAILOVER);
        else if (DestType.isQueue(mask))
            return ar.getString(ar.I_SINGLE);  // This is the default
        else
            return ar.getString(ar.I_UNKNOWN);
    }

    public static String getActiveConsumers(int mask, int value) {
        if (DestType.isTopic(mask))
            return "-";
        else {
	    if (value == -1) 
		return ar.getString(ar.I_UNLIMITED);
	    else
	    	return new Integer(value).toString();
	}
    }

    public static String getFailoverConsumers(int mask, int value) {
        if (DestType.isTopic(mask))
            return "-";
        else {
	    if (value == -1) 
		return ar.getString(ar.I_UNLIMITED);
	    else
	    	return new Integer(value).toString();
	}
    }
}
