/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)JesmfManager.java	1.4 06/28/07
 */ 

package com.sun.messaging.jmq.jmsserver.management.agent;

import com.sun.messaging.jmq.jmsserver.core.Destination;

/**
 * Manager class for MQ/JESMF integration.
 *
 * The methods here are used by the JMX agent to control/initialize
 * the JESMF infrastructure and relevant objects. Some JESMF objects
 * map directly to or have data contained in some MQ MBeans. Because
 * of this, their lifecycle should be closely tied together - this is
 * the reason for having various register/unregister methods here.
 *
 * Some JESMF objects don't have corresponding MQ MBeans, which is why
 * we don't have register/unregister methods for them here e.g.
 * PersistenceStore and UserRepository.
 */
public interface JesmfManager {
    public void initialize(Agent agent);
    public void stop();
    public boolean isActive();

    public void registerPortmapper();
    public void unregisterPortmapper();
    public void portMapperPortUpdated(Integer oldPort, Integer newPort);

    public void registerService(String serviceName);
    public void unregisterService(String serviceName);
    public void serviceStateChanged(String svcName);
    public void serviceAttrUpdated(String svcName, 
		    String attrName, Object oldVal, Object newVal);

    public void registerDestination(Destination d);
    public void unregisterDestination(Destination d);
    public void destinationStateChanged(Destination d);
    public void destinationAttrUpdated(Destination d, int attr, 
		    Object oldVal, Object newVal);
}
