/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.impl;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateConverter {
    private static final SimpleDateFormat PDF_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final SimpleDateFormat[] POTENTIAL_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("EEEE, dd MMM yyyy hh:mm:ss a"), new SimpleDateFormat("EEEE, MMM dd, yyyy hh:mm:ss a"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz")};
    private static final SimpleDateFormat ISO_8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    private DateConverter() {
    }

    public static String toString(Calendar date) {
        String retval = null;
        if (date != null) {
            StringBuffer buffer = new StringBuffer();
            TimeZone zone = date.getTimeZone();
            long offsetInMinutes = zone.getOffset(date.getTimeInMillis()) / 1000 / 60;
            long hours = Math.abs(offsetInMinutes / 60L);
            long minutes = Math.abs(offsetInMinutes % 60L);
            buffer.append("D:");
            buffer.append(PDF_DATE_FORMAT.format(date.getTime()));
            if (offsetInMinutes == 0L) {
                buffer.append("Z");
            } else if (offsetInMinutes < 0L) {
                buffer.append("-");
            } else {
                buffer.append("+");
            }
            if (hours < 10L) {
                buffer.append("0");
            }
            buffer.append(hours);
            buffer.append("'");
            if (minutes < 10L) {
                buffer.append("0");
            }
            buffer.append(minutes);
            buffer.append("'");
            retval = buffer.toString();
        }
        return retval;
    }

    public static Calendar toCalendar(String date) throws IOException {
        GregorianCalendar retval;
        block19: {
            retval = null;
            if (date != null && date.trim().length() > 0) {
                int year = 0;
                int month = 1;
                int day = 1;
                int hour = 0;
                int minute = 0;
                int second = 0;
                try {
                    SimpleTimeZone zone = null;
                    if (date.startsWith("D:")) {
                        date = date.substring(2, date.length());
                    }
                    if ((date = date.replaceAll("[-:T]", "")).length() < 4) {
                        throw new IOException("Error: Invalid date format '" + date + "'");
                    }
                    year = Integer.parseInt(date.substring(0, 4));
                    if (date.length() >= 6) {
                        month = Integer.parseInt(date.substring(4, 6));
                    }
                    if (date.length() >= 8) {
                        day = Integer.parseInt(date.substring(6, 8));
                    }
                    if (date.length() >= 10) {
                        hour = Integer.parseInt(date.substring(8, 10));
                    }
                    if (date.length() >= 12) {
                        minute = Integer.parseInt(date.substring(10, 12));
                    }
                    if (date.length() >= 14) {
                        second = Integer.parseInt(date.substring(12, 14));
                    }
                    retval = new GregorianCalendar(year, month - 1, day, hour, minute, second);
                    if (date.length() >= 15) {
                        char sign = date.charAt(14);
                        if (sign == 'Z') {
                            zone = new SimpleTimeZone(0, "Unknown");
                        } else {
                            int hours = 0;
                            int minutes = 0;
                            if (date.length() >= 17) {
                                hours = sign == '+' ? Integer.parseInt(date.substring(15, 17)) : Integer.parseInt(date.substring(14, 17));
                            }
                            if (date.length() >= 19) {
                                minutes = Integer.parseInt(date.substring(17, 19));
                            }
                            zone = new SimpleTimeZone(hours * 60 * 60 * 1000 + minutes * 60 * 1000, "Unknown");
                        }
                        ((Calendar)retval).setTimeZone(zone);
                    }
                }
                catch (NumberFormatException e) {
                    if (date.substring(date.length() - 3, date.length() - 2).equals(":") && (date.substring(date.length() - 6, date.length() - 5).equals("+") || date.substring(date.length() - 6, date.length() - 5).equals("-"))) {
                        date = date.substring(0, date.length() - 3) + date.substring(date.length() - 2);
                    }
                    for (int i = 0; retval == null && i < POTENTIAL_FORMATS.length; ++i) {
                        try {
                            Date utilDate = POTENTIAL_FORMATS[i].parse(date);
                            retval = new GregorianCalendar();
                            retval.setTime(utilDate);
                            continue;
                        }
                        catch (ParseException pe) {
                            // empty catch block
                        }
                    }
                    if (retval != null) break block19;
                    throw new IOException("Error converting date:" + date);
                }
            }
        }
        return retval;
    }

    public static String toISO8601(Calendar cal) {
        StringBuffer retval = new StringBuffer();
        retval.append(ISO_8601_DATE_FORMAT.format(cal.getTime()));
        int timeZone = cal.get(15) + cal.get(16);
        if (timeZone < 0) {
            retval.append("-");
        } else {
            retval.append("+");
        }
        timeZone = Math.abs(timeZone);
        int hours = timeZone / 1000 / 60 / 60;
        int minutes = (timeZone - hours * 1000 * 60 * 60) / 1000 / 1000;
        if (hours < 10) {
            retval.append("0");
        }
        retval.append(Integer.toString(hours));
        retval.append(":");
        if (minutes < 10) {
            retval.append("0");
        }
        retval.append(Integer.toString(minutes));
        return retval.toString();
    }
}

