/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.searchengine.lucene;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.util.PDFTextStripper;

public final class LucenePDFDocument {
    private static final char FILE_SEPARATOR = System.getProperty("file.separator").charAt(0);
    private DateTools.Resolution dateTimeResolution = DateTools.Resolution.SECOND;
    private PDFTextStripper stripper = null;
    static /* synthetic */ Class class$org$pdfbox$searchengine$lucene$LucenePDFDocument;

    public void setTextStripper(PDFTextStripper aStripper) {
        this.stripper = aStripper;
    }

    public DateTools.Resolution getDateTimeResolution() {
        return this.dateTimeResolution;
    }

    public void setDateTimeResolution(DateTools.Resolution resolution) {
        this.dateTimeResolution = resolution;
    }

    private String timeToString(long time) {
        return DateTools.timeToString((long)time, (DateTools.Resolution)this.dateTimeResolution);
    }

    private void addKeywordField(Document document, String name, String value) {
        if (value != null) {
            document.add(new Field(name, value, Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
    }

    private void addTextField(Document document, String name, Reader value) {
        if (value != null) {
            document.add(new Field(name, value));
        }
    }

    private void addTextField(Document document, String name, String value) {
        if (value != null) {
            document.add(new Field(name, value, Field.Store.YES, Field.Index.TOKENIZED));
        }
    }

    private void addTextField(Document document, String name, Date value) {
        if (value != null) {
            this.addTextField(document, name, DateTools.dateToString((Date)value, (DateTools.Resolution)this.dateTimeResolution));
        }
    }

    private void addTextField(Document document, String name, Calendar value) {
        if (value != null) {
            this.addTextField(document, name, value.getTime());
        }
    }

    private static void addUnindexedField(Document document, String name, String value) {
        if (value != null) {
            document.add(new Field(name, value, Field.Store.YES, Field.Index.NO));
        }
    }

    private void addUnstoredKeywordField(Document document, String name, String value) {
        if (value != null) {
            document.add(new Field(name, value, Field.Store.NO, Field.Index.UN_TOKENIZED));
        }
    }

    public Document convertDocument(InputStream is) throws IOException {
        Document document = new Document();
        this.addContent(document, is, "<inputstream>");
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document convertDocument(File file) throws IOException {
        Document document = new Document();
        LucenePDFDocument.addUnindexedField(document, "path", file.getPath());
        LucenePDFDocument.addUnindexedField(document, "url", file.getPath().replace(FILE_SEPARATOR, '/'));
        this.addKeywordField(document, "modified", this.timeToString(file.lastModified()));
        String uid = file.getPath().replace(FILE_SEPARATOR, '\u0000') + "\u0000" + this.timeToString(file.lastModified());
        this.addUnstoredKeywordField(document, "uid", uid);
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            this.addContent(document, input, file.getPath());
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document convertDocument(URL url) throws IOException {
        Document document = new Document();
        URLConnection connection = url.openConnection();
        connection.connect();
        LucenePDFDocument.addUnindexedField(document, "url", url.toExternalForm());
        this.addKeywordField(document, "modified", this.timeToString(connection.getLastModified()));
        String uid = url.toExternalForm().replace(FILE_SEPARATOR, '\u0000') + "\u0000" + this.timeToString(connection.getLastModified());
        this.addUnstoredKeywordField(document, "uid", uid);
        InputStream input = null;
        try {
            input = connection.getInputStream();
            this.addContent(document, input, url.toExternalForm());
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return document;
    }

    public static Document getDocument(InputStream is) throws IOException {
        LucenePDFDocument converter = new LucenePDFDocument();
        return converter.convertDocument(is);
    }

    public static Document getDocument(File file) throws IOException {
        LucenePDFDocument converter = new LucenePDFDocument();
        return converter.convertDocument(file);
    }

    public static Document getDocument(URL url) throws IOException {
        LucenePDFDocument converter = new LucenePDFDocument();
        return converter.convertDocument(url);
    }

    private void addContent(Document document, InputStream is, String documentLocation) throws IOException {
        PDDocument pdfDocument = null;
        try {
            pdfDocument = PDDocument.load(is);
            if (pdfDocument.isEncrypted()) {
                pdfDocument.decrypt("");
            }
            StringWriter writer = new StringWriter();
            if (this.stripper == null) {
                this.stripper = new PDFTextStripper();
            } else {
                this.stripper.resetEngine();
            }
            this.stripper.writeText(pdfDocument, (Writer)writer);
            String contents = writer.getBuffer().toString();
            StringReader reader = new StringReader(contents);
            this.addTextField(document, "contents", reader);
            PDDocumentInformation info = pdfDocument.getDocumentInformation();
            if (info != null) {
                this.addTextField(document, "Author", info.getAuthor());
                this.addTextField(document, "CreationDate", info.getCreationDate());
                this.addTextField(document, "Creator", info.getCreator());
                this.addTextField(document, "Keywords", info.getKeywords());
                this.addTextField(document, "ModificationDate", info.getModificationDate());
                this.addTextField(document, "Producer", info.getProducer());
                this.addTextField(document, "Subject", info.getSubject());
                this.addTextField(document, "Title", info.getTitle());
                this.addTextField(document, "Trapped", info.getTrapped());
            }
            int summarySize = Math.min(contents.length(), 500);
            String summary = contents.substring(0, summarySize);
            LucenePDFDocument.addUnindexedField(document, "summary", summary);
        }
        catch (CryptographyException e) {
            throw new IOException("Error decrypting document(" + documentLocation + "): " + e);
        }
        catch (InvalidPasswordException e) {
            throw new IOException("Error: The document(" + documentLocation + ") is encrypted and will not be indexed.");
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            String us = (class$org$pdfbox$searchengine$lucene$LucenePDFDocument == null ? (class$org$pdfbox$searchengine$lucene$LucenePDFDocument = LucenePDFDocument.class$("org.pdfbox.searchengine.lucene.LucenePDFDocument")) : class$org$pdfbox$searchengine$lucene$LucenePDFDocument).getName();
            System.err.println("usage: java " + us + " <pdf-document>");
            System.exit(1);
        }
        System.out.println("Document=" + LucenePDFDocument.getDocument(new File(args[0])));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

