/*
 * Decompiled with CFR 0.152.
 */
package spin.off;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.SwingUtilities;
import spin.off.Dispatcher;
import spin.off.DispatcherFactory;

public class AWTReflectDispatcherFactory
implements DispatcherFactory {
    private static Class conditionalClass;
    private static Method pumpMethod;

    public Dispatcher createDispatcher() {
        return new AWTReflectDispatcher();
    }

    static {
        try {
            conditionalClass = Class.forName("java.awt.Conditional");
            pumpMethod = Class.forName("java.awt.EventDispatchThread").getDeclaredMethod("pumpEvents", conditionalClass);
            pumpMethod.setAccessible(true);
        }
        catch (Exception ex) {
            throw new Error(ex.getMessage());
        }
    }

    private class AWTReflectDispatcher
    implements Dispatcher,
    InvocationHandler {
        private boolean stopDispatching = false;

        private AWTReflectDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() throws Throwable {
            try {
                Object conditional = Proxy.newProxyInstance(conditionalClass.getClassLoader(), new Class[]{conditionalClass}, (InvocationHandler)this);
                pumpMethod.invoke((Object)Thread.currentThread(), conditional);
                AWTReflectDispatcher aWTReflectDispatcher = this;
                synchronized (aWTReflectDispatcher) {
                    while (!this.stopDispatching) {
                        this.wait();
                    }
                }
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            AWTReflectDispatcher aWTReflectDispatcher = this;
            synchronized (aWTReflectDispatcher) {
                this.stopDispatching = true;
                this.notifyAll();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                }
            });
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.stopDispatching) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }
}

